/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.aries.jndi.spi.EnvironmentAugmentation;
import org.apache.aries.jndi.startup.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static final Comparator<ServiceReference> SERVICE_REFERENCE_COMPARATOR = new ServiceReferenceComparator();

    private Utils() {
        throw new RuntimeException();
    }

    public static BundleContext getBundleContext(final Map<?, ?> env, final String namingClass) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleContext>(){

            @Override
            public BundleContext run() {
                return Utils.doGetBundleContext(env, namingClass);
            }
        });
    }

    private static BundleContext doGetBundleContext(Map<?, ?> env, String namingClass) {
        Object bc;
        BundleContext result = null;
        Object v0 = bc = env == null ? null : env.get("osgi.service.jndi.bundleContext");
        if (bc != null && bc instanceof BundleContext) {
            result = bc;
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = Utils.getBundleContext(cl);
        }
        if (result == null) {
            StackFinder finder = new StackFinder();
            Class<?>[] classStack = finder.getClassContext();
            int indexOfConstructor = -1;
            for (int i = 0; i < classStack.length; ++i) {
                if (!classStack[i].getName().equals(namingClass)) continue;
                indexOfConstructor = i;
            }
            if (indexOfConstructor >= 0 && indexOfConstructor + 1 < classStack.length) {
                Class<?> callerClass = classStack[indexOfConstructor + 1];
                result = Utils.getBundleContext(callerClass.getClassLoader());
            }
        }
        return result;
    }

    private static BundleContext getBundleContext(ClassLoader cl2) {
        ClassLoader cl = cl2;
        BundleContext result = null;
        while (result == null && cl != null) {
            if (cl instanceof BundleReference) {
                result = ((BundleReference)cl).getBundle().getBundleContext();
                continue;
            }
            if (cl == null) continue;
            cl = cl.getParent();
        }
        return result;
    }

    public static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    public static Hashtable<?, ?> toHashtable(Map<?, ?> map) {
        Hashtable<Object, Object> env = map instanceof Hashtable ? (Hashtable)map : (map == null ? new Hashtable() : new Hashtable(map));
        return env;
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws Exception {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            throw cause;
        }
    }

    public static <T> T doPrivilegedNaming(PrivilegedExceptionAction<T> action) throws NamingException {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            NamingException ex = new NamingException(cause.getMessage());
            ex.initCause(cause);
            throw ex;
        }
    }

    public static void augmentEnvironment(Hashtable<?, ?> environment) {
        Object[] objects = Activator.getEnvironmentAugmentors();
        if (objects != null) {
            for (Object obj : objects) {
                if (!(obj instanceof EnvironmentAugmentation)) continue;
                ((EnvironmentAugmentation)obj).augmentEnvironment(environment);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceReferenceComparator
    implements Comparator<ServiceReference> {
        private ServiceReferenceComparator() {
        }

        @Override
        public int compare(ServiceReference o1, ServiceReference o2) {
            return o2.compareTo((Object)o1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackFinder
    extends SecurityManager {
        private StackFinder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

