/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import org.apache.aries.jpa.container.impl.DestroyCallback;
import org.apache.aries.jpa.container.impl.EntityManagerFactoryManager;
import org.apache.aries.jpa.container.impl.EntityManagerWrapper;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CountingEntityManagerFactory
implements EntityManagerFactory,
DestroyCallback {
    private final AtomicLong count = new AtomicLong(0L);
    private final EntityManagerFactory delegate;
    private final String name;
    private final AtomicReference<EntityManagerFactoryManager.NamedCallback> callback = new AtomicReference();
    private final AtomicReference<ServiceRegistration> reg = new AtomicReference();

    public CountingEntityManagerFactory(EntityManagerFactory containerEntityManagerFactory, String name) {
        this.delegate = containerEntityManagerFactory;
        this.name = name;
    }

    public void close() {
        this.delegate.close();
    }

    public EntityManager createEntityManager() {
        EntityManager em = this.delegate.createEntityManager();
        this.count.incrementAndGet();
        return new EntityManagerWrapper(em, this);
    }

    public EntityManager createEntityManager(Map arg0) {
        EntityManager em = this.delegate.createEntityManager(arg0);
        this.count.incrementAndGet();
        return new EntityManagerWrapper(em, this);
    }

    public Cache getCache() {
        return this.delegate.getCache();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.delegate.getMetamodel();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.delegate.getPersistenceUnitUtil();
    }

    public Map<String, Object> getProperties() {
        return this.delegate.getProperties();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public void quiesce(EntityManagerFactoryManager.NamedCallback callback, ServiceRegistration reg) {
        this.reg.compareAndSet(null, reg);
        this.callback.compareAndSet(null, callback);
        if (this.count.get() == 0L) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.reg.getAndSet(null));
            this.callback.set(null);
            callback.callback(this.name);
        }
    }

    @Override
    public void callback() {
        EntityManagerFactoryManager.NamedCallback c;
        if (this.count.decrementAndGet() == 0L && (c = (EntityManagerFactoryManager.NamedCallback)this.callback.getAndSet(null)) != null) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.reg.getAndSet(null));
            c.callback(this.name);
        }
    }

    public void clearQuiesce() {
        this.reg.set(null);
        EntityManagerFactoryManager.NamedCallback c = this.callback.getAndSet(null);
        if (c != null) {
            c.callback(this.name);
        }
    }
}

