/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.apache.aries.jpa.container.ManagedPersistenceUnitInfo;
import org.apache.aries.jpa.container.impl.CountingEntityManagerFactory;
import org.apache.aries.jpa.container.impl.DestroyCallback;
import org.apache.aries.jpa.container.impl.InvalidPersistenceUnitException;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerFactoryManager
implements ServiceTrackerCustomizer {
    private final BundleContext containerContext;
    private final Bundle bundle;
    private ServiceReference provider;
    private Map<String, ? extends ManagedPersistenceUnitInfo> persistenceUnits;
    private Collection<ParsedPersistenceUnit> parsedData;
    private Map<String, CountingEntityManagerFactory> emfs = null;
    private ConcurrentMap<String, ServiceRegistration> registrations = null;
    private boolean quiesce = false;
    private volatile ServiceTracker tracker;
    private final ConcurrentMap<String, Collection<String>> dataSourceFactories = new ConcurrentHashMap<String, Collection<String>>();
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");

    public EntityManagerFactoryManager(BundleContext containerCtx, Bundle b, Collection<ParsedPersistenceUnit> parsedUnits, ServiceReference ref, Collection<? extends ManagedPersistenceUnitInfo> infos) {
        this.containerContext = containerCtx;
        this.bundle = b;
        this.provider = ref;
        this.persistenceUnits = this.getInfoMap(infos);
        this.parsedData = parsedUnits;
    }

    private Map<String, ? extends ManagedPersistenceUnitInfo> getInfoMap(Collection<? extends ManagedPersistenceUnitInfo> infos) {
        Map<String, ManagedPersistenceUnitInfo> map = Collections.synchronizedMap(new HashMap());
        if (infos != null) {
            for (ManagedPersistenceUnitInfo managedPersistenceUnitInfo : infos) {
                map.put(managedPersistenceUnitInfo.getPersistenceUnitInfo().getPersistenceUnitName(), managedPersistenceUnitInfo);
            }
        }
        return map;
    }

    public synchronized boolean providerRemoved(ServiceReference ref) {
        boolean toReturn = this.provider.equals(ref);
        if (toReturn) {
            this.destroy();
        }
        return toReturn;
    }

    public synchronized void bundleStateChange() throws InvalidPersistenceUnitException {
        switch (this.bundle.getState()) {
            case 4: {
                this.unregisterEntityManagerFactories();
                this.createEntityManagerFactories();
                break;
            }
            case 8: 
            case 32: {
                if (this.tracker == null) {
                    this.tracker = new ServiceTracker(this.bundle.getBundleContext(), "org.osgi.service.jdbc.DataSourceFactory", (ServiceTrackerCustomizer)this);
                    this.tracker.open();
                }
                this.registerEntityManagerFactories();
                break;
            }
            case 16: {
                this.quiesce = false;
                if (this.tracker != null) {
                    this.tracker.close();
                    this.tracker = null;
                }
                this.unregisterEntityManagerFactories();
                break;
            }
            case 2: {
                this.destroyEntityManagerFactories();
            }
        }
    }

    private void unregisterEntityManagerFactories() {
        if (this.registrations != null) {
            for (Map.Entry entry : this.registrations.entrySet()) {
                AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)((ServiceRegistration)entry.getValue()));
                this.emfs.get(entry.getKey()).clearQuiesce();
                this.persistenceUnits.get(entry.getKey()).unregistered();
            }
            this.registrations = null;
        }
    }

    private void unregisterEntityManagerFactory(String unit) {
        if (this.registrations != null) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)((ServiceRegistration)this.registrations.remove(unit)));
            this.emfs.get(unit).clearQuiesce();
            this.persistenceUnits.get(unit).unregistered();
        }
    }

    private void registerEntityManagerFactories() throws InvalidPersistenceUnitException {
        if (this.registrations == null) {
            this.registrations = new ConcurrentHashMap<String, ServiceRegistration>();
        }
        if (this.provider != null && !this.quiesce) {
            this.createEntityManagerFactories();
            String providerName = (String)this.provider.getProperty("javax.persistence.provider");
            if (providerName == null) {
                _logger.warn(NLS.MESSAGES.getMessage("no.provider.specified", new Object[]{this.bundle.getSymbolicName() + '/' + this.bundle.getVersion(), "osgi.unit.provider", this.provider}));
            }
            for (Map.Entry<String, CountingEntityManagerFactory> entry : this.emfs.entrySet()) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                String unitName = entry.getKey();
                if (this.registrations.containsKey(unitName) || !this.availableDataSourceFactory(unitName)) continue;
                props.put("osgi.unit.name", unitName);
                if (providerName != null) {
                    props.put("osgi.unit.provider", providerName);
                }
                props.put("osgi.unit.version", this.bundle.getVersion());
                props.put("org.apache.aries.jpa.container.managed", Boolean.TRUE);
                props.put("org.apache.aries.jpa.default.unit.name", "".equals(unitName));
                try {
                    this.registrations.put(unitName, this.bundle.getBundleContext().registerService(EntityManagerFactory.class.getCanonicalName(), (Object)entry.getValue(), props));
                    this.persistenceUnits.get(unitName).registered();
                }
                catch (Exception e) {
                    _logger.error(NLS.MESSAGES.getMessage("cannot.register.persistence.unit", new Object[]{unitName, this.bundle.getSymbolicName() + '/' + this.bundle.getVersion()}));
                    throw new InvalidPersistenceUnitException(e);
                }
            }
        }
    }

    private boolean availableDataSourceFactory(String unitName) {
        ManagedPersistenceUnitInfo mpui = this.persistenceUnits.get(unitName);
        String driver = (String)mpui.getPersistenceUnitInfo().getProperties().get("org.apache.aries.jpa.data.source.factory.class");
        if (Boolean.parseBoolean((String)mpui.getContainerProperties().get("org.apache.aries.jpa.use.data.source.factory")) && driver != null) {
            if (this.dataSourceFactories.containsKey(driver)) {
                ((Collection)this.dataSourceFactories.get(driver)).add(unitName);
                if (_logger.isDebugEnabled()) {
                    _logger.debug(NLS.MESSAGES.getMessage("datasourcefactory.found", new Object[]{unitName, this.bundle.getSymbolicName(), this.bundle.getVersion(), driver}));
                }
                return true;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("datasourcefactory.not.found", new Object[]{unitName, this.bundle.getSymbolicName(), this.bundle.getVersion(), driver}));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEntityManagerFactories() throws InvalidPersistenceUnitException {
        if (this.provider != null && this.emfs == null && !this.quiesce) {
            try {
                this.emfs = new HashMap<String, CountingEntityManagerFactory>();
                PersistenceProvider providerService = (PersistenceProvider)this.containerContext.getService(this.provider);
                if (providerService == null) {
                    _logger.warn(NLS.MESSAGES.getMessage("persistence.provider.gone.awol", new Object[]{this.bundle.getSymbolicName() + '/' + this.bundle.getVersion()}));
                    throw new InvalidPersistenceUnitException();
                }
                for (Map.Entry<String, ? extends ManagedPersistenceUnitInfo> entry : this.persistenceUnits.entrySet()) {
                    ManagedPersistenceUnitInfo mpui = entry.getValue();
                    this.emfs.put(entry.getKey(), new CountingEntityManagerFactory(providerService.createContainerEntityManagerFactory(mpui.getPersistenceUnitInfo(), mpui.getContainerProperties()), entry.getKey()));
                }
            }
            finally {
                this.containerContext.ungetService(this.provider);
            }
        }
    }

    public synchronized void manage(ServiceReference ref, Collection<? extends ManagedPersistenceUnitInfo> infos) throws IllegalStateException {
        this.provider = ref;
        this.persistenceUnits = this.getInfoMap(infos);
    }

    public synchronized void manage(Collection<ParsedPersistenceUnit> parsedUnits, ServiceReference ref, Collection<? extends ManagedPersistenceUnitInfo> infos) throws IllegalStateException {
        this.parsedData = parsedUnits;
        this.provider = ref;
        this.persistenceUnits = this.getInfoMap(infos);
    }

    public synchronized void destroy() {
        this.destroyEntityManagerFactories();
        this.provider = null;
        this.persistenceUnits = null;
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    private void destroyEntityManagerFactories() {
        if (this.registrations != null) {
            this.unregisterEntityManagerFactories();
        }
        if (this.emfs != null) {
            for (Map.Entry<String, CountingEntityManagerFactory> entry : this.emfs.entrySet()) {
                try {
                    ((EntityManagerFactory)entry.getValue()).close();
                }
                catch (Exception e) {
                    _logger.error(NLS.MESSAGES.getMessage("could.not.close.persistence.unit", new Object[]{entry.getKey(), this.bundle.getSymbolicName() + '/' + this.bundle.getVersion()}), (Throwable)e);
                }
            }
        }
        this.emfs = null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Collection<ParsedPersistenceUnit> getParsedPersistenceUnits() {
        return this.parsedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(DestroyCallback countdown) {
        HashMap<CountingEntityManagerFactory, ServiceRegistration> entries = new HashMap<CountingEntityManagerFactory, ServiceRegistration>();
        ArrayList<String> names = new ArrayList<String>();
        EntityManagerFactoryManager entityManagerFactoryManager = this;
        synchronized (entityManagerFactoryManager) {
            if ((this.bundle.getState() & 0x28) != 0) {
                this.quiesce = true;
            }
            if (this.emfs != null) {
                for (String string : this.emfs.keySet()) {
                    entries.put(this.emfs.get(string), this.registrations != null ? (ServiceRegistration)this.registrations.get(string) : null);
                    names.add(string);
                }
            }
        }
        if (entries.isEmpty()) {
            countdown.callback();
        } else {
            NamedCallback callback = new NamedCallback(names, countdown);
            for (Map.Entry entry : entries.entrySet()) {
                CountingEntityManagerFactory emf = (CountingEntityManagerFactory)entry.getKey();
                emf.quiesce(callback, (ServiceRegistration)entry.getValue());
            }
        }
    }

    public StringBuffer addingService(ServiceReference reference) {
        StringBuffer sb = new StringBuffer(String.valueOf(reference.getProperty("osgi.jdbc.driver.class")));
        if (this.dataSourceFactories.putIfAbsent(sb.toString(), new ArrayList()) == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("new.datasourcefactory.available", new Object[]{sb.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
            }
            try {
                this.bundleStateChange();
            }
            catch (InvalidPersistenceUnitException e) {
                _logger.warn(NLS.MESSAGES.getMessage("new.datasourcefactory.error", new Object[]{sb.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}), (Throwable)e);
            }
        }
        return sb;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        if (!service.toString().equals(reference.getProperty("osgi.jdbc.driver.class"))) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("changed.datasourcefactory.available", new Object[]{service.toString(), reference.getProperty("osgi.jdbc.driver.class"), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
            }
            this.removedService(reference, service);
            StringBuffer sb = (StringBuffer)service;
            sb.delete(0, sb.length());
            sb.append(this.addingService(reference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        Collection units;
        if (_logger.isDebugEnabled()) {
            _logger.debug(NLS.MESSAGES.getMessage("datasourcefactory.unavailable", new Object[]{service.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
        }
        Object[] objects = this.tracker.getServices();
        boolean gone = true;
        if (objects != null) {
            for (Object o : objects) {
                if (!service.equals(o)) continue;
                gone = false;
                break;
            }
        }
        if (gone && (units = (Collection)this.dataSourceFactories.remove(service.toString())) != null) {
            EntityManagerFactoryManager entityManagerFactoryManager = this;
            synchronized (entityManagerFactoryManager) {
                if (_logger.isInfoEnabled()) {
                    _logger.info(NLS.MESSAGES.getMessage("in.use.datasourcefactory.unavailable", new Object[]{service.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion(), units}));
                }
                for (String unit : units) {
                    this.unregisterEntityManagerFactory(unit);
                }
            }
        }
    }

    class NamedCallback {
        private final Set<String> names;
        private final DestroyCallback callback;

        public NamedCallback(Collection<String> names, DestroyCallback countdown) {
            this.names = new HashSet<String>(names);
            this.callback = countdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(String name) {
            boolean winner;
            NamedCallback namedCallback = this;
            synchronized (namedCallback) {
                winner = !this.names.isEmpty() && this.names.remove(name) && this.names.isEmpty();
            }
            if (winner) {
                this.callback.callback();
            }
        }
    }
}

