/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.impl.PersistenceDescriptorImpl;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceBundleHelper {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    public static final String PERSISTENCE_UNIT_HEADER = "Meta-Persistence";
    public static final String WEB_CONTEXT_PATH_HEADER = "Web-ContextPath";
    public static final String EXPORT_EJB_HEADER = "Export-EJB";

    /*
     * WARNING - void declaration
     */
    public static Collection<PersistenceDescriptor> findPersistenceXmlFiles(Bundle bundle) {
        Collection<Object> locations;
        Dictionary headers = bundle.getHeaders();
        String metaPersistence = (String)headers.get(PERSISTENCE_UNIT_HEADER);
        String webContextPath = (String)headers.get(WEB_CONTEXT_PATH_HEADER);
        String exportEJB = (String)headers.get(EXPORT_EJB_HEADER);
        String bundleIdentity = bundle.getSymbolicName() + '/' + bundle.getVersion();
        if (metaPersistence == null && exportEJB == null) {
            if (webContextPath == null) {
                return Collections.emptySet();
            }
            String bundleClassPath = (String)headers.get("Bundle-ClassPath");
            locations = PersistenceBundleHelper.findPersistenceXmlOnClassPath(bundleClassPath);
            if (_logger.isInfoEnabled()) {
                _logger.info(NLS.MESSAGES.getMessage("wab.without.meta.persistence.header", new Object[]{bundleIdentity, WEB_CONTEXT_PATH_HEADER, PERSISTENCE_UNIT_HEADER, locations}));
            }
        } else {
            locations = new HashSet<String>();
            locations.add(PERSISTENCE_XML);
            if (exportEJB != null && metaPersistence == null) {
                _logger.info(NLS.MESSAGES.getMessage("ejb.without.meta.persistence.header", new Object[]{bundleIdentity, EXPORT_EJB_HEADER, PERSISTENCE_UNIT_HEADER, locations}));
            } else if (!metaPersistence.isEmpty()) {
                void var9_11;
                String[] arr$ = metaPersistence.split(",");
                int len$ = arr$.length;
                boolean bl = false;
                while (var9_11 < len$) {
                    String s = arr$[var9_11];
                    locations.add(s.trim());
                    ++var9_11;
                }
            }
        }
        Collection<Object> persistenceXmlFiles = new ArrayList<PersistenceDescriptor>();
        for (String string : locations) {
            try {
                InputStream file = PersistenceBundleHelper.locateFile(bundle, string);
                if (file == null) continue;
                persistenceXmlFiles.add(new PersistenceDescriptorImpl(string, file));
            }
            catch (Exception e) {
                _logger.error(NLS.MESSAGES.getMessage("exception.while.locating.descriptor", new Object[]{string, bundleIdentity}), (Throwable)e);
                for (PersistenceDescriptor desc : persistenceXmlFiles) {
                    try {
                        desc.getInputStream().close();
                    }
                    catch (IOException ioe) {}
                }
                persistenceXmlFiles = Collections.emptySet();
                break;
            }
        }
        if (persistenceXmlFiles.isEmpty()) {
            _logger.warn(NLS.MESSAGES.getMessage("no.persistence.descriptor", new Object[]{bundleIdentity, locations.toString()}));
        }
        return persistenceXmlFiles;
    }

    private static Collection<String> findPersistenceXmlOnClassPath(String bundleClassPath) {
        HashSet<String> locations = new HashSet<String>();
        if (bundleClassPath == null || bundleClassPath.isEmpty()) {
            locations.add(PERSISTENCE_XML);
        } else {
            String[] entries;
            bundleClassPath = bundleClassPath.replaceAll(";[^;,]*?=\\s*\".*?\"", "");
            bundleClassPath = bundleClassPath.replaceAll(";[^;,]*?=[^;,]*", ",");
            bundleClassPath = bundleClassPath.replace(';', ',');
            bundleClassPath = bundleClassPath.replaceAll(",+", ",");
            for (String entry : entries = bundleClassPath.split(",")) {
                if ((entry = entry.trim()).isEmpty()) continue;
                if (".".equals(entry)) {
                    locations.add(PERSISTENCE_XML);
                    continue;
                }
                if (entry.endsWith(".jar")) {
                    locations.add(entry + "!/" + PERSISTENCE_XML);
                    continue;
                }
                if (!entry.endsWith("/")) {
                    entry = entry + "/";
                }
                locations.add(entry + PERSISTENCE_XML);
            }
        }
        return locations;
    }

    private static InputStream locateFile(Bundle bundle, String location) throws IOException {
        InputStream is = null;
        if ("".equals(location)) {
            return null;
        }
        int bangIndex = location.indexOf(33);
        if (bangIndex == -1) {
            URL url = bundle.getEntry(location);
            if (url != null) {
                is = url.openStream();
            }
        } else {
            URL url = bundle.getEntry(location.substring(0, bangIndex));
            if (url != null) {
                String toLocate = location.substring(bangIndex + 2);
                JarInputStream jis = new JarInputStream(url.openStream());
                JarEntry entry = jis.getNextJarEntry();
                while (entry != null) {
                    if (entry.getName().equals(toLocate)) {
                        is = jis;
                        break;
                    }
                    entry = jis.getNextJarEntry();
                }
            }
        }
        return is;
    }
}

