/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.api.persistence;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.aries.samples.ariestrader.api.persistence.QuoteDataBean;
import org.apache.aries.samples.ariestrader.util.FinancialUtils;
import org.apache.aries.samples.ariestrader.util.Log;

public class MarketSummaryDataBean
implements Serializable {
    private BigDecimal TSIA;
    private BigDecimal openTSIA;
    private double volume;
    private Collection topGainers;
    private Collection topLosers;
    private Date summaryDate;
    private BigDecimal gainPercent = null;

    public MarketSummaryDataBean() {
    }

    public MarketSummaryDataBean(BigDecimal TSIA, BigDecimal openTSIA, double volume, Collection topGainers, Collection topLosers) {
        this.setTSIA(TSIA);
        this.setOpenTSIA(openTSIA);
        this.setVolume(volume);
        this.setTopGainers(topGainers);
        this.setTopLosers(topLosers);
        this.setSummaryDate(new java.sql.Date(System.currentTimeMillis()));
        this.gainPercent = FinancialUtils.computeGainPercent((BigDecimal)this.getTSIA(), (BigDecimal)this.getOpenTSIA());
    }

    public String toString() {
        String ret = "\n\tMarket Summary at: " + this.getSummaryDate() + "\n\t\t        TSIA:" + this.getTSIA() + "\n\t\t    openTSIA:" + this.getOpenTSIA() + "\n\t\t        gain:" + this.getGainPercent() + "\n\t\t      volume:" + this.getVolume();
        if (this.getTopGainers() == null || this.getTopLosers() == null) {
            return ret;
        }
        ret = ret + "\n\t\t   Current Top Gainers:";
        for (QuoteDataBean quoteData : this.getTopGainers()) {
            ret = ret + "\n\t\t\t" + ((Object)quoteData).toString();
        }
        ret = ret + "\n\t\t   Current Top Losers:";
        for (QuoteDataBean quoteData : this.getTopLosers()) {
            ret = ret + "\n\t\t\t" + ((Object)quoteData).toString();
        }
        return ret;
    }

    public String toHTML() {
        String ret = "<BR>Market Summary at: " + this.getSummaryDate() + "<LI>        TSIA:" + this.getTSIA() + "</LI>" + "<LI>    openTSIA:" + this.getOpenTSIA() + "</LI>" + "<LI>      volume:" + this.getVolume() + "</LI>";
        if (this.getTopGainers() == null || this.getTopLosers() == null) {
            return ret;
        }
        ret = ret + "<BR> Current Top Gainers:";
        for (QuoteDataBean quoteData : this.getTopGainers()) {
            ret = ret + "<LI>" + ((Object)quoteData).toString() + "</LI>";
        }
        ret = ret + "<BR>   Current Top Losers:";
        for (QuoteDataBean quoteData : this.getTopLosers()) {
            ret = ret + "<LI>" + ((Object)quoteData).toString() + "</LI>";
        }
        return ret;
    }

    public void print() {
        Log.log((String)this.toString());
    }

    public BigDecimal getGainPercent() {
        if (this.gainPercent == null) {
            this.gainPercent = FinancialUtils.computeGainPercent((BigDecimal)this.getTSIA(), (BigDecimal)this.getOpenTSIA());
        }
        return this.gainPercent;
    }

    public BigDecimal getTSIA() {
        return this.TSIA;
    }

    public void setTSIA(BigDecimal tSIA) {
        this.TSIA = tSIA;
    }

    public BigDecimal getOpenTSIA() {
        return this.openTSIA;
    }

    public void setOpenTSIA(BigDecimal openTSIA) {
        this.openTSIA = openTSIA;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public Collection getTopGainers() {
        return this.topGainers;
    }

    public void setTopGainers(Collection topGainers) {
        this.topGainers = topGainers;
    }

    public Collection getTopLosers() {
        return this.topLosers;
    }

    public void setTopLosers(Collection topLosers) {
        this.topLosers = topLosers;
    }

    public Date getSummaryDate() {
        return this.summaryDate;
    }

    public void setSummaryDate(Date summaryDate) {
        this.summaryDate = summaryDate;
    }
}

