/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.core;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.aries.samples.ariestrader.api.TradeDBManager;
import org.apache.aries.samples.ariestrader.api.persistence.RunStatsDataBean;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.MDBStats;
import org.apache.aries.samples.ariestrader.util.ServiceUtilities;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

public class TradeDBManagerImpl
implements TradeDBManager {
    private DataSource dataSource = null;
    private static boolean initialized = false;
    private static int connCount = 0;
    private static Integer lock = new Integer(0);

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkDBProductName() throws Exception {
        Connection conn = null;
        String dbProductName = null;
        try {
            if (Log.doTrace()) {
                Log.traceEnter((String)"TradeDBManagerImpl:checkDBProductName");
            }
            conn = this.getConn();
            DatabaseMetaData dbmd = conn.getMetaData();
            dbProductName = dbmd.getDatabaseProductName();
        }
        catch (SQLException e) {
            Log.error((Throwable)e, (String)"TradeDBManagerImpl:checkDBProductName() -- Error checking the AriesTrader Database Product Name");
        }
        finally {
            this.releaseConn(conn);
        }
        return dbProductName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recreateDBTables(Object[] sqlBuffer, PrintWriter out) throws Exception {
        MDBStats.getInstance().reset();
        Connection conn = null;
        boolean success = false;
        try {
            if (Log.doTrace()) {
                Log.traceEnter((String)"TradeDBManagerImpl:recreateDBTables");
            }
            conn = this.getConn();
            Statement stmt = conn.createStatement();
            int bufferLength = sqlBuffer.length;
            for (int i = 0; i < bufferLength; ++i) {
                try {
                    stmt.executeUpdate((String)sqlBuffer[i]);
                    continue;
                }
                catch (SQLException ex) {
                    if (((String)sqlBuffer[i]).indexOf("DROP TABLE") >= 0) continue;
                    Log.error((String)("TradeDBManagerImpl:recreateDBTables SQL Exception thrown on executing the foll sql command: " + sqlBuffer[i]), (Throwable)ex);
                    out.println("<BR>SQL Exception thrown on executing the foll sql command: <I>" + sqlBuffer[i] + "</I> . Check log for details.</BR>");
                }
            }
            stmt.close();
            this.commit(conn);
            success = true;
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"TradeDBManagerImpl:recreateDBTables() -- Error dropping and recreating the database tables");
        }
        finally {
            this.releaseConn(conn);
        }
        return success;
    }

    public RunStatsDataBean resetTrade(boolean deleteAll) throws Exception {
        MDBStats.getInstance().reset();
        RunStatsDataBean runStatsData = new RunStatsDataBean();
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.traceEnter((String)("TradeDBManagerImpl:resetTrade deleteAll rows=" + deleteAll));
            }
            conn = this.getConn();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            if (deleteAll) {
                try {
                    stmt = this.getStatement(conn, "delete from quoteejb");
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = this.getStatement(conn, "delete from accountejb");
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = this.getStatement(conn, "delete from accountprofileejb");
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = this.getStatement(conn, "delete from holdingejb");
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = this.getStatement(conn, "delete from orderejb");
                    stmt.executeUpdate();
                    stmt.close();
                    this.commit(conn);
                }
                catch (Exception e) {
                    Log.error((Throwable)e, (String)"TradeDBManagerImpl:resetTrade(deleteAll) -- Error deleting Trade users and stock from the Trade database");
                }
                RunStatsDataBean e = runStatsData;
                return e;
            }
            stmt = this.getStatement(conn, "delete from holdingejb where holdingejb.account_accountid is null");
            stmt.executeUpdate();
            stmt.close();
            stmt = this.getStatement(conn, "delete from accountprofileejb where userid like 'ru:%'");
            stmt.executeUpdate();
            stmt.close();
            stmt = this.getStatement(conn, "delete from orderejb where account_accountid in (select accountid from accountejb a where a.profile_userid like 'ru:%')");
            stmt.executeUpdate();
            stmt.close();
            stmt = this.getStatement(conn, "delete from holdingejb where account_accountid in (select accountid from accountejb a where a.profile_userid like 'ru:%')");
            stmt.executeUpdate();
            stmt.close();
            stmt = this.getStatement(conn, "delete from accountejb where profile_userid like 'ru:%'");
            int newUserCount = stmt.executeUpdate();
            runStatsData.setNewUserCount(newUserCount);
            stmt.close();
            stmt = this.getStatement(conn, "select count(accountid) as \"tradeUserCount\" from accountejb a where a.profile_userid like 'uid:%'");
            rs = stmt.executeQuery();
            rs.next();
            int tradeUserCount = rs.getInt("tradeUserCount");
            runStatsData.setTradeUserCount(tradeUserCount);
            stmt.close();
            rs.close();
            stmt = this.getStatement(conn, "select count(symbol) as \"tradeStockCount\" from quoteejb a where a.symbol like 's:%'");
            rs = stmt.executeQuery();
            rs.next();
            int tradeStockCount = rs.getInt("tradeStockCount");
            runStatsData.setTradeStockCount(tradeStockCount);
            stmt.close();
            stmt = this.getStatement(conn, "select sum(loginCount) as \"sumLoginCount\", sum(logoutCount) as \"sumLogoutCount\" from accountejb a where  a.profile_userID like 'uid:%'");
            rs = stmt.executeQuery();
            rs.next();
            int sumLoginCount = rs.getInt("sumLoginCount");
            int sumLogoutCount = rs.getInt("sumLogoutCount");
            runStatsData.setSumLoginCount(sumLoginCount);
            runStatsData.setSumLogoutCount(sumLogoutCount);
            stmt.close();
            rs.close();
            stmt = this.getStatement(conn, "update accountejb set logoutCount=0,loginCount=0 where profile_userID like 'uid:%'");
            stmt.executeUpdate();
            stmt.close();
            stmt = this.getStatement(conn, "select count(holdingid) as \"holdingCount\" from holdingejb h where h.account_accountid in (select accountid from accountejb a where a.profile_userid like 'uid:%')");
            rs = stmt.executeQuery();
            rs.next();
            int holdingCount = rs.getInt("holdingCount");
            runStatsData.setHoldingCount(holdingCount);
            stmt.close();
            rs.close();
            stmt = this.getStatement(conn, "select count(orderid) as \"orderCount\" from orderejb o where o.account_accountid in (select accountid from accountejb a where a.profile_userid like 'uid:%')");
            rs = stmt.executeQuery();
            rs.next();
            int orderCount = rs.getInt("orderCount");
            runStatsData.setOrderCount(orderCount);
            stmt.close();
            rs.close();
            stmt = this.getStatement(conn, "select count(orderid) \"buyOrderCount\"from orderejb o where (o.account_accountid in (select accountid from accountejb a where a.profile_userid like 'uid:%')) AND  (o.orderType='buy')");
            rs = stmt.executeQuery();
            rs.next();
            int buyOrderCount = rs.getInt("buyOrderCount");
            runStatsData.setBuyOrderCount(buyOrderCount);
            stmt.close();
            rs.close();
            stmt = this.getStatement(conn, "select count(orderid) \"sellOrderCount\"from orderejb o where (o.account_accountid in (select accountid from accountejb a where a.profile_userid like 'uid:%')) AND  (o.orderType='sell')");
            rs = stmt.executeQuery();
            rs.next();
            int sellOrderCount = rs.getInt("sellOrderCount");
            runStatsData.setSellOrderCount(sellOrderCount);
            stmt.close();
            rs.close();
            stmt = this.getStatement(conn, "delete from orderejb where orderStatus='cancelled'");
            int cancelledOrderCount = stmt.executeUpdate();
            runStatsData.setCancelledOrderCount(cancelledOrderCount);
            stmt.close();
            rs.close();
            stmt = this.getStatement(conn, "select count(orderid) \"openOrderCount\"from orderejb o where (o.account_accountid in (select accountid from accountejb a where a.profile_userid like 'uid:%')) AND  (o.orderStatus='open')");
            rs = stmt.executeQuery();
            rs.next();
            int openOrderCount = rs.getInt("openOrderCount");
            runStatsData.setOpenOrderCount(openOrderCount);
            stmt.close();
            rs.close();
            stmt = this.getStatement(conn, "delete from orderejb where holding_holdingid is null");
            int deletedOrderCount = stmt.executeUpdate();
            runStatsData.setDeletedOrderCount(deletedOrderCount);
            stmt.close();
            rs.close();
            this.commit(conn);
            System.out.println("TradeDBManagerImpl:reset Run stats data\n\n" + runStatsData);
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"Failed to reset Trade");
            this.rollBack(conn, e);
            throw e;
        }
        finally {
            this.releaseConn(conn);
        }
        return runStatsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConn(Connection conn) throws Exception {
        block5: {
            try {
                if (conn == null) break block5;
                conn.close();
                if (!Log.doTrace()) break block5;
                Integer n = lock;
                synchronized (n) {
                }
                Log.trace((String)("TradeDBManagerImpl:releaseConn -- connection closed, connCount=" + --connCount));
            }
            catch (Exception e) {
                Log.error((String)"TradeDBManagerImpl:releaseConnection -- failed to close connection", (Throwable)e);
            }
        }
    }

    private void lookupDataSource() throws Exception {
        if (this.dataSource == null) {
            this.dataSource = (DataSource)ServiceUtilities.getOSGIService((String)DataSource.class.getName(), (String)TradeConfig.OSGI_DS_NAME_FILTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConn() throws Exception {
        Connection conn = null;
        this.lookupDataSource();
        conn = this.dataSource.getConnection();
        conn.setAutoCommit(false);
        if (Log.doTrace()) {
            Integer n = lock;
            synchronized (n) {
            }
            Log.trace((String)("TradeDBManagerImpl:getConn -- new connection allocated, IsolationLevel=" + conn.getTransactionIsolation() + " connectionCount = " + ++connCount));
        }
        return conn;
    }

    private void commit(Connection conn) throws Exception {
        if (conn != null) {
            conn.commit();
        }
    }

    private void rollBack(Connection conn, Exception e) throws Exception {
        Log.log((String)"TradeDBManagerImpl:rollBack -- rolling back conn due to previously caught exception");
        if (conn == null) {
            throw e;
        }
        conn.rollback();
    }

    private PreparedStatement getStatement(Connection conn, String sql) throws Exception {
        return conn.prepareStatement(sql);
    }

    public void init() {
        if (initialized) {
            return;
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeDBManagerImpl:init -- *** initializing");
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeDBManagerImpl:init -- +++ initialized");
        }
        initialized = true;
    }

    public void destroy() {
        try {
            Log.trace((String)"TradeDBManagerImpl:destroy");
            if (!initialized) {
                return;
            }
        }
        catch (Exception e) {
            Log.error((String)"TradeDBManagerImpl:destroy", (Throwable)e);
        }
    }
}

