/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.core;

import java.util.ArrayList;
import java.util.Map;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.TradeServicesManager;
import org.apache.aries.samples.ariestrader.api.persistence.MarketSummaryDataBean;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeServicesManagerImpl
implements TradeServicesManager {
    private static TradeServices[] tradeServicesList = new TradeServices[TradeConfig.runTimeModeNames.length];
    private static final Integer marketSummaryLock = new Integer(0);
    private static long nextMarketSummary = System.currentTimeMillis();
    private static MarketSummaryDataBean cachedMSDB = null;

    public TradeServicesManagerImpl() {
        if (Log.doTrace()) {
            Log.trace((String)"TradeServicesManagerImpl()");
        }
    }

    public void init() {
        if (Log.doTrace()) {
            Log.trace((String)"TradeServicesManagerImpl:init()");
        }
    }

    public ArrayList<Integer> getCurrentModes() {
        if (Log.doTrace()) {
            Log.trace((String)"TradeServicesManagerImpl:getCurrentModes()");
        }
        ArrayList<Integer> modes = new ArrayList<Integer>();
        for (int i = 0; i < tradeServicesList.length; ++i) {
            TradeServices tradeServicesRef = tradeServicesList[i];
            if (tradeServicesRef == null) continue;
            modes.add(i);
        }
        return modes;
    }

    public TradeServices getTradeServices() {
        if (Log.doTrace()) {
            Log.trace((String)"TradeServicesManagerImpl:getTradeServices()");
        }
        return tradeServicesList[TradeConfig.getRunTimeMode().ordinal()];
    }

    public void bindService(TradeServices tradeServices, Map props) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeServicesManagerImpl:bindService()", (Object)tradeServices, (Object)props);
        }
        if (tradeServices != null) {
            String mode = (String)props.get("mode");
            TradeServicesManagerImpl.tradeServicesList[Enum.valueOf(TradeConfig.ModeType.class, (String)mode).ordinal()] = tradeServices;
        }
    }

    public void unbindService(TradeServices tradeServices, Map props) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeServicesManagerImpl:unbindService()", (Object)tradeServices, (Object)props);
        }
        if (tradeServices != null) {
            String mode = (String)props.get("mode");
            TradeServicesManagerImpl.tradeServicesList[Enum.valueOf(TradeConfig.ModeType.class, (String)mode).ordinal()] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarketSummaryDataBean getMarketSummary() throws Exception {
        if (Log.doActionTrace()) {
            Log.trace((String)"TradeAction:getMarketSummary()");
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeServicesManagerImpl:getMarketSummary()");
        }
        if (TradeConfig.getMarketSummaryInterval() == 0) {
            return this.getMarketSummaryInternal();
        }
        if (TradeConfig.getMarketSummaryInterval() < 0) {
            return cachedMSDB;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime > nextMarketSummary) {
            long oldNextMarketSummary = nextMarketSummary;
            boolean fetch = false;
            Integer n = marketSummaryLock;
            synchronized (n) {
                if (oldNextMarketSummary == nextMarketSummary) {
                    fetch = true;
                    if ((nextMarketSummary += (long)(TradeConfig.getMarketSummaryInterval() * 1000)) < currentTime) {
                        nextMarketSummary = currentTime + (long)(TradeConfig.getMarketSummaryInterval() * 1000);
                    }
                }
            }
            if (fetch) {
                cachedMSDB = this.getMarketSummaryInternal();
            }
        }
        return cachedMSDB;
    }

    private MarketSummaryDataBean getMarketSummaryInternal() throws Exception {
        if (Log.doActionTrace()) {
            Log.trace((String)"TradeAction:getMarketSummaryInternal()");
        }
        MarketSummaryDataBean marketSummaryData = null;
        marketSummaryData = tradeServicesList[TradeConfig.getRunTimeMode().ordinal()].getMarketSummary();
        return marketSummaryData;
    }
}

