/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.persist.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.persistence.AccountDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.AccountProfileDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.HoldingDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.MarketSummaryDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.OrderDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.QuoteDataBean;
import org.apache.aries.samples.ariestrader.beans.AccountDataBeanImpl;
import org.apache.aries.samples.ariestrader.beans.AccountProfileDataBeanImpl;
import org.apache.aries.samples.ariestrader.beans.HoldingDataBeanImpl;
import org.apache.aries.samples.ariestrader.beans.OrderDataBeanImpl;
import org.apache.aries.samples.ariestrader.beans.QuoteDataBeanImpl;
import org.apache.aries.samples.ariestrader.persist.jdbc.KeySequenceDirect;
import org.apache.aries.samples.ariestrader.util.FinancialUtils;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.ServiceUtilities;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

public class TradeJdbc
implements TradeServices {
    private DataSource dataSource = null;
    private static BigDecimal ZERO = new BigDecimal(0.0);
    private boolean inGlobalTxn = false;
    private boolean inSession = false;
    private static int connCount = 0;
    private static Integer lock = new Integer(0);
    private static boolean initialized = false;
    private static final String createQuoteSQL = "insert into quoteejb ( symbol, companyName, volume, price, open1, low, high, change1 ) VALUES (  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  )";
    private static final String createAccountSQL = "insert into accountejb ( accountid, creationDate, openBalance, balance, lastLogin, loginCount, logoutCount, profile_userid) VALUES (  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  )";
    private static final String createAccountProfileSQL = "insert into accountprofileejb ( userid, passwd, fullname, address, email, creditcard ) VALUES (  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  )";
    private static final String createHoldingSQL = "insert into holdingejb ( holdingid, purchaseDate, purchasePrice, quantity, quote_symbol, account_accountid ) VALUES (  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ? )";
    private static final String createOrderSQL = "insert into orderejb ( orderid, ordertype, orderstatus, opendate, quantity, price, orderfee, account_accountid,  holding_holdingid, quote_symbol) VALUES (  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  ,  ?  , ? , ? , ?)";
    private static final String removeHoldingSQL = "delete from holdingejb where holdingid = ?";
    private static final String removeHoldingFromOrderSQL = "update orderejb set holding_holdingid=null where holding_holdingid = ?";
    private static final String updateAccountProfileSQL = "update accountprofileejb set passwd = ?, fullname = ?, address = ?, email = ?, creditcard = ? where userid = (select profile_userid from accountejb a where a.profile_userid=?)";
    private static final String loginSQL = "update accountejb set lastLogin=?, logincount=logincount+1 where profile_userid=?";
    private static final String logoutSQL = "update accountejb set logoutcount=logoutcount+1 where profile_userid=?";
    private static final String getAccountSQL = "select * from accountejb a where a.accountid = ?";
    private static final String getAccountProfileSQL = "select * from accountprofileejb ap where ap.userid = (select profile_userid from accountejb a where a.profile_userid=?)";
    private static final String getAccountProfileForAccountSQL = "select * from accountprofileejb ap where ap.userid = (select profile_userid from accountejb a where a.accountid=?)";
    private static final String getAccountForUserSQL = "select * from accountejb a where a.profile_userid = ( select userid from accountprofileejb ap where ap.userid = ?)";
    private static final String getAccountForUserForUpdateSQL = "select * from accountejb a where a.profile_userid = ( select userid from accountprofileejb ap where ap.userid = ?) for update";
    private static final String getHoldingSQL = "select * from holdingejb h where h.holdingid = ?";
    private static final String getHoldingsForUserSQL = "select * from holdingejb h where h.account_accountid = (select a.accountid from accountejb a where a.profile_userid = ?)";
    private static final String getOrderSQL = "select * from orderejb o where o.orderid = ?";
    private static final String getOrdersByUserSQL = "select * from orderejb o where o.account_accountid = (select a.accountid from accountejb a where a.profile_userid = ?)";
    private static final String getClosedOrdersSQL = "select * from orderejb o where o.orderstatus = 'closed' AND o.account_accountid = (select a.accountid from accountejb a where a.profile_userid = ?)";
    private static final String getQuoteSQL = "select * from quoteejb q where q.symbol=?";
    private static final String getAllQuotesSQL = "select * from quoteejb q";
    private static final String getQuoteForUpdateSQL = "select * from quoteejb q where q.symbol=? For Update";
    private static final String getTSIAQuotesOrderByChangeSQL = "select * from quoteejb q where q.symbol like 's:1__' order by q.change1";
    private static final String getTSIASQL = "select SUM(price)/count(*) as TSIA from quoteejb q where q.symbol like 's:1__'";
    private static final String getOpenTSIASQL = "select SUM(open1)/count(*) as openTSIA from quoteejb q where q.symbol like 's:1__'";
    private static final String getTSIATotalVolumeSQL = "select SUM(volume) as totalVolume from quoteejb q where q.symbol like 's:1__'";
    private static final String creditAccountBalanceSQL = "update accountejb set balance = balance + ? where accountid = ?";
    private static final String updateOrderStatusSQL = "update orderejb set orderstatus = ?, completiondate = ? where orderid = ?";
    private static final String updateOrderHoldingSQL = "update orderejb set holding_holdingID = ? where orderid = ?";
    private static final String updateQuotePriceVolumeSQL = "update quoteejb set price = ?, change1 = ? - open1, volume = ?, low = ?, high = ? where symbol = ?";

    public TradeJdbc() {
    }

    public TradeJdbc(boolean inSession) {
        this.inSession = inSession;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setInSession(boolean inSession) {
        this.inSession = inSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarketSummaryDataBean getMarketSummary() throws Exception {
        MarketSummaryDataBean marketSummaryData = null;
        Connection conn = null;
        try {
            QuoteDataBean quoteData;
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:getMarketSummary - inSession(" + this.inSession + ")"));
            }
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, getTSIAQuotesOrderByChangeSQL, 1004, 1007);
            ArrayList<QuoteDataBean> topGainersData = new ArrayList<QuoteDataBean>(5);
            ArrayList<QuoteDataBean> topLosersData = new ArrayList<QuoteDataBean>(5);
            ResultSet rs = stmt.executeQuery();
            int count = 0;
            while (rs.next() && count++ < 5) {
                quoteData = this.getQuoteDataFromResultSet(rs);
                topLosersData.add(quoteData);
            }
            stmt.close();
            stmt = this.getStatement(conn, "select * from quoteejb q where q.symbol like 's:1__' order by q.change1 DESC", 1004, 1007);
            rs = stmt.executeQuery();
            count = 0;
            while (rs.next() && count++ < 5) {
                quoteData = this.getQuoteDataFromResultSet(rs);
                topGainersData.add(quoteData);
            }
            stmt.close();
            BigDecimal TSIA = ZERO;
            BigDecimal openTSIA = ZERO;
            double volume = 0.0;
            if (topGainersData.size() > 0 || topLosersData.size() > 0) {
                stmt = this.getStatement(conn, getTSIASQL);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    Log.error((String)"TradeJdbc:getMarketSummary -- error w/ getTSIASQL -- no results");
                } else {
                    TSIA = rs.getBigDecimal("TSIA");
                }
                stmt.close();
                stmt = this.getStatement(conn, getOpenTSIASQL);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    Log.error((String)"TradeJdbc:getMarketSummary -- error w/ getOpenTSIASQL -- no results");
                } else {
                    openTSIA = rs.getBigDecimal("openTSIA");
                }
                stmt.close();
                stmt = this.getStatement(conn, getTSIATotalVolumeSQL);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    Log.error((String)"TradeJdbc:getMarketSummary -- error w/ getTSIATotalVolumeSQL -- no results");
                } else {
                    volume = rs.getDouble("totalVolume");
                }
                stmt.close();
            }
            this.commit(conn);
            marketSummaryData = new MarketSummaryDataBean(TSIA, openTSIA, volume, topGainersData, topLosersData);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getMarketSummary -- error getting summary", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return marketSummaryData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderDataBean buy(String userID, String symbol, double quantity, int orderProcessingMode) throws Exception {
        Connection conn = null;
        OrderDataBean orderData = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:buy - inSession(" + this.inSession + ")"), (Object)userID, (Object)symbol, (Object)new Double(quantity));
            }
            conn = this.getConn();
            AccountDataBean accountData = this.getAccountData(conn, userID);
            QuoteDataBean quoteData = this.getQuoteData(conn, symbol);
            HoldingDataBean holdingData = null;
            orderData = this.createOrder(conn, accountData, quoteData, holdingData, "buy", quantity);
            BigDecimal price = quoteData.getPrice();
            BigDecimal orderFee = orderData.getOrderFee();
            BigDecimal total = new BigDecimal(quantity).multiply(price).add(orderFee);
            this.creditAccountBalance(conn, accountData, total.negate());
            this.completeOrder(conn, orderData.getOrderID());
            orderData = this.getOrderData(conn, orderData.getOrderID());
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:buy error - rolling back", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        this.updateQuotePriceVolume(symbol, TradeConfig.getRandomPriceChangeFactor(), quantity);
        return orderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderDataBean sell(String userID, Integer holdingID, int orderProcessingMode) throws Exception {
        Connection conn = null;
        OrderDataBean orderData = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:sell - inSession(" + this.inSession + ")"), (Object)userID, (Object)holdingID);
            }
            conn = this.getConn();
            AccountDataBean accountData = this.getAccountData(conn, userID);
            HoldingDataBean holdingData = this.getHoldingData(conn, holdingID);
            QuoteDataBean quoteData = null;
            if (holdingData != null) {
                quoteData = this.getQuoteData(conn, holdingData.getQuoteID());
            }
            if (accountData == null || holdingData == null || quoteData == null) {
                String error = "TradeJdbc:sell -- error selling stock -- unable to find:  \n\taccount=" + accountData + "\n\tholding=" + holdingData + "\n\tquote=" + quoteData + "\nfor user: " + userID + " and holdingID: " + holdingID;
                Log.error((String)error);
                this.rollBack(conn, new Exception(error));
                OrderDataBean orderDataBean = orderData;
                return orderDataBean;
            }
            double quantity = holdingData.getQuantity();
            orderData = this.createOrder(conn, accountData, quoteData, holdingData, "sell", quantity);
            this.updateHoldingStatus(conn, holdingData.getHoldingID(), holdingData.getQuoteID());
            BigDecimal price = quoteData.getPrice();
            BigDecimal orderFee = orderData.getOrderFee();
            BigDecimal total = new BigDecimal(quantity).multiply(price).subtract(orderFee);
            this.creditAccountBalance(conn, accountData, total);
            this.completeOrder(conn, orderData.getOrderID());
            orderData = this.getOrderData(conn, orderData.getOrderID());
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:sell error", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        if (!orderData.getOrderStatus().equalsIgnoreCase("cancelled")) {
            this.updateQuotePriceVolume(orderData.getSymbol(), TradeConfig.getRandomPriceChangeFactor(), orderData.getQuantity());
        }
        return orderData;
    }

    public void queueOrder(Integer orderID, boolean twoPhase) throws Exception {
        throw new RuntimeException("TradeServices#queueOrder(Integer) is not supported in this runtime mode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderDataBean completeOrder(Integer orderID, boolean twoPhase) throws Exception {
        OrderDataBean orderData = null;
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:completeOrder - inSession(" + this.inSession + ")"), (Object)orderID);
            }
            this.setInGlobalTxn(!this.inSession && twoPhase);
            conn = this.getConn();
            orderData = this.completeOrder(conn, orderID);
            this.commit(conn);
        }
        catch (Exception e) {
            try {
                Log.error((String)"TradeJdbc:completeOrder -- error completing order", (Throwable)e);
                this.rollBack(conn, e);
                this.cancelOrder(orderID, twoPhase);
            }
            catch (Throwable throwable) {
                this.releaseConn(conn);
                throw throwable;
            }
            this.releaseConn(conn);
        }
        this.releaseConn(conn);
        return orderData;
    }

    private OrderDataBean completeOrder(Connection conn, Integer orderID) throws Exception {
        OrderDataBean orderData = null;
        if (Log.doTrace()) {
            Log.trace((String)("TradeJdbc:completeOrderInternal - inSession(" + this.inSession + ")"), (Object)orderID);
        }
        PreparedStatement stmt = this.getStatement(conn, getOrderSQL);
        stmt.setInt(1, orderID);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            Log.error((String)("TradeJdbc:completeOrder -- unable to find order: " + orderID));
            stmt.close();
            return orderData;
        }
        orderData = this.getOrderDataFromResultSet(rs);
        String orderType = orderData.getOrderType();
        String orderStatus = orderData.getOrderStatus();
        if (orderStatus.compareToIgnoreCase("completed") == 0 || orderStatus.compareToIgnoreCase("alertcompleted") == 0 || orderStatus.compareToIgnoreCase("cancelled") == 0) {
            throw new Exception("TradeJdbc:completeOrder -- attempt to complete Order that is already completed");
        }
        int accountID = rs.getInt("account_accountID");
        String quoteID = rs.getString("quote_symbol");
        int holdingID = rs.getInt("holding_holdingID");
        BigDecimal price = orderData.getPrice();
        double quantity = orderData.getQuantity();
        BigDecimal orderFee = orderData.getOrderFee();
        String userID = this.getAccountProfileData(conn, new Integer(accountID)).getUserID();
        HoldingDataBean holdingData = null;
        if (Log.doTrace()) {
            Log.trace((String)("TradeJdbc:completeOrder--> Completing Order " + orderData.getOrderID() + "\n\t Order info: " + orderData + "\n\t Account info: " + accountID + "\n\t Quote info: " + quoteID));
        }
        if (orderType.compareToIgnoreCase("buy") == 0) {
            holdingData = this.createHolding(conn, accountID, quoteID, quantity, price);
            this.updateOrderHolding(conn, orderID, holdingData.getHoldingID());
        }
        if (orderType.compareToIgnoreCase("sell") == 0) {
            holdingData = this.getHoldingData(conn, holdingID);
            if (holdingData == null) {
                Log.debug((String)("TradeJdbc:completeOrder:sell -- user: " + userID + " already sold holding: " + holdingID));
            } else {
                this.removeHolding(conn, holdingID, orderID);
            }
        }
        this.updateOrderStatus(conn, orderData.getOrderID(), "closed");
        if (Log.doTrace()) {
            Log.trace((String)("TradeJdbc:completeOrder--> Completed Order " + orderData.getOrderID() + "\n\t Order info: " + orderData + "\n\t Account info: " + accountID + "\n\t Quote info: " + quoteID + "\n\t Holding info: " + holdingData));
        }
        stmt.close();
        this.commit(conn);
        this.orderCompleted(userID, orderID);
        return orderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelOrder(Integer orderID, boolean twoPhase) throws Exception {
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:cancelOrder - inSession(" + this.inSession + ")"), (Object)orderID);
            }
            this.setInGlobalTxn(!this.inSession && twoPhase);
            conn = this.getConn();
            this.cancelOrder(conn, orderID);
            this.commit(conn);
        }
        catch (Exception e) {
            try {
                Log.error((String)("TradeJdbc:cancelOrder -- error cancelling order: " + orderID), (Throwable)e);
                this.rollBack(conn, e);
            }
            catch (Throwable throwable) {
                this.releaseConn(conn);
                throw throwable;
            }
            this.releaseConn(conn);
        }
        this.releaseConn(conn);
    }

    private void cancelOrder(Connection conn, Integer orderID) throws Exception {
        this.updateOrderStatus(conn, orderID, "cancelled");
    }

    public void orderCompleted(String userID, Integer orderID) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"OrderCompleted", (Object)userID, (Object)orderID);
        }
    }

    private HoldingDataBean createHolding(Connection conn, int accountID, String symbol, double quantity, BigDecimal purchasePrice) throws Exception {
        Timestamp purchaseDate = new Timestamp(System.currentTimeMillis());
        PreparedStatement stmt = this.getStatement(conn, createHoldingSQL);
        Integer holdingID = KeySequenceDirect.getNextID(conn, "holding", this.inSession, this.getInGlobalTxn());
        stmt.setInt(1, holdingID);
        stmt.setTimestamp(2, purchaseDate);
        stmt.setBigDecimal(3, purchasePrice);
        stmt.setDouble(4, quantity);
        stmt.setString(5, symbol);
        stmt.setInt(6, accountID);
        stmt.executeUpdate();
        stmt.close();
        return this.getHoldingData(conn, holdingID);
    }

    private void removeHolding(Connection conn, int holdingID, int orderID) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, removeHoldingSQL);
        stmt.setInt(1, holdingID);
        stmt.executeUpdate();
        stmt.close();
        stmt = this.getStatement(conn, removeHoldingFromOrderSQL);
        stmt.setInt(1, holdingID);
        stmt.executeUpdate();
        stmt.close();
    }

    private OrderDataBean createOrder(Connection conn, AccountDataBean accountData, QuoteDataBean quoteData, HoldingDataBean holdingData, String orderType, double quantity) throws Exception {
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        PreparedStatement stmt = this.getStatement(conn, createOrderSQL);
        Integer orderID = KeySequenceDirect.getNextID(conn, "order", this.inSession, this.getInGlobalTxn());
        stmt.setInt(1, orderID);
        stmt.setString(2, orderType);
        stmt.setString(3, "open");
        stmt.setTimestamp(4, currentDate);
        stmt.setDouble(5, quantity);
        stmt.setBigDecimal(6, quoteData.getPrice().setScale(2, 4));
        stmt.setBigDecimal(7, TradeConfig.getOrderFee((String)orderType));
        stmt.setInt(8, accountData.getAccountID());
        if (holdingData == null) {
            stmt.setNull(9, 4);
        } else {
            stmt.setInt(9, holdingData.getHoldingID());
        }
        stmt.setString(10, quoteData.getSymbol());
        stmt.executeUpdate();
        stmt.close();
        return this.getOrderData(conn, orderID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getOrders(String userID) throws Exception {
        ArrayList<OrderDataBean> orderDataBeans = new ArrayList<OrderDataBean>();
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:getOrders - inSession(" + this.inSession + ")"), (Object)userID);
            }
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, getOrdersByUserSQL);
            stmt.setString(1, userID);
            ResultSet rs = stmt.executeQuery();
            int i = 0;
            while (rs.next() && i++ < 5) {
                OrderDataBean orderData = this.getOrderDataFromResultSet(rs);
                orderDataBeans.add(orderData);
            }
            stmt.close();
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getOrders -- error getting user orders", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return orderDataBeans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getClosedOrders(String userID) throws Exception {
        ArrayList<OrderDataBean> orderDataBeans = new ArrayList<OrderDataBean>();
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:getClosedOrders - inSession(" + this.inSession + ")"), (Object)userID);
            }
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, getClosedOrdersSQL);
            stmt.setString(1, userID);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                OrderDataBean orderData = this.getOrderDataFromResultSet(rs);
                orderData.setOrderStatus("completed");
                this.updateOrderStatus(conn, orderData.getOrderID(), orderData.getOrderStatus());
                orderDataBeans.add(orderData);
            }
            stmt.close();
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getOrders -- error getting user orders", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return orderDataBeans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuoteDataBean createQuote(String symbol, String companyName, BigDecimal price) throws Exception {
        QuoteDataBeanImpl quoteData = null;
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.traceEnter((String)("TradeJdbc:createQuote - inSession(" + this.inSession + ")"));
            }
            price = price.setScale(2, 4);
            double volume = 0.0;
            double change = 0.0;
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, createQuoteSQL);
            stmt.setString(1, symbol);
            stmt.setString(2, companyName);
            stmt.setDouble(3, volume);
            stmt.setBigDecimal(4, price);
            stmt.setBigDecimal(5, price);
            stmt.setBigDecimal(6, price);
            stmt.setBigDecimal(7, price);
            stmt.setDouble(8, change);
            stmt.executeUpdate();
            stmt.close();
            this.commit(conn);
            quoteData = new QuoteDataBeanImpl(symbol, companyName, volume, price, price, price, price, change);
            if (Log.doTrace()) {
                Log.traceExit((String)"TradeJdbc:createQuote");
            }
            this.releaseConn(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:createQuote -- error creating quote", (Throwable)e);
        }
        finally {
            this.releaseConn(conn);
        }
        return quoteData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuoteDataBean getQuote(String symbol) throws Exception {
        QuoteDataBean quoteData = null;
        Connection conn = null;
        if (symbol == null || symbol.length() == 0 || symbol.length() > 10) {
            if (Log.doTrace()) {
                Log.trace((String)"TradeJdbc:getQuote   ---  primitive workload");
            }
            return new QuoteDataBeanImpl("Invalid symbol", "", 0.0, FinancialUtils.ZERO, FinancialUtils.ZERO, FinancialUtils.ZERO, FinancialUtils.ZERO, 0.0);
        }
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:getQuote - inSession(" + this.inSession + ")"), (Object)symbol);
            }
            conn = this.getConn();
            quoteData = this.getQuote(conn, symbol);
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getQuote -- error getting quote", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return quoteData;
    }

    private QuoteDataBean getQuote(Connection conn, String symbol) throws Exception {
        QuoteDataBean quoteData = null;
        PreparedStatement stmt = this.getStatement(conn, getQuoteSQL);
        stmt.setString(1, symbol);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            Log.error((String)("TradeJdbc:getQuote -- failure no result.next() for symbol: " + symbol));
        } else {
            quoteData = this.getQuoteDataFromResultSet(rs);
        }
        stmt.close();
        return quoteData;
    }

    private QuoteDataBean getQuoteForUpdate(Connection conn, String symbol) throws Exception {
        QuoteDataBean quoteData = null;
        PreparedStatement stmt = this.getStatement(conn, getQuoteForUpdateSQL);
        stmt.setString(1, symbol);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            Log.error((String)"TradeJdbc:getQuote -- failure no result.next()");
        } else {
            quoteData = this.getQuoteDataFromResultSet(rs);
        }
        stmt.close();
        return quoteData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllQuotes() throws Exception {
        ArrayList<QuoteDataBean> quotes = new ArrayList<QuoteDataBean>();
        QuoteDataBean quoteData = null;
        Connection conn = null;
        if (Log.doTrace()) {
            Log.trace((String)"TradeJdbc:getAllQuotes");
        }
        try {
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, getAllQuotesSQL);
            ResultSet rs = stmt.executeQuery();
            while (!rs.next()) {
                quoteData = this.getQuoteDataFromResultSet(rs);
                quotes.add(quoteData);
            }
            stmt.close();
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getAllQuotes", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return quotes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getHoldings(String userID) throws Exception {
        ArrayList<HoldingDataBean> holdingDataBeans = new ArrayList<HoldingDataBean>();
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:getHoldings - inSession(" + this.inSession + ")"), (Object)userID);
            }
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, getHoldingsForUserSQL);
            stmt.setString(1, userID);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                HoldingDataBean holdingData = this.getHoldingDataFromResultSet(rs);
                holdingDataBeans.add(holdingData);
            }
            stmt.close();
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getHoldings -- error getting user holings", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return holdingDataBeans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HoldingDataBean getHolding(Integer holdingID) throws Exception {
        HoldingDataBean holdingData = null;
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:getHolding - inSession(" + this.inSession + ")"), (Object)holdingID);
            }
            conn = this.getConn();
            holdingData = this.getHoldingData(holdingID);
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)("TradeJdbc:getHolding -- error getting holding " + holdingID + ""), (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return holdingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountDataBean getAccountData(String userID) throws Exception {
        try {
            AccountDataBean accountData = null;
            Connection conn = null;
            try {
                if (Log.doTrace()) {
                    Log.trace((String)("TradeJdbc:getAccountData - inSession(" + this.inSession + ")"), (Object)userID);
                }
                conn = this.getConn();
                accountData = this.getAccountData(conn, userID);
                this.commit(conn);
            }
            catch (Exception e) {
                Log.error((String)"TradeJdbc:getAccountData -- error getting account data", (Throwable)e);
                this.rollBack(conn, e);
            }
            finally {
                this.releaseConn(conn);
            }
            return accountData;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private AccountDataBean getAccountData(Connection conn, String userID) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, getAccountForUserSQL);
        stmt.setString(1, userID);
        ResultSet rs = stmt.executeQuery();
        AccountDataBean accountData = this.getAccountDataFromResultSet(rs);
        stmt.close();
        return accountData;
    }

    private AccountDataBean getAccountDataForUpdate(Connection conn, String userID) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, getAccountForUserForUpdateSQL);
        stmt.setString(1, userID);
        ResultSet rs = stmt.executeQuery();
        AccountDataBean accountData = this.getAccountDataFromResultSet(rs);
        stmt.close();
        return accountData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountDataBean getAccountData(int accountID) throws Exception {
        AccountDataBean accountData = null;
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:getAccountData - inSession(" + this.inSession + ")"), (Object)new Integer(accountID));
            }
            conn = this.getConn();
            accountData = this.getAccountData(accountID, conn);
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getAccountData -- error getting account data", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return accountData;
    }

    private AccountDataBean getAccountData(int accountID, Connection conn) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, getAccountSQL);
        stmt.setInt(1, accountID);
        ResultSet rs = stmt.executeQuery();
        AccountDataBean accountData = this.getAccountDataFromResultSet(rs);
        stmt.close();
        return accountData;
    }

    private QuoteDataBean getQuoteData(Connection conn, String symbol) throws Exception {
        QuoteDataBean quoteData = null;
        PreparedStatement stmt = this.getStatement(conn, getQuoteSQL);
        stmt.setString(1, symbol);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            Log.error((String)("TradeJdbc:getQuoteData -- could not find quote for symbol=" + symbol));
        } else {
            quoteData = this.getQuoteDataFromResultSet(rs);
        }
        stmt.close();
        return quoteData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HoldingDataBean getHoldingData(int holdingID) throws Exception {
        HoldingDataBean holdingData = null;
        Connection conn = null;
        try {
            conn = this.getConn();
            holdingData = this.getHoldingData(conn, holdingID);
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getHoldingData -- error getting data", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return holdingData;
    }

    private HoldingDataBean getHoldingData(Connection conn, int holdingID) throws Exception {
        HoldingDataBean holdingData = null;
        PreparedStatement stmt = this.getStatement(conn, getHoldingSQL);
        stmt.setInt(1, holdingID);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            Log.error((String)("TradeJdbc:getHoldingData -- no results -- holdingID=" + holdingID));
        } else {
            holdingData = this.getHoldingDataFromResultSet(rs);
        }
        stmt.close();
        return holdingData;
    }

    private OrderDataBean getOrderData(Connection conn, int orderID) throws Exception {
        OrderDataBean orderData = null;
        if (Log.doTrace()) {
            Log.trace((String)("TradeJdbc:getOrderData(conn, " + orderID + ")"));
        }
        PreparedStatement stmt = this.getStatement(conn, getOrderSQL);
        stmt.setInt(1, orderID);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            Log.error((String)("TradeJdbc:getOrderData -- no results for orderID:" + orderID));
        } else {
            orderData = this.getOrderDataFromResultSet(rs);
        }
        stmt.close();
        return orderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountProfileDataBean getAccountProfileData(String userID) throws Exception {
        AccountProfileDataBean accountProfileData = null;
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:getAccountProfileData - inSession(" + this.inSession + ")"), (Object)userID);
            }
            conn = this.getConn();
            accountProfileData = this.getAccountProfileData(conn, userID);
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getAccountProfileData -- error getting profile data", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return accountProfileData;
    }

    private AccountProfileDataBean getAccountProfileData(Connection conn, String userID) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, getAccountProfileSQL);
        stmt.setString(1, userID);
        ResultSet rs = stmt.executeQuery();
        AccountProfileDataBean accountProfileData = this.getAccountProfileDataFromResultSet(rs);
        stmt.close();
        return accountProfileData;
    }

    private AccountProfileDataBean getAccountProfileData(Connection conn, Integer accountID) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, getAccountProfileForAccountSQL);
        stmt.setInt(1, accountID);
        ResultSet rs = stmt.executeQuery();
        AccountProfileDataBean accountProfileData = this.getAccountProfileDataFromResultSet(rs);
        stmt.close();
        return accountProfileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountProfileDataBean updateAccountProfile(String userID, String password, String fullName, String address, String email, String creditcard) throws Exception {
        AccountProfileDataBean accountProfileData = null;
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:updateAccountProfileData - inSession(" + this.inSession + ")"), (Object)userID);
            }
            conn = this.getConn();
            this.updateAccountProfile(conn, userID, password, fullName, address, email, creditcard);
            accountProfileData = this.getAccountProfileData(conn, userID);
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:getAccountProfileData -- error getting profile data", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return accountProfileData;
    }

    private void creditAccountBalance(Connection conn, AccountDataBean accountData, BigDecimal credit) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, creditAccountBalanceSQL);
        stmt.setBigDecimal(1, credit);
        stmt.setInt(2, accountData.getAccountID());
        stmt.executeUpdate();
        stmt.close();
    }

    private void updateHoldingStatus(Connection conn, Integer holdingID, String symbol) throws Exception {
        Timestamp ts = new Timestamp(0L);
        PreparedStatement stmt = this.getStatement(conn, "update holdingejb set purchasedate= ? where holdingid = ?");
        stmt.setTimestamp(1, ts);
        stmt.setInt(2, holdingID);
        stmt.executeUpdate();
        stmt.close();
    }

    private void updateOrderStatus(Connection conn, Integer orderID, String status) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, updateOrderStatusSQL);
        stmt.setString(1, status);
        stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        stmt.setInt(3, orderID);
        stmt.executeUpdate();
        stmt.close();
    }

    private void updateOrderHolding(Connection conn, int orderID, int holdingID) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, updateOrderHoldingSQL);
        stmt.setInt(1, holdingID);
        stmt.setInt(2, orderID);
        stmt.executeUpdate();
        stmt.close();
    }

    private void updateAccountProfile(Connection conn, String userID, String password, String fullName, String address, String email, String creditcard) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, updateAccountProfileSQL);
        stmt.setString(1, password);
        stmt.setString(2, fullName);
        stmt.setString(3, address);
        stmt.setString(4, email);
        stmt.setString(5, creditcard);
        stmt.setString(6, userID);
        stmt.executeUpdate();
        stmt.close();
    }

    public QuoteDataBean updateQuotePriceVolume(String symbol, BigDecimal changeFactor, double sharesTraded) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJdbc:updateQuotePriceVolume", (Object)symbol, (Object)changeFactor, (Object)new Double(sharesTraded));
        }
        return this.updateQuotePriceVolumeInt(symbol, changeFactor, sharesTraded, TradeConfig.getPublishQuotePriceChange());
    }

    public QuoteDataBean updateQuotePriceVolumeInt(String symbol, BigDecimal changeFactor, double sharesTraded, boolean publishQuotePriceChange) throws Exception {
        if (!TradeConfig.getUpdateQuotePrices()) {
            return new QuoteDataBeanImpl();
        }
        QuoteDataBean quoteData = null;
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:updateQuotePriceVolume - inSession(" + this.inSession + ")"), (Object)symbol, (Object)changeFactor, (Object)new Double(sharesTraded));
            }
            conn = this.getConn();
            quoteData = this.getQuoteForUpdate(conn, symbol);
            BigDecimal oldPrice = quoteData.getPrice();
            double newVolume = quoteData.getVolume() + sharesTraded;
            if (oldPrice.equals(TradeConfig.PENNY_STOCK_PRICE)) {
                changeFactor = TradeConfig.PENNY_STOCK_RECOVERY_MIRACLE_MULTIPLIER;
            } else if (oldPrice.compareTo(TradeConfig.MAXIMUM_STOCK_PRICE) > 0) {
                changeFactor = TradeConfig.MAXIMUM_STOCK_SPLIT_MULTIPLIER;
            }
            BigDecimal newPrice = changeFactor.multiply(oldPrice).setScale(2, 4);
            BigDecimal low = quoteData.getLow();
            BigDecimal high = quoteData.getHigh();
            if (newPrice.compareTo(high) == 1) {
                high = newPrice;
            } else if (newPrice.compareTo(low) == -1) {
                low = newPrice;
            }
            this.updateQuotePriceVolume(conn, quoteData.getSymbol(), newPrice, newVolume, low, high);
            quoteData = this.getQuote(conn, symbol);
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)("TradeJdbc:updateQuotePriceVolume -- error updating quote price/volume for symbol:" + symbol));
            this.rollBack(conn, e);
            throw e;
        }
        finally {
            this.releaseConn(conn);
        }
        return quoteData;
    }

    private void updateQuotePriceVolume(Connection conn, String symbol, BigDecimal newPrice, double newVolume, BigDecimal low, BigDecimal high) throws Exception {
        PreparedStatement stmt = this.getStatement(conn, updateQuotePriceVolumeSQL);
        stmt.setBigDecimal(1, newPrice);
        stmt.setBigDecimal(2, newPrice);
        stmt.setDouble(3, newVolume);
        stmt.setBigDecimal(4, low);
        stmt.setBigDecimal(5, high);
        stmt.setString(6, symbol);
        stmt.executeUpdate();
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountDataBean login(String userID, String password) throws Exception {
        AccountDataBean accountData = null;
        Connection conn = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)("TradeJdbc:login - inSession(" + this.inSession + ")"), (Object)userID, (Object)password);
            }
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, getAccountProfileSQL);
            stmt.setString(1, userID);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                Log.error((String)("TradeJdbc:login -- failure to find account for" + userID));
                throw new RuntimeException("Cannot find account for" + userID);
            }
            String pw = rs.getString("passwd");
            stmt.close();
            if (pw == null || !pw.equals(password)) {
                String error = "TradeJdbc:Login failure for user: " + userID + "\n\tIncorrect password-->" + userID + ":" + password;
                Log.error((String)error);
                throw new Exception(error);
            }
            stmt = this.getStatement(conn, loginSQL);
            stmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            stmt.setString(2, userID);
            stmt.executeUpdate();
            stmt.close();
            stmt = this.getStatement(conn, getAccountForUserSQL);
            stmt.setString(1, userID);
            rs = stmt.executeQuery();
            accountData = this.getAccountDataFromResultSet(rs);
            stmt.close();
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:login -- error logging in user", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
        return accountData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String userID) throws Exception {
        Connection conn = null;
        if (Log.doTrace()) {
            Log.trace((String)("TradeJdbc:logout - inSession(" + this.inSession + ")"), (Object)userID);
        }
        try {
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, logoutSQL);
            stmt.setString(1, userID);
            stmt.executeUpdate();
            stmt.close();
            this.commit(conn);
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:logout -- error logging out user", (Throwable)e);
            this.rollBack(conn, e);
        }
        finally {
            this.releaseConn(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountDataBean register(String userID, String password, String fullname, String address, String email, String creditCard, BigDecimal openBalance) throws Exception {
        AccountDataBeanImpl accountData = null;
        Connection conn = null;
        try {
            Timestamp creationDate;
            if (Log.doTrace()) {
                Log.traceEnter((String)("TradeJdbc:register - inSession(" + this.inSession + ")"));
            }
            conn = this.getConn();
            PreparedStatement stmt = this.getStatement(conn, createAccountSQL);
            Integer accountID = KeySequenceDirect.getNextID(conn, "account", this.inSession, this.getInGlobalTxn());
            BigDecimal balance = openBalance;
            Timestamp lastLogin = creationDate = new Timestamp(System.currentTimeMillis());
            int loginCount = 0;
            int logoutCount = 0;
            stmt.setInt(1, accountID);
            stmt.setTimestamp(2, creationDate);
            stmt.setBigDecimal(3, openBalance);
            stmt.setBigDecimal(4, balance);
            stmt.setTimestamp(5, lastLogin);
            stmt.setInt(6, loginCount);
            stmt.setInt(7, logoutCount);
            stmt.setString(8, userID);
            stmt.executeUpdate();
            stmt.close();
            stmt = this.getStatement(conn, createAccountProfileSQL);
            stmt.setString(1, userID);
            stmt.setString(2, password);
            stmt.setString(3, fullname);
            stmt.setString(4, address);
            stmt.setString(5, email);
            stmt.setString(6, creditCard);
            stmt.executeUpdate();
            stmt.close();
            this.commit(conn);
            accountData = new AccountDataBeanImpl(accountID, loginCount, logoutCount, (Date)lastLogin, (Date)creationDate, balance, openBalance, userID);
            if (Log.doTrace()) {
                Log.traceExit((String)"TradeJdbc:register");
            }
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:register -- error registering new user", (Throwable)e);
        }
        finally {
            this.releaseConn(conn);
        }
        return accountData;
    }

    private AccountDataBean getAccountDataFromResultSet(ResultSet rs) throws Exception {
        AccountDataBeanImpl accountData = null;
        if (!rs.next()) {
            Log.error((String)"TradeJdbc:getAccountDataFromResultSet -- cannot find account data");
        } else {
            accountData = new AccountDataBeanImpl(new Integer(rs.getInt("accountID")), rs.getInt("loginCount"), rs.getInt("logoutCount"), (Date)rs.getTimestamp("lastLogin"), (Date)rs.getTimestamp("creationDate"), rs.getBigDecimal("balance"), rs.getBigDecimal("openBalance"), rs.getString("profile_userID"));
        }
        return accountData;
    }

    private AccountProfileDataBean getAccountProfileDataFromResultSet(ResultSet rs) throws Exception {
        AccountProfileDataBeanImpl accountProfileData = null;
        if (!rs.next()) {
            Log.error((String)"TradeJdbc:getAccountProfileDataFromResultSet -- cannot find accountprofile data");
        } else {
            accountProfileData = new AccountProfileDataBeanImpl(rs.getString("userID"), rs.getString("passwd"), rs.getString("fullName"), rs.getString("address"), rs.getString("email"), rs.getString("creditCard"));
        }
        return accountProfileData;
    }

    private HoldingDataBean getHoldingDataFromResultSet(ResultSet rs) throws Exception {
        HoldingDataBeanImpl holdingData = null;
        holdingData = new HoldingDataBeanImpl(new Integer(rs.getInt("holdingID")), rs.getDouble("quantity"), rs.getBigDecimal("purchasePrice"), (Date)rs.getTimestamp("purchaseDate"), rs.getString("quote_symbol"));
        return holdingData;
    }

    private QuoteDataBean getQuoteDataFromResultSet(ResultSet rs) throws Exception {
        QuoteDataBeanImpl quoteData = null;
        quoteData = new QuoteDataBeanImpl(rs.getString("symbol"), rs.getString("companyName"), rs.getDouble("volume"), rs.getBigDecimal("price"), rs.getBigDecimal("open1"), rs.getBigDecimal("low"), rs.getBigDecimal("high"), rs.getDouble("change1"));
        return quoteData;
    }

    private OrderDataBean getOrderDataFromResultSet(ResultSet rs) throws Exception {
        OrderDataBeanImpl orderData = null;
        orderData = new OrderDataBeanImpl(new Integer(rs.getInt("orderID")), rs.getString("orderType"), rs.getString("orderStatus"), (Date)rs.getTimestamp("openDate"), (Date)rs.getTimestamp("completionDate"), rs.getDouble("quantity"), rs.getBigDecimal("price"), rs.getBigDecimal("orderFee"), rs.getString("quote_symbol"));
        return orderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConn(Connection conn) throws Exception {
        block5: {
            try {
                if (conn == null) break block5;
                conn.close();
                if (!Log.doTrace()) break block5;
                Integer n = lock;
                synchronized (n) {
                }
                Log.trace((String)("TradeJdbc:releaseConn -- connection closed, connCount=" + --connCount));
            }
            catch (Exception e) {
                Log.error((String)"TradeJdbc:releaseConnection -- failed to close connection", (Throwable)e);
            }
        }
    }

    private void lookupDataSource() throws Exception {
        if (this.dataSource == null) {
            this.dataSource = (DataSource)ServiceUtilities.getOSGIService((String)DataSource.class.getName(), (String)TradeConfig.OSGI_DS_NAME_FILTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConn() throws Exception {
        Connection conn = null;
        this.lookupDataSource();
        conn = this.dataSource.getConnection();
        conn.setAutoCommit(false);
        if (Log.doTrace()) {
            Integer n = lock;
            synchronized (n) {
            }
            Log.trace((String)("TradeJdbc:getConn -- new connection allocated, IsolationLevel=" + conn.getTransactionIsolation() + " connectionCount = " + ++connCount));
        }
        return conn;
    }

    private void commit(Connection conn) throws Exception {
        if (!this.inSession && !this.getInGlobalTxn() && conn != null) {
            conn.commit();
        }
    }

    private void rollBack(Connection conn, Exception e) throws Exception {
        if (!this.inSession) {
            Log.log((String)("TradeJdbc:rollBack -- rolling back conn due to previously caught exception -- inGlobalTxn=" + this.getInGlobalTxn()));
            if (!this.getInGlobalTxn() && conn != null) {
                conn.rollback();
            } else {
                throw e;
            }
        }
    }

    private PreparedStatement getStatement(Connection conn, String sql) throws Exception {
        return conn.prepareStatement(sql);
    }

    private PreparedStatement getStatement(Connection conn, String sql, int type, int concurrency) throws Exception {
        return conn.prepareStatement(sql, type, concurrency);
    }

    public void init() {
        if (initialized) {
            return;
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeJdbc:init -- *** initializing");
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeJdbc:init -- +++ initialized");
        }
        initialized = true;
    }

    public void destroy() {
        try {
            if (!initialized) {
                return;
            }
            Log.trace((String)"TradeJdbc:destroy");
        }
        catch (Exception e) {
            Log.error((String)"TradeJdbc:destroy", (Throwable)e);
        }
    }

    private boolean getInGlobalTxn() {
        return this.inGlobalTxn;
    }

    private void setInGlobalTxn(boolean inGlobalTxn) {
        this.inGlobalTxn = inGlobalTxn;
    }

    public TradeConfig.ModeType getMode() {
        return TradeConfig.ModeType.JDBC;
    }
}

