/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.persist.jpa.am;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.persistence.AccountDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.AccountProfileDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.HoldingDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.MarketSummaryDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.OrderDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.QuoteDataBean;
import org.apache.aries.samples.ariestrader.entities.AccountDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.AccountProfileDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.HoldingDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.OrderDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.QuoteDataBeanImpl;
import org.apache.aries.samples.ariestrader.util.FinancialUtils;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeJpaAm
implements TradeServices {
    private static EntityManagerFactory emf;
    private static boolean initialized;

    public void setEmf(EntityManagerFactory emf) {
        TradeJpaAm.emf = emf;
    }

    public void init() {
        if (initialized) {
            return;
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:init -- *** initializing");
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:init -- +++ initialized");
        }
        initialized = true;
    }

    public void destroy() {
        try {
            if (!initialized) {
                return;
            }
            Log.trace((String)"TradeJpaAm:destroy");
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaAm:destroy", (Throwable)e);
        }
    }

    public MarketSummaryDataBean getMarketSummary() {
        MarketSummaryDataBean marketSummaryData;
        EntityManager entityManager = emf.createEntityManager();
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeJpaAm:getMarketSummary -- getting market summary");
            }
            Query query = entityManager.createNamedQuery("quoteejb.quotesByChange");
            List quotes = query.getResultList();
            QuoteDataBean[] quoteArray = quotes.toArray(new QuoteDataBean[quotes.size()]);
            ArrayList<QuoteDataBean> topGainers = new ArrayList<QuoteDataBean>(5);
            ArrayList<QuoteDataBean> topLosers = new ArrayList<QuoteDataBean>(5);
            BigDecimal TSIA = FinancialUtils.ZERO;
            BigDecimal openTSIA = FinancialUtils.ZERO;
            double totalVolume = 0.0;
            if (quoteArray.length > 5) {
                int i;
                for (i = 0; i < 5; ++i) {
                    topGainers.add(quoteArray[i]);
                }
                for (i = quoteArray.length - 1; i >= quoteArray.length - 5; --i) {
                    topLosers.add(quoteArray[i]);
                }
                for (QuoteDataBean quote : quoteArray) {
                    BigDecimal price = quote.getPrice();
                    BigDecimal open = quote.getOpen();
                    double volume = quote.getVolume();
                    TSIA = TSIA.add(price);
                    openTSIA = openTSIA.add(open);
                    totalVolume += volume;
                }
                TSIA = TSIA.divide(new BigDecimal(quoteArray.length), 4);
                openTSIA = openTSIA.divide(new BigDecimal(quoteArray.length), 4);
            }
            marketSummaryData = new MarketSummaryDataBean(TSIA, openTSIA, totalVolume, topGainers, topLosers);
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaAm:getMarketSummary", (Throwable)e);
            throw new RuntimeException("TradeJpaAm:getMarketSummary -- error ", e);
        }
        entityManager.close();
        return marketSummaryData;
    }

    public OrderDataBean buy(String userID, String symbol, double quantity, int orderProcessingMode) {
        OrderDataBean order = null;
        EntityManager entityManager = emf.createEntityManager();
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeJpaAm:buy", (Object)userID, (Object)symbol, (Object)quantity, (Object)orderProcessingMode);
            }
            entityManager.getTransaction().begin();
            AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
            AccountDataBean account = profile.getAccount();
            QuoteDataBeanImpl quote = (QuoteDataBeanImpl)entityManager.find(QuoteDataBeanImpl.class, (Object)symbol);
            HoldingDataBean holding = null;
            order = this.createOrder(account, (QuoteDataBean)quote, holding, "buy", quantity, entityManager);
            BigDecimal price = quote.getPrice();
            BigDecimal orderFee = order.getOrderFee();
            BigDecimal balance = account.getBalance();
            BigDecimal total = new BigDecimal(quantity).multiply(price).add(orderFee);
            account.setBalance(balance.subtract(total));
            entityManager.getTransaction().commit();
            if (orderProcessingMode == 0) {
                this.completeOrder(order.getOrderID(), false);
            } else if (orderProcessingMode == 1) {
                this.queueOrder(order.getOrderID(), true);
            }
        }
        catch (Exception e) {
            Log.error((String)("TradeJpaAm:buy(" + userID + "," + symbol + "," + quantity + ") --> failed"), (Throwable)e);
            if (order != null) {
                order.cancel();
            }
            entityManager.getTransaction().rollback();
            throw new RuntimeException(e);
        }
        if (entityManager != null) {
            entityManager.close();
            entityManager = null;
        }
        this.updateQuotePriceVolume(symbol, TradeConfig.getRandomPriceChangeFactor(), quantity);
        return order;
    }

    public OrderDataBean sell(String userID, Integer holdingID, int orderProcessingMode) {
        EntityManager entityManager = emf.createEntityManager();
        OrderDataBean order = null;
        try {
            entityManager.getTransaction().begin();
            if (Log.doTrace()) {
                Log.trace((String)"TradeJpaAm:sell", (Object)userID, (Object)holdingID, (Object)orderProcessingMode);
            }
            AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
            AccountDataBean account = profile.getAccount();
            HoldingDataBeanImpl holding = (HoldingDataBeanImpl)entityManager.find(HoldingDataBeanImpl.class, (Object)holdingID);
            if (holding == null) {
                Log.error((String)("TradeJpaAm:sell User " + userID + " attempted to sell holding " + holdingID + " which has already been sold"));
                OrderDataBeanImpl orderData = new OrderDataBeanImpl();
                orderData.setOrderStatus("cancelled");
                entityManager.persist((Object)orderData);
                entityManager.getTransaction().commit();
                if (entityManager != null) {
                    entityManager.close();
                    entityManager = null;
                }
                return orderData;
            }
            QuoteDataBean quote = holding.getQuote();
            double quantity = holding.getQuantity();
            order = this.createOrder(account, quote, (HoldingDataBean)holding, "sell", quantity, entityManager);
            holding.setPurchaseDate((Date)new Timestamp(0L));
            BigDecimal price = quote.getPrice();
            BigDecimal orderFee = order.getOrderFee();
            BigDecimal balance = account.getBalance();
            BigDecimal total = new BigDecimal(quantity).multiply(price).subtract(orderFee);
            account.setBalance(balance.add(total));
            entityManager.getTransaction().commit();
            if (orderProcessingMode == 0) {
                this.completeOrder(order.getOrderID(), false);
            } else if (orderProcessingMode == 1) {
                this.queueOrder(order.getOrderID(), true);
            }
        }
        catch (Exception e) {
            Log.error((String)("TradeJpaAm:sell(" + userID + "," + holdingID + ") --> failed"), (Throwable)e);
            if (order != null) {
                order.cancel();
            }
            entityManager.getTransaction().rollback();
            throw new RuntimeException("TradeJpaAm:sell(" + userID + "," + holdingID + ")", e);
        }
        if (entityManager != null) {
            entityManager.close();
            entityManager = null;
        }
        if (!order.getOrderStatus().equalsIgnoreCase("cancelled")) {
            this.updateQuotePriceVolume(order.getSymbol(), TradeConfig.getRandomPriceChangeFactor(), order.getQuantity());
        }
        return order;
    }

    public void queueOrder(Integer orderID, boolean twoPhase) {
        Log.error((String)"TradeJpaAm:queueOrder() not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJpaAm:queueOrder() not implemented for this runtime mode");
    }

    public OrderDataBean completeOrder(Integer orderID, boolean twoPhase) throws Exception {
        EntityManager entityManager = emf.createEntityManager();
        OrderDataBeanImpl order = null;
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:completeOrder", (Object)(orderID + " twoPhase=" + twoPhase));
        }
        order = (OrderDataBeanImpl)entityManager.find(OrderDataBeanImpl.class, (Object)orderID);
        order.getQuote();
        if (order == null) {
            Log.error((String)("TradeJpaAm:completeOrder -- Unable to find Order " + orderID + " FBPK returned " + order));
            return null;
        }
        if (order.isCompleted()) {
            throw new RuntimeException("Error: attempt to complete Order that is already completed\n" + order);
        }
        AccountDataBean account = order.getAccount();
        QuoteDataBean quote = order.getQuote();
        HoldingDataBean holding = order.getHolding();
        BigDecimal price = order.getPrice();
        double quantity = order.getQuantity();
        if (Log.doTrace()) {
            Log.trace((String)("TradeJpaAm:completeOrder--> Completing Order " + order.getOrderID() + "\n\t Order info: " + order + "\n\t Account info: " + account + "\n\t Quote info: " + quote + "\n\t Holding info: " + holding));
        }
        HoldingDataBean newHolding = null;
        if (order.isBuy()) {
            newHolding = this.createHolding(account, quote, quantity, price, entityManager);
        }
        try {
            entityManager.getTransaction().begin();
            if (newHolding != null) {
                order.setHolding(newHolding);
            }
            if (order.isSell()) {
                if (holding == null) {
                    Log.error((String)("TradeJpaAm:completeOrder -- Unable to sell order " + order.getOrderID() + " holding already sold"));
                    order.cancel();
                    entityManager.getTransaction().commit();
                    return order;
                }
                entityManager.remove((Object)holding);
                order.setHolding(null);
            }
            order.setOrderStatus("closed");
            order.setCompletionDate((Date)new Timestamp(System.currentTimeMillis()));
            if (Log.doTrace()) {
                Log.trace((String)("TradeJpaAm:completeOrder--> Completed Order " + order.getOrderID() + "\n\t Order info: " + order + "\n\t Account info: " + account + "\n\t Quote info: " + quote + "\n\t Holding info: " + holding));
            }
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            entityManager.getTransaction().rollback();
        }
        if (entityManager != null) {
            entityManager.close();
            entityManager = null;
        }
        return order;
    }

    public void cancelOrder(Integer orderID, boolean twoPhase) {
        EntityManager entityManager = emf.createEntityManager();
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:cancelOrder", (Object)(orderID + " twoPhase=" + twoPhase));
        }
        OrderDataBeanImpl order = (OrderDataBeanImpl)entityManager.find(OrderDataBeanImpl.class, (Object)orderID);
        try {
            entityManager.getTransaction().begin();
            order.cancel();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
            entityManager.close();
            entityManager = null;
        }
        entityManager.close();
    }

    public void orderCompleted(String userID, Integer orderID) {
        if (Log.doActionTrace()) {
            Log.trace((String)"TradeAction:orderCompleted", (Object)userID, (Object)orderID);
        }
        if (Log.doTrace()) {
            Log.trace((String)"OrderCompleted", (Object)userID, (Object)orderID);
        }
    }

    public Collection<OrderDataBean> getOrders(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:getOrders", (Object)userID);
        }
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        entityManager.close();
        return account.getOrders();
    }

    public Collection<OrderDataBean> getClosedOrders(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:getClosedOrders", (Object)userID);
        }
        EntityManager entityManager = emf.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            Query query = entityManager.createNamedQuery("orderejb.closedOrders");
            query.setParameter("userID", (Object)userID);
            entityManager.getTransaction().commit();
            List results = query.getResultList();
            for (OrderDataBeanImpl thisOrder : results) {
                thisOrder.getQuote();
            }
            if (TradeConfig.jpaLayer == 0) {
                Query updateStatus = entityManager.createNamedQuery("orderejb.completeClosedOrders");
                try {
                    entityManager.getTransaction().begin();
                    updateStatus.setParameter("userID", (Object)userID);
                    updateStatus.executeUpdate();
                    entityManager.getTransaction().commit();
                }
                catch (Exception e) {
                    entityManager.getTransaction().rollback();
                    entityManager.close();
                    entityManager = null;
                }
            } else if (TradeConfig.jpaLayer == 1) {
                Query findaccountid = entityManager.createNativeQuery("select a.ACCOUNTID, a.LOGINCOUNT, a.LOGOUTCOUNT, a.LASTLOGIN, a.CREATIONDATE, a.BALANCE, a.OPENBALANCE, a.PROFILE_USERID from accountejb a where a.profile_userid = ?", AccountDataBeanImpl.class);
                findaccountid.setParameter(1, (Object)userID);
                AccountDataBeanImpl account = (AccountDataBeanImpl)findaccountid.getSingleResult();
                Integer accountid = account.getAccountID();
                Query updateStatus = entityManager.createNativeQuery("UPDATE orderejb o SET o.orderStatus = 'completed' WHERE o.orderStatus = 'closed' AND o.ACCOUNT_ACCOUNTID  = ?");
                updateStatus.setParameter(1, (Object)accountid);
                updateStatus.executeUpdate();
            }
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
            return results;
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaAm.getClosedOrders", (Throwable)e);
            entityManager.close();
            entityManager = null;
            throw new RuntimeException("TradeJpaAm.getClosedOrders - error", e);
        }
    }

    public QuoteDataBean createQuote(String symbol, String companyName, BigDecimal price) {
        EntityManager entityManager = emf.createEntityManager();
        try {
            QuoteDataBeanImpl quote = new QuoteDataBeanImpl(symbol, companyName, 0.0, price, price, price, price, 0.0);
            try {
                entityManager.getTransaction().begin();
                entityManager.persist((Object)quote);
                entityManager.getTransaction().commit();
            }
            catch (Exception e) {
                entityManager.getTransaction().rollback();
            }
            if (Log.doTrace()) {
                Log.trace((String)("TradeJpaAm:createQuote-->" + quote));
            }
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
            return quote;
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaAm:createQuote -- exception creating Quote", (Throwable)e);
            entityManager.close();
            entityManager = null;
            throw new RuntimeException(e);
        }
    }

    public QuoteDataBean getQuote(String symbol) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:getQuote", (Object)symbol);
        }
        EntityManager entityManager = emf.createEntityManager();
        QuoteDataBeanImpl qdb = (QuoteDataBeanImpl)entityManager.find(QuoteDataBeanImpl.class, (Object)symbol);
        if (entityManager != null) {
            entityManager.close();
            entityManager = null;
        }
        return qdb;
    }

    public Collection<QuoteDataBean> getAllQuotes() {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:getAllQuotes");
        }
        EntityManager entityManager = emf.createEntityManager();
        Query query = entityManager.createNamedQuery("quoteejb.allQuotes");
        if (entityManager != null) {
            entityManager.close();
            entityManager = null;
        }
        return query.getResultList();
    }

    public QuoteDataBean updateQuotePriceVolume(String symbol, BigDecimal changeFactor, double sharesTraded) {
        if (!TradeConfig.getUpdateQuotePrices()) {
            return new QuoteDataBeanImpl();
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:updateQuote", (Object)symbol, (Object)changeFactor);
        }
        EntityManager entityManager = emf.createEntityManager();
        QuoteDataBeanImpl quote = null;
        if (TradeConfig.jpaLayer == 1) {
            quote = (QuoteDataBeanImpl)entityManager.find(QuoteDataBeanImpl.class, (Object)symbol);
        } else if (TradeConfig.jpaLayer == 0) {
            Query q = entityManager.createNamedQuery("quoteejb.quoteForUpdate");
            q.setParameter(1, (Object)symbol);
            quote = (QuoteDataBeanImpl)q.getSingleResult();
        }
        BigDecimal oldPrice = quote.getPrice();
        if (quote.getPrice().equals(TradeConfig.PENNY_STOCK_PRICE)) {
            changeFactor = TradeConfig.PENNY_STOCK_RECOVERY_MIRACLE_MULTIPLIER;
        }
        BigDecimal newPrice = changeFactor.multiply(oldPrice).setScale(2, 4);
        try {
            quote.setPrice(newPrice);
            quote.setVolume(quote.getVolume() + sharesTraded);
            quote.setChange(newPrice.subtract(quote.getOpen()).doubleValue());
            if (newPrice.compareTo(quote.getHigh()) == 1) {
                quote.setHigh(newPrice);
            } else if (newPrice.compareTo(quote.getLow()) == -1) {
                quote.setLow(newPrice);
            }
            entityManager.getTransaction().begin();
            entityManager.merge((Object)quote);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
        }
        if (entityManager != null) {
            entityManager.close();
            entityManager = null;
        }
        this.publishQuotePriceChange((QuoteDataBean)quote, oldPrice, changeFactor, sharesTraded);
        return quote;
    }

    public Collection<HoldingDataBean> getHoldings(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:getHoldings", (Object)userID);
        }
        EntityManager entityManager = emf.createEntityManager();
        entityManager.getTransaction().begin();
        Query query = entityManager.createNamedQuery("holdingejb.holdingsByUserID");
        query.setParameter("userID", (Object)userID);
        entityManager.getTransaction().commit();
        List holdings = query.getResultList();
        Iterator itr = holdings.iterator();
        while (itr.hasNext()) {
            ((HoldingDataBean)itr.next()).getQuote();
        }
        entityManager.close();
        entityManager = null;
        return holdings;
    }

    public HoldingDataBean getHolding(Integer holdingID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:getHolding", (Object)holdingID);
        }
        EntityManager entityManager = emf.createEntityManager();
        return (HoldingDataBean)entityManager.find(HoldingDataBeanImpl.class, (Object)holdingID);
    }

    public AccountDataBean getAccountData(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:getAccountData", (Object)userID);
        }
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        account.getProfile();
        account.setProfileID(profile.getUserID());
        entityManager.close();
        entityManager = null;
        return account;
    }

    public AccountProfileDataBean getAccountProfileData(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:getProfileData", (Object)userID);
        }
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBeanImpl apb = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        entityManager.close();
        entityManager = null;
        return apb;
    }

    public AccountProfileDataBean updateAccountProfile(String userID, String password, String fullName, String address, String email, String creditcard) throws Exception {
        EntityManager entityManager = emf.createEntityManager();
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:updateAccountProfileData", (Object)userID);
        }
        AccountProfileDataBeanImpl temp = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        temp.setAddress(address);
        temp.setPassword(password);
        temp.setFullName(fullName);
        temp.setCreditCard(creditcard);
        temp.setEmail(email);
        try {
            entityManager.getTransaction().begin();
            entityManager.merge((Object)temp);
            entityManager.getTransaction().commit();
            entityManager.close();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
            entityManager.close();
            entityManager = null;
        }
        return temp;
    }

    public AccountDataBean login(String userID, String password) throws Exception {
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        if (profile == null) {
            throw new RuntimeException("No such user: " + userID);
        }
        entityManager.getTransaction().begin();
        entityManager.merge((Object)profile);
        AccountDataBean account = profile.getAccount();
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:login", (Object)userID, (Object)password);
        }
        account.login(password);
        entityManager.getTransaction().commit();
        if (Log.doTrace()) {
            Log.trace((String)("TradeJpaAm:login(" + userID + "," + password + ") success" + account));
        }
        entityManager.close();
        return account;
    }

    public void logout(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:logout", (Object)userID);
        }
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        try {
            entityManager.getTransaction().begin();
            account.logout();
            entityManager.getTransaction().commit();
            entityManager.close();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
            entityManager.close();
            entityManager = null;
        }
        if (Log.doTrace()) {
            Log.trace((String)("TradeJpaAm:logout(" + userID + ") success"));
        }
    }

    public AccountDataBean register(String userID, String password, String fullname, String address, String email, String creditcard, BigDecimal openBalance) {
        AccountDataBeanImpl account = null;
        AccountProfileDataBeanImpl profile = null;
        EntityManager entityManager = emf.createEntityManager();
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:register", (Object)userID, (Object)password, (Object)fullname, (Object)address, (Object)email, (Object)creditcard, (Object)openBalance);
        }
        if ((profile = (AccountProfileDataBeanImpl)entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID)) != null) {
            Log.error((String)("Failed to register new Account - AccountProfile with userID(" + userID + ") already exists"));
            return null;
        }
        profile = new AccountProfileDataBeanImpl(userID, password, fullname, address, email, creditcard);
        account = new AccountDataBeanImpl(0, 0, null, (Date)new Timestamp(System.currentTimeMillis()), openBalance, openBalance, userID);
        profile.setAccount((AccountDataBean)account);
        account.setProfile((AccountProfileDataBean)profile);
        try {
            entityManager.getTransaction().begin();
            entityManager.persist((Object)profile);
            entityManager.persist((Object)account);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
            entityManager.close();
            entityManager = null;
        }
        return account;
    }

    private void publishQuotePriceChange(QuoteDataBean quote, BigDecimal oldPrice, BigDecimal changeFactor, double sharesTraded) {
        if (!TradeConfig.getPublishQuotePriceChange()) {
            return;
        }
        Log.error((String)"TradeJpaAm:publishQuotePriceChange - is not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJpaAm:publishQuotePriceChange - is not implemented for this runtime mode");
    }

    private OrderDataBean createOrder(AccountDataBean account, QuoteDataBean quote, HoldingDataBean holding, String orderType, double quantity, EntityManager entityManager) {
        OrderDataBeanImpl order;
        if (Log.doTrace()) {
            Log.trace((String)("TradeJpaAm:createOrder(orderID= account=" + (account == null ? null : account.getAccountID()) + " quote=" + (quote == null ? null : quote.getSymbol()) + " orderType=" + orderType + " quantity=" + quantity));
        }
        try {
            order = new OrderDataBeanImpl(orderType, "open", (Date)new Timestamp(System.currentTimeMillis()), null, quantity, quote.getPrice().setScale(2, 4), TradeConfig.getOrderFee((String)orderType), account, quote, holding);
            entityManager.persist((Object)order);
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaAm:createOrder -- failed to create Order", (Throwable)e);
            throw new RuntimeException("TradeJpaAm:createOrder -- failed to create Order", e);
        }
        return order;
    }

    private HoldingDataBean createHolding(AccountDataBean account, QuoteDataBean quote, double quantity, BigDecimal purchasePrice, EntityManager entityManager) throws Exception {
        HoldingDataBeanImpl newHolding = new HoldingDataBeanImpl(quantity, purchasePrice, (Date)new Timestamp(System.currentTimeMillis()), account, quote);
        try {
            entityManager.getTransaction().begin();
            entityManager.persist((Object)newHolding);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
            entityManager.close();
            entityManager = null;
        }
        return newHolding;
    }

    public double investmentReturn(double investment, double NetValue) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaAm:investmentReturn");
        }
        double diff = NetValue - investment;
        double ir = diff / investment;
        return ir;
    }

    public QuoteDataBean pingTwoPhase(String symbol) throws Exception {
        Log.error((String)"TradeJpaAm:pingTwoPhase - is not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJpaAm:pingTwoPhase - is not implemented for this runtime mode");
    }

    public TradeConfig.ModeType getMode() {
        return TradeConfig.ModeType.JPA_AM;
    }

    static {
        initialized = false;
    }

    class quotePriceComparator
    implements Comparator {
        quotePriceComparator() {
        }

        public int compare(Object quote1, Object quote2) {
            double change1 = ((QuoteDataBean)quote1).getChange();
            double change2 = ((QuoteDataBean)quote2).getChange();
            return new Double(change2).compareTo(change1);
        }
    }
}

