/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.persist.jpa.cm;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.persistence.AccountDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.AccountProfileDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.HoldingDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.MarketSummaryDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.OrderDataBean;
import org.apache.aries.samples.ariestrader.api.persistence.QuoteDataBean;
import org.apache.aries.samples.ariestrader.entities.AccountDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.AccountProfileDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.HoldingDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.OrderDataBeanImpl;
import org.apache.aries.samples.ariestrader.entities.QuoteDataBeanImpl;
import org.apache.aries.samples.ariestrader.util.FinancialUtils;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeJpaCm
implements TradeServices {
    private EntityManager entityManager;
    private static boolean initialized = false;

    public void setEntityManager(EntityManager em) {
        this.entityManager = em;
    }

    public void init() {
        if (initialized) {
            return;
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:init -- *** initializing");
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:init -- +++ initialized");
        }
        initialized = true;
    }

    public void destroy() {
        try {
            if (!initialized) {
                return;
            }
            Log.trace((String)"TradeJpaCm:destroy");
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaCm:destroy", (Throwable)e);
        }
    }

    public MarketSummaryDataBean getMarketSummary() {
        MarketSummaryDataBean marketSummaryData;
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeJpaCm:getMarketSummary -- getting market summary");
            }
            Query query = this.entityManager.createNamedQuery("quoteejb.quotesByChange");
            List quotes = query.getResultList();
            QuoteDataBean[] quoteArray = quotes.toArray(new QuoteDataBean[quotes.size()]);
            ArrayList<QuoteDataBean> topGainers = new ArrayList<QuoteDataBean>(5);
            ArrayList<QuoteDataBean> topLosers = new ArrayList<QuoteDataBean>(5);
            BigDecimal TSIA = FinancialUtils.ZERO;
            BigDecimal openTSIA = FinancialUtils.ZERO;
            double totalVolume = 0.0;
            if (quoteArray.length > 5) {
                int i;
                for (i = 0; i < 5; ++i) {
                    topGainers.add(quoteArray[i]);
                }
                for (i = quoteArray.length - 1; i >= quoteArray.length - 5; --i) {
                    topLosers.add(quoteArray[i]);
                }
                for (QuoteDataBean quote : quoteArray) {
                    BigDecimal price = quote.getPrice();
                    BigDecimal open = quote.getOpen();
                    double volume = quote.getVolume();
                    TSIA = TSIA.add(price);
                    openTSIA = openTSIA.add(open);
                    totalVolume += volume;
                }
                TSIA = TSIA.divide(new BigDecimal(quoteArray.length), 4);
                openTSIA = openTSIA.divide(new BigDecimal(quoteArray.length), 4);
            }
            marketSummaryData = new MarketSummaryDataBean(TSIA, openTSIA, totalVolume, topGainers, topLosers);
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaCm:getMarketSummary", (Throwable)e);
            throw new RuntimeException("TradeJpaCm:getMarketSummary -- error ", e);
        }
        return marketSummaryData;
    }

    public OrderDataBean buy(String userID, String symbol, double quantity, int orderProcessingMode) throws Exception {
        OrderDataBean order = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeJpaCm:buy", (Object)userID, (Object)symbol, (Object)quantity, (Object)orderProcessingMode);
            }
            AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
            AccountDataBean account = profile.getAccount();
            QuoteDataBeanImpl quote = (QuoteDataBeanImpl)this.entityManager.find(QuoteDataBeanImpl.class, (Object)symbol);
            HoldingDataBean holding = null;
            order = this.createOrder(account, (QuoteDataBean)quote, holding, "buy", quantity);
            BigDecimal price = quote.getPrice();
            BigDecimal orderFee = order.getOrderFee();
            BigDecimal balance = account.getBalance();
            BigDecimal total = new BigDecimal(quantity).multiply(price).add(orderFee);
            account.setBalance(balance.subtract(total));
            if (orderProcessingMode == 0) {
                this.completeOrder(order.getOrderID(), false);
            } else if (orderProcessingMode == 1) {
                this.queueOrder(order.getOrderID(), true);
            }
        }
        catch (Exception e) {
            Log.error((String)("TradeJpaCm:buy(" + userID + "," + symbol + "," + quantity + ") --> failed"), (Throwable)e);
            if (order != null) {
                order.cancel();
            }
            throw new RuntimeException(e);
        }
        this.updateQuotePriceVolume(symbol, TradeConfig.getRandomPriceChangeFactor(), quantity);
        return order;
    }

    public OrderDataBean sell(String userID, Integer holdingID, int orderProcessingMode) throws Exception {
        OrderDataBean order = null;
        try {
            if (Log.doTrace()) {
                Log.trace((String)"TradeJpaCm:sell", (Object)userID, (Object)holdingID, (Object)orderProcessingMode);
            }
            AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
            AccountDataBean account = profile.getAccount();
            HoldingDataBeanImpl holding = (HoldingDataBeanImpl)this.entityManager.find(HoldingDataBeanImpl.class, (Object)holdingID);
            if (holding == null) {
                Log.error((String)("TradeJpaCm:sell User " + userID + " attempted to sell holding " + holdingID + " which has already been sold"));
                OrderDataBeanImpl orderData = new OrderDataBeanImpl();
                orderData.setOrderStatus("cancelled");
                this.entityManager.persist((Object)orderData);
                return orderData;
            }
            QuoteDataBean quote = holding.getQuote();
            double quantity = holding.getQuantity();
            order = this.createOrder(account, quote, (HoldingDataBean)holding, "sell", quantity);
            holding.setPurchaseDate((Date)new Timestamp(0L));
            BigDecimal price = quote.getPrice();
            BigDecimal orderFee = order.getOrderFee();
            BigDecimal balance = account.getBalance();
            BigDecimal total = new BigDecimal(quantity).multiply(price).subtract(orderFee);
            account.setBalance(balance.add(total));
            if (orderProcessingMode == 0) {
                this.completeOrder(order.getOrderID(), false);
            } else if (orderProcessingMode == 1) {
                this.queueOrder(order.getOrderID(), true);
            }
        }
        catch (Exception e) {
            Log.error((String)("TradeJpaCm:sell(" + userID + "," + holdingID + ") --> failed"), (Throwable)e);
            if (order != null) {
                order.cancel();
            }
            throw new RuntimeException("TradeJpaCm:sell(" + userID + "," + holdingID + ")", e);
        }
        if (!order.getOrderStatus().equalsIgnoreCase("cancelled")) {
            this.updateQuotePriceVolume(order.getSymbol(), TradeConfig.getRandomPriceChangeFactor(), order.getQuantity());
        }
        return order;
    }

    public void queueOrder(Integer orderID, boolean twoPhase) {
        Log.error((String)"TradeJpaCm:queueOrder() not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJpaCm:queueOrder() not implemented for this runtime mode");
    }

    public OrderDataBean completeOrder(Integer orderID, boolean twoPhase) throws Exception {
        OrderDataBeanImpl order = null;
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:completeOrder", (Object)(orderID + " twoPhase=" + twoPhase));
        }
        order = (OrderDataBeanImpl)this.entityManager.find(OrderDataBeanImpl.class, (Object)orderID);
        order.getQuote();
        if (order == null) {
            Log.error((String)("TradeJpaCm:completeOrder -- Unable to find Order " + orderID + " FBPK returned " + order));
            return null;
        }
        if (order.isCompleted()) {
            throw new RuntimeException("Error: attempt to complete Order that is already completed\n" + order);
        }
        AccountDataBean account = order.getAccount();
        QuoteDataBean quote = order.getQuote();
        HoldingDataBean holding = order.getHolding();
        BigDecimal price = order.getPrice();
        double quantity = order.getQuantity();
        if (Log.doTrace()) {
            Log.trace((String)("TradeJpaCm:completeOrder--> Completing Order " + order.getOrderID() + "\n\t Order info: " + order + "\n\t Account info: " + account + "\n\t Quote info: " + quote + "\n\t Holding info: " + holding));
        }
        HoldingDataBean newHolding = null;
        if (order.isBuy()) {
            newHolding = this.createHolding(account, quote, quantity, price);
        }
        try {
            if (newHolding != null) {
                order.setHolding(newHolding);
            }
            if (order.isSell()) {
                if (holding == null) {
                    Log.error((String)("TradeJpaCm:completeOrder -- Unable to sell order " + order.getOrderID() + " holding already sold"));
                    order.cancel();
                    return order;
                }
                this.entityManager.remove((Object)holding);
                order.setHolding(null);
            }
            order.setOrderStatus("closed");
            order.setCompletionDate((Date)new Timestamp(System.currentTimeMillis()));
            if (Log.doTrace()) {
                Log.trace((String)("TradeJpaCm:completeOrder--> Completed Order " + order.getOrderID() + "\n\t Order info: " + order + "\n\t Account info: " + account + "\n\t Quote info: " + quote + "\n\t Holding info: " + holding));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return order;
    }

    public void cancelOrder(Integer orderID, boolean twoPhase) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:cancelOrder", (Object)(orderID + " twoPhase=" + twoPhase));
        }
        OrderDataBeanImpl order = (OrderDataBeanImpl)this.entityManager.find(OrderDataBeanImpl.class, (Object)orderID);
        order.cancel();
    }

    public void orderCompleted(String userID, Integer orderID) {
        if (Log.doActionTrace()) {
            Log.trace((String)"TradeAction:orderCompleted", (Object)userID, (Object)orderID);
        }
        if (Log.doTrace()) {
            Log.trace((String)"OrderCompleted", (Object)userID, (Object)orderID);
        }
    }

    public Collection<OrderDataBean> getOrders(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:getOrders", (Object)userID);
        }
        AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        return account.getOrders();
    }

    public Collection<OrderDataBean> getClosedOrders(String userID) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:getClosedOrders", (Object)userID);
        }
        try {
            Query query = this.entityManager.createNamedQuery("orderejb.closedOrders");
            query.setParameter("userID", (Object)userID);
            List results = query.getResultList();
            for (OrderDataBeanImpl thisOrder : results) {
                thisOrder.getQuote();
            }
            if (TradeConfig.jpaLayer == 0) {
                Query updateStatus = this.entityManager.createNamedQuery("orderejb.completeClosedOrders");
                updateStatus.setParameter("userID", (Object)userID);
                updateStatus.executeUpdate();
            } else if (TradeConfig.jpaLayer == 1) {
                Query findaccountid = this.entityManager.createNativeQuery("select a.ACCOUNTID, a.LOGINCOUNT, a.LOGOUTCOUNT, a.LASTLOGIN, a.CREATIONDATE, a.BALANCE, a.OPENBALANCE, a.PROFILE_USERID from accountejb a where a.profile_userid = ?", AccountDataBeanImpl.class);
                findaccountid.setParameter(1, (Object)userID);
                AccountDataBeanImpl account = (AccountDataBeanImpl)findaccountid.getSingleResult();
                Integer accountid = account.getAccountID();
                Query updateStatus = this.entityManager.createNativeQuery("UPDATE orderejb o SET o.orderStatus = 'completed' WHERE o.orderStatus = 'closed' AND o.ACCOUNT_ACCOUNTID  = ?");
                updateStatus.setParameter(1, (Object)accountid);
                updateStatus.executeUpdate();
            }
            return results;
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaCm.getClosedOrders", (Throwable)e);
            throw new RuntimeException("TradeJpaCm.getClosedOrders - error", e);
        }
    }

    public QuoteDataBean createQuote(String symbol, String companyName, BigDecimal price) throws Exception {
        try {
            QuoteDataBeanImpl quote = new QuoteDataBeanImpl(symbol, companyName, 0.0, price, price, price, price, 0.0);
            this.entityManager.persist((Object)quote);
            if (Log.doTrace()) {
                Log.trace((String)("TradeJpaCm:createQuote-->" + quote));
            }
            return quote;
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaCm:createQuote -- exception creating Quote", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public QuoteDataBean getQuote(String symbol) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:getQuote", (Object)symbol);
        }
        QuoteDataBeanImpl qdb = (QuoteDataBeanImpl)this.entityManager.find(QuoteDataBeanImpl.class, (Object)symbol);
        return qdb;
    }

    public Collection<QuoteDataBean> getAllQuotes() {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:getAllQuotes");
        }
        Query query = this.entityManager.createNamedQuery("quoteejb.allQuotes");
        return query.getResultList();
    }

    public QuoteDataBean updateQuotePriceVolume(String symbol, BigDecimal changeFactor, double sharesTraded) throws Exception {
        if (!TradeConfig.getUpdateQuotePrices()) {
            return new QuoteDataBeanImpl();
        }
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:updateQuote", (Object)symbol, (Object)changeFactor);
        }
        QuoteDataBeanImpl quote = null;
        if (TradeConfig.jpaLayer == 1) {
            quote = (QuoteDataBeanImpl)this.entityManager.find(QuoteDataBeanImpl.class, (Object)symbol);
        } else if (TradeConfig.jpaLayer == 0) {
            Query q = this.entityManager.createNamedQuery("quoteejb.quoteForUpdate");
            q.setParameter(1, (Object)symbol);
            quote = (QuoteDataBeanImpl)q.getSingleResult();
        }
        BigDecimal oldPrice = quote.getPrice();
        if (quote.getPrice().equals(TradeConfig.PENNY_STOCK_PRICE)) {
            changeFactor = TradeConfig.PENNY_STOCK_RECOVERY_MIRACLE_MULTIPLIER;
        }
        BigDecimal newPrice = changeFactor.multiply(oldPrice).setScale(2, 4);
        quote.setPrice(newPrice);
        quote.setVolume(quote.getVolume() + sharesTraded);
        quote.setChange(newPrice.subtract(quote.getOpen()).doubleValue());
        if (newPrice.compareTo(quote.getHigh()) == 1) {
            quote.setHigh(newPrice);
        } else if (newPrice.compareTo(quote.getLow()) == -1) {
            quote.setLow(newPrice);
        }
        this.entityManager.merge((Object)quote);
        this.publishQuotePriceChange((QuoteDataBean)quote, oldPrice, changeFactor, sharesTraded);
        return quote;
    }

    public Collection<HoldingDataBean> getHoldings(String userID) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:getHoldings", (Object)userID);
        }
        List holdings = null;
        Query query = this.entityManager.createNamedQuery("holdingejb.holdingsByUserID");
        query.setParameter("userID", (Object)userID);
        holdings = query.getResultList();
        Iterator itr = holdings.iterator();
        while (itr.hasNext()) {
            ((HoldingDataBean)itr.next()).getQuote();
        }
        return holdings;
    }

    public HoldingDataBean getHolding(Integer holdingID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:getHolding", (Object)holdingID);
        }
        return (HoldingDataBean)this.entityManager.find(HoldingDataBeanImpl.class, (Object)holdingID);
    }

    public AccountDataBean getAccountData(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:getAccountData", (Object)userID);
        }
        AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        account.getProfile();
        account.setProfileID(profile.getUserID());
        return account;
    }

    public AccountProfileDataBean getAccountProfileData(String userID) {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:getProfileData", (Object)userID);
        }
        AccountProfileDataBeanImpl apb = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        return apb;
    }

    public AccountProfileDataBean updateAccountProfile(String userID, String password, String fullName, String address, String email, String creditcard) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:updateAccountProfileData", (Object)userID);
        }
        AccountProfileDataBeanImpl temp = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        temp.setAddress(address);
        temp.setPassword(password);
        temp.setFullName(fullName);
        temp.setCreditCard(creditcard);
        temp.setEmail(email);
        this.entityManager.merge((Object)temp);
        return temp;
    }

    public AccountDataBean login(String userID, String password) throws Exception {
        AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        if (profile == null) {
            throw new RuntimeException("No such user: " + userID);
        }
        this.entityManager.merge((Object)profile);
        AccountDataBean account = profile.getAccount();
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:login", (Object)userID, (Object)password);
        }
        account.login(password);
        if (Log.doTrace()) {
            Log.trace((String)("TradeJpaCm:login(" + userID + "," + password + ") success" + account));
        }
        return account;
    }

    public void logout(String userID) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:logout", (Object)userID);
        }
        AccountProfileDataBeanImpl profile = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        account.logout();
        if (Log.doTrace()) {
            Log.trace((String)("TradeJpaCm:logout(" + userID + ") success"));
        }
    }

    public AccountDataBean register(String userID, String password, String fullname, String address, String email, String creditcard, BigDecimal openBalance) throws Exception {
        AccountDataBeanImpl account = null;
        AccountProfileDataBeanImpl profile = null;
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:register", (Object)userID, (Object)password, (Object)fullname, (Object)address, (Object)email, (Object)creditcard, (Object)openBalance);
        }
        if ((profile = (AccountProfileDataBeanImpl)this.entityManager.find(AccountProfileDataBeanImpl.class, (Object)userID)) != null) {
            Log.error((String)("Failed to register new Account - AccountProfile with userID(" + userID + ") already exists"));
            return null;
        }
        profile = new AccountProfileDataBeanImpl(userID, password, fullname, address, email, creditcard);
        account = new AccountDataBeanImpl(0, 0, null, (Date)new Timestamp(System.currentTimeMillis()), openBalance, openBalance, userID);
        profile.setAccount((AccountDataBean)account);
        account.setProfile((AccountProfileDataBean)profile);
        this.entityManager.persist((Object)profile);
        this.entityManager.persist((Object)account);
        return account;
    }

    private void publishQuotePriceChange(QuoteDataBean quote, BigDecimal oldPrice, BigDecimal changeFactor, double sharesTraded) {
        if (!TradeConfig.getPublishQuotePriceChange()) {
            return;
        }
        Log.error((String)"TradeJpaCm:publishQuotePriceChange - is not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJpaCm:publishQuotePriceChange - is not implemented for this runtime mode");
    }

    private OrderDataBean createOrder(AccountDataBean account, QuoteDataBean quote, HoldingDataBean holding, String orderType, double quantity) {
        OrderDataBeanImpl order;
        if (Log.doTrace()) {
            Log.trace((String)("TradeJpaCm:createOrder(orderID= account=" + (account == null ? null : account.getAccountID()) + " quote=" + (quote == null ? null : quote.getSymbol()) + " orderType=" + orderType + " quantity=" + quantity));
        }
        try {
            order = new OrderDataBeanImpl(orderType, "open", (Date)new Timestamp(System.currentTimeMillis()), null, quantity, quote.getPrice().setScale(2, 4), TradeConfig.getOrderFee((String)orderType), account, quote, holding);
            this.entityManager.persist((Object)order);
        }
        catch (Exception e) {
            Log.error((String)"TradeJpaCm:createOrder -- failed to create Order", (Throwable)e);
            throw new RuntimeException("TradeJpaCm:createOrder -- failed to create Order", e);
        }
        return order;
    }

    private HoldingDataBean createHolding(AccountDataBean account, QuoteDataBean quote, double quantity, BigDecimal purchasePrice) throws Exception {
        HoldingDataBeanImpl newHolding = new HoldingDataBeanImpl(quantity, purchasePrice, (Date)new Timestamp(System.currentTimeMillis()), account, quote);
        this.entityManager.persist((Object)newHolding);
        return newHolding;
    }

    public double investmentReturn(double investment, double NetValue) throws Exception {
        if (Log.doTrace()) {
            Log.trace((String)"TradeJpaCm:investmentReturn");
        }
        double diff = NetValue - investment;
        double ir = diff / investment;
        return ir;
    }

    public QuoteDataBean pingTwoPhase(String symbol) throws Exception {
        Log.error((String)"TradeJpaCm:pingTwoPhase - is not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJpaCm:pingTwoPhase - is not implemented for this runtime mode");
    }

    public TradeConfig.ModeType getMode() {
        return TradeConfig.ModeType.JPA_CM;
    }

    class quotePriceComparator
    implements Comparator {
        quotePriceComparator() {
        }

        public int compare(Object quote1, Object quote2) {
            double change1 = ((QuoteDataBean)quote1).getChange();
            double change2 = ((QuoteDataBean)quote2).getChange();
            return new Double(change2).compareTo(change1);
        }
    }
}

