/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.web;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.aries.samples.ariestrader.api.TradeServiceUtilities;
import org.apache.aries.samples.ariestrader.api.TradeServices;
import org.apache.aries.samples.ariestrader.api.TradeServicesManager;
import org.apache.aries.samples.ariestrader.util.Log;

public class OrdersAlertFilter
implements Filter {
    private static TradeServicesManager tradeServicesManager = null;
    private FilterConfig filterConfig = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (this.filterConfig == null) {
            return;
        }
        if (tradeServicesManager == null) {
            tradeServicesManager = TradeServiceUtilities.getTradeServicesManager();
        }
        TradeServices tradeServices = tradeServicesManager.getTradeServices();
        try {
            String userID;
            String action = req.getParameter("action");
            if (action != null && (action = action.trim()).length() > 0 && !action.equals("logout") && (userID = action.equals("login") ? req.getParameter("uid") : (String)((HttpServletRequest)req).getSession().getAttribute("uidBean")) != null && userID.trim().length() > 0) {
                Collection closedOrders = tradeServices.getClosedOrders(userID);
                if (closedOrders != null && closedOrders.size() > 0) {
                    req.setAttribute("closedOrders", (Object)closedOrders);
                }
                if (Log.doTrace()) {
                    Log.printCollection((String)("OrdersAlertFilter: userID=" + userID + " closedOrders="), (Collection)closedOrders);
                }
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"OrdersAlertFilter - Error checking for closedOrders");
        }
        ServletContext sc = this.filterConfig.getServletContext();
        chain.doFilter(req, resp);
    }

    public void destroy() {
        this.filterConfig = null;
    }
}

