/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.aries.samples.ariestrader.api.persistence.HoldingDataBean;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.util.TradeConfig;

public class TradeScenarioServlet
extends HttpServlet {
    private static final String tasPathPrefix = "/app?action=";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String parm = (String)en.nextElement();
            String value = config.getInitParameter(parm);
            TradeConfig.setConfigParam((String)parm, (String)value);
        }
    }

    public String getServletInfo() {
        return "TradeScenarioServlet emulates a population of web users";
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performTask(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performTask(request, response);
    }

    public void performTask(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int action = 32;
        String userID = null;
        String dispPath = null;
        String scenarioAction = req.getParameter("action");
        if (scenarioAction != null && scenarioAction.length() >= 1 && (action = (int)scenarioAction.charAt(0)) == 110) {
            try {
                resp.setContentType("text/html");
                PrintWriter out = new PrintWriter((OutputStream)resp.getOutputStream());
                out.println("<HTML><HEAD>TradeScenarioServlet</HEAD><BODY>Hello</BODY></HTML>");
                out.close();
                return;
            }
            catch (Exception e) {
                Log.error((String)"trade_client.TradeScenarioServlet.service(...)error creating printwriter from responce.getOutputStream", (Throwable)e);
                resp.sendError(500, "trade_client.TradeScenarioServlet.service(...): erorr creating and writing to PrintStream created from response.getOutputStream()");
            }
        }
        ServletContext ctx = null;
        HttpSession session = null;
        try {
            ctx = this.getServletConfig().getServletContext();
            session = req.getSession(true);
            userID = (String)session.getAttribute("uidBean");
        }
        catch (Exception e) {
            Log.error((String)("trade_client.TradeScenarioServlet.service(...): performing " + scenarioAction + "error getting ServletContext,HttpSession, or UserID from session" + "will make scenarioAction a login and try to recover from there"), (Throwable)e);
            userID = null;
            action = 108;
        }
        if (userID == null) {
            action = 108;
            TradeConfig.incrementScenarioCount();
        } else if (action == 32) {
            action = TradeConfig.getScenarioAction((boolean)userID.startsWith("ru:"));
        }
        switch (action) {
            case 113: {
                dispPath = "/app?action=quotes&symbols=" + TradeConfig.rndSymbols();
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                break;
            }
            case 97: {
                dispPath = "/app?action=account";
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                break;
            }
            case 117: {
                dispPath = "/app?action=account";
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                String fullName = "rnd" + System.currentTimeMillis();
                String address = "rndAddress";
                String password = "xxx";
                String email = "rndEmail";
                String creditcard = "rndCC";
                dispPath = "/app?action=update_profile&fullname=" + fullName + "&password=" + password + "&cpassword=" + password + "&address=" + address + "&email=" + email + "&creditcard=" + creditcard;
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                break;
            }
            case 104: {
                dispPath = "/app?action=home";
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                break;
            }
            case 108: {
                userID = TradeConfig.getUserID();
                String password2 = "xxx";
                dispPath = "/app?action=login&inScenario=true&uid=" + userID + "&passwd=" + password2;
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                if (session.getAttribute("uidBean") != null) break;
                System.out.println("TradeScenario login failed. Reset DB between runs");
                break;
            }
            case 111: {
                dispPath = "/app?action=logout";
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                break;
            }
            case 112: {
                dispPath = "/app?action=portfolio";
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                break;
            }
            case 114: {
                req.setAttribute("TSS-RecreateSessionInLogout", (Object)Boolean.TRUE);
                dispPath = "/app?action=logout";
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                userID = TradeConfig.rndNewUserID();
                String passwd = "yyy";
                String fullName = TradeConfig.rndFullName();
                String creditcard = TradeConfig.rndCreditCard();
                String money = TradeConfig.rndBalance();
                String email = TradeConfig.rndEmail((String)userID);
                String smail = TradeConfig.rndAddress();
                dispPath = "/app?action=register&Full Name=" + fullName + "&snail mail=" + smail + "&email=" + email + "&user id=" + userID + "&passwd=" + passwd + "&confirm passwd=" + passwd + "&money=" + money + "&Credit Card Number=" + creditcard;
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                break;
            }
            case 115: {
                dispPath = "/app?action=portfolioNoEdge";
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                Collection holdings = (Collection)req.getAttribute("holdingDataBeans");
                int numHoldings = holdings.size();
                if (numHoldings > 0) {
                    Iterator it = holdings.iterator();
                    boolean foundHoldingToSell = false;
                    while (it.hasNext()) {
                        HoldingDataBean holdingData = (HoldingDataBean)it.next();
                        if (holdingData.getPurchaseDate().equals(new Date(0L))) continue;
                        Integer holdingID = holdingData.getHoldingID();
                        dispPath = "/app?action=sell&holdingID=" + holdingID;
                        ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                        foundHoldingToSell = true;
                        break;
                    }
                    if (foundHoldingToSell) break;
                    if (Log.doTrace()) {
                        Log.trace((String)("TradeScenario: No holding to sell -switch to buy -- userID = " + userID + "  Collection count = " + numHoldings));
                    }
                }
                if (!userID.startsWith("ru:")) {
                    TradeConfig.incrementSellDeficit();
                }
            }
            case 98: {
                String symbol = TradeConfig.rndSymbol();
                String amount = TradeConfig.rndQuantity() + "";
                dispPath = "/app?action=quotes&symbols=" + symbol;
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
                dispPath = "/app?action=buy&quantity=" + amount + "&symbol=" + symbol;
                ctx.getRequestDispatcher(dispPath).include((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }
}

