/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.ariestrader.web.prims;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.aries.samples.ariestrader.util.Log;
import org.apache.aries.samples.ariestrader.web.prims.PingSession3Object;

public class PingSession3
extends HttpServlet {
    private static int NUM_OBJECTS = 2;
    private static String initTime = null;
    private static int hitCount = 0;

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        StringBuffer outputBuffer = new StringBuffer();
        HttpSession session = null;
        response.setContentType("text/html");
        try {
            try {
                session = request.getSession(true);
            }
            catch (Exception e) {
                Log.error((Throwable)e, (String)"PingSession3.doGet(...): error getting session");
                throw e;
            }
            String num_objects = request.getParameter("num_objects");
            if (num_objects != null) {
                try {
                    int x = Integer.parseInt(num_objects);
                    if (x > 0) {
                        NUM_OBJECTS = x;
                    }
                }
                catch (Exception e) {
                    Log.error((Throwable)e, (String)("PingSession3.doGet(...): input should be an integer, input=" + num_objects));
                }
                outputBuffer.append("<html><head> Session object size set to " + NUM_OBJECTS + "K bytes </head><body></body></html>");
                if (session != null) {
                    session.invalidate();
                }
                out.print(outputBuffer.toString());
                out.close();
                return;
            }
            PingSession3Object[] sessionData = (PingSession3Object[])session.getAttribute("sessiontest.sessionData");
            if (sessionData == null) {
                sessionData = new PingSession3Object[NUM_OBJECTS];
                for (int i = 0; i < NUM_OBJECTS; ++i) {
                    sessionData[i] = new PingSession3Object();
                }
            }
            session.setAttribute("sessiontest.sessionData", (Object)sessionData);
            int num_bytes = NUM_OBJECTS * 1024 / 8;
            response.setHeader("SessionTrackingTest-largeSessionData", num_bytes + "bytes");
            outputBuffer.append("<html><head><title>Session Large Data Test</title></head><body><HR><BR><FONT size=\"+2\" color=\"#000066\">HTTP Session Test 3: Large Data<BR></FONT><FONT size=\"+1\" color=\"#000066\">Init time: ").append(initTime).append("</FONT><BR><BR>");
            outputBuffer.append("<B>Hit Count: ").append(++hitCount).append("<BR>Session object updated. Session Object size = " + num_bytes + " bytes </B></body></html>");
            out.println(outputBuffer.toString());
        }
        catch (Exception e) {
            Log.error((Throwable)e, (String)"PingSession3.doGet(..l.): error.");
            response.sendError(500, "PingSession3.doGet(...): error. " + e.toString());
        }
    }

    public String getServletInfo() {
        return "HTTP Session Object: Tests management of a large custom session class";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        hitCount = 0;
        initTime = new Date().toString();
    }
}

