/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.biz;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.aries.samples.blog.api.BlogAuthor;
import org.apache.aries.samples.blog.api.BlogAuthorManager;
import org.apache.aries.samples.blog.api.BlogComment;
import org.apache.aries.samples.blog.api.BlogCommentManager;
import org.apache.aries.samples.blog.api.BlogEntry;
import org.apache.aries.samples.blog.api.BlogEntryManager;
import org.apache.aries.samples.blog.api.BloggingService;
import org.apache.aries.samples.blog.biz.BlogImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BloggingServiceImpl
implements BloggingService {
    private BlogEntryManager blogEntryManager;
    private BlogAuthorManager blogAuthorManager;
    private BlogCommentManager blogCommentManager;

    public void setBlogEntryManager(BlogEntryManager blogPostManager) {
        this.blogEntryManager = blogPostManager;
    }

    public void setBlogAuthorManager(BlogAuthorManager authorManager) {
        this.blogAuthorManager = authorManager;
    }

    public void setBlogCommentManager(BlogCommentManager commentManager) {
        this.blogCommentManager = commentManager;
    }

    public String getBlogTitle() {
        return new BlogImpl().getBlogTitle();
    }

    public BlogAuthor getBlogAuthor(String email) {
        return this.blogAuthorManager.getAuthor(email);
    }

    public void createBlogAuthor(String email, String nickName, String name, String bio, String dob) {
        try {
            this.blogAuthorManager.createAuthor(email, dob, name, nickName, bio);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void updateBlogAuthor(String email, String nickName, String name, String bio, String dob) {
        try {
            this.blogAuthorManager.updateAuthor(email, dob, name, nickName, bio);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public BlogEntry getPost(long id) {
        return this.blogEntryManager.getBlogPost(id);
    }

    public List<? extends BlogEntry> getBlogEntries(int firstPostIndex, int noOfPosts) {
        return this.blogEntryManager.getBlogEntries(firstPostIndex, noOfPosts);
    }

    public List<? extends BlogEntry> getAllBlogEntries() {
        return this.blogEntryManager.getAllBlogEntries();
    }

    public int getNoOfEntries() {
        return this.blogEntryManager.getNoOfPosts();
    }

    public void createBlogEntry(String email, String title, String blogText, String tags) {
        this.blogEntryManager.createBlogPost(email, title, blogText, Arrays.asList(tags.split(",")));
    }

    public void createBlogComment(String comment, String authorEmail, long id) {
        if (this.blogCommentManager != null) {
            this.blogCommentManager.createComment(comment, authorEmail, id);
        }
    }

    public void deleteBlogComment(BlogComment comment) {
        if (this.blogCommentManager != null) {
            this.blogCommentManager.deleteComment(comment.getId());
        }
    }

    public List<? extends BlogComment> getCommentsForEntry(BlogEntry entry) {
        if (this.blogCommentManager != null) {
            return this.blogCommentManager.getCommentsForPost(entry.getId());
        }
        return Collections.emptyList();
    }

    public BlogEntry getBlogEntry(long id) {
        return this.blogEntryManager.getBlogPost(id);
    }

    public boolean isCommentingAvailable() {
        if (this.blogCommentManager != null) {
            return this.blogCommentManager.isCommentingAvailable();
        }
        return false;
    }
}

