/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.persistence.jpa;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.aries.samples.blog.api.persistence.BlogPersistenceService;
import org.apache.aries.samples.blog.api.persistence.Entry;
import org.apache.aries.samples.blog.persistence.jpa.entity.AuthorImpl;
import org.apache.aries.samples.blog.persistence.jpa.entity.EntryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogPersistenceServiceImpl
implements BlogPersistenceService {
    private EntityManager em;

    public void setEntityManager(EntityManager e) {
        this.em = e;
    }

    public void createAuthor(String email, Date dob, String name, String displayName, String bio) {
        AuthorImpl a = new AuthorImpl();
        a.setEmail(email);
        a.setName(name);
        a.setDisplayName(displayName);
        a.setBio(bio);
        a.setDob(dob);
        this.em.persist((Object)a);
    }

    public void createBlogPost(String authorEmail, String title, String blogText, List<String> tags) {
        AuthorImpl a = (AuthorImpl)this.em.find(AuthorImpl.class, (Object)authorEmail);
        EntryImpl b = new EntryImpl();
        Date publishDate = new Date(System.currentTimeMillis());
        b.setBlogText(blogText);
        b.setAuthor(a);
        b.setTitle(title == null ? "" : title);
        b.setPublishDate(publishDate);
        b.setTags(tags == null ? new ArrayList() : tags);
        a.updateEntries(b);
        this.em.persist((Object)b);
        this.em.merge((Object)b.getAuthor());
    }

    public Entry findBlogEntryByTitle(String title) {
        Query q = this.em.createQuery("SELECT e FROM BLOGENTRY e WHERE e.title = ?1");
        q.setParameter(1, (Object)title);
        Entry b = (Entry)q.getSingleResult();
        return b;
    }

    public List<AuthorImpl> getAllAuthors() {
        List list = this.em.createQuery("SELECT a FROM AUTHOR a").getResultList();
        return list;
    }

    public List<EntryImpl> getAllBlogEntries() {
        List list = this.em.createQuery("SELECT b FROM BLOGENTRY b ORDER BY b.publishDate DESC").getResultList();
        return list;
    }

    public int getNoOfBlogEntries() {
        Number n = (Number)this.em.createQuery("SELECT COUNT(b) FROM BLOGENTRY b").getSingleResult();
        return n.intValue();
    }

    public List<EntryImpl> getBlogEntries(int firstPostIndex, int noOfPosts) {
        Query q = this.em.createQuery("SELECT b FROM BLOGENTRY b ORDER BY b.publishDate DESC");
        q.setFirstResult(firstPostIndex);
        q.setMaxResults(noOfPosts);
        List list = q.getResultList();
        return list;
    }

    public AuthorImpl getAuthor(String emailAddress) {
        AuthorImpl a = (AuthorImpl)this.em.find(AuthorImpl.class, (Object)emailAddress);
        return a;
    }

    public List<EntryImpl> getBlogEntriesModifiedBetween(Date start, Date end) {
        Query q = this.em.createQuery("SELECT b FROM BLOGENTRY b WHERE (b.updatedDate >= :start AND b.updatedDate <= :end) OR (b.publishDate >= :start AND b.publishDate <= :end) ORDER BY b.publishDate ASC");
        q.setParameter("start", (Object)start);
        q.setParameter("end", (Object)end);
        List list = q.getResultList();
        return list;
    }

    public List<EntryImpl> getBlogsForAuthor(String emailAddress) {
        List<EntryImpl> list = ((AuthorImpl)this.em.find(AuthorImpl.class, (Object)emailAddress)).getEntries();
        return list;
    }

    public void updateAuthor(String email, Date dob, String name, String displayName, String bio) {
        AuthorImpl a = (AuthorImpl)this.em.find(AuthorImpl.class, (Object)email);
        a.setEmail(email);
        a.setName(name);
        a.setDisplayName(displayName);
        a.setBio(bio);
        a.setDob(dob);
        this.em.merge((Object)a);
    }

    public void updateBlogEntry(long id, String email, String title, String blogText, List<String> tags, Date updatedDate) {
        EntryImpl b = (EntryImpl)this.em.find(EntryImpl.class, (Object)id);
        b.setTitle(title);
        b.setBlogText(blogText);
        b.setTags(tags);
        b.setUpdatedDate(updatedDate);
        this.em.merge((Object)b);
    }

    public void removeAuthor(String emailAddress) {
        this.em.remove(this.em.find(AuthorImpl.class, (Object)emailAddress));
    }

    public void removeBlogEntry(long id) {
        EntryImpl b = (EntryImpl)this.em.find(EntryImpl.class, (Object)id);
        b = (EntryImpl)this.em.merge((Object)b);
        b.getAuthor().getEntries().remove(b);
        this.em.remove(this.em.merge((Object)b));
        this.em.merge((Object)b.getAuthor());
    }

    public EntryImpl getBlogEntryById(long postId) {
        EntryImpl b = (EntryImpl)this.em.find(EntryImpl.class, (Object)postId);
        return b;
    }

    public void setPublishDate(long postId, Date date) {
        EntryImpl b = (EntryImpl)this.em.find(EntryImpl.class, (Object)postId);
        b.setPublishDate(date);
        this.em.merge((Object)b);
    }

    public void setUpdatedDate(long postId, Date date) {
        EntryImpl b = (EntryImpl)this.em.find(EntryImpl.class, (Object)postId);
        b.setUpdatedDate(date);
        this.em.merge((Object)b);
    }
}

