/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.web;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.aries.samples.blog.api.BloggingService;
import org.apache.aries.samples.blog.web.util.FormServlet;
import org.apache.aries.samples.blog.web.util.FormatChecker;
import org.apache.aries.samples.blog.web.util.JNDIHelper;

public class EditAuthor
extends HttpServlet {
    private static final long serialVersionUID = -8881545878284864977L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String email = req.getParameter("email");
        String nickName = req.getParameter("nickName");
        String name = req.getParameter("name");
        String bio = req.getParameter("bio");
        String dob = req.getParameter("dob");
        if (email == null || email.equals("")) {
            this.storeParam(req, "email", email);
            this.storeParam(req, "nickName", nickName);
            this.storeParam(req, "name", name);
            this.storeParam(req, "bio", bio);
            this.storeParam(req, "dob", dob);
            FormServlet.addError((HttpServletRequest)req, (String)"The email field is required.");
            resp.sendRedirect("EditAuthorForm");
        } else if (!FormatChecker.isValidEmail((String)email)) {
            this.storeParam(req, "email", email);
            this.storeParam(req, "nickName", nickName);
            this.storeParam(req, "name", name);
            this.storeParam(req, "bio", bio);
            this.storeParam(req, "dob", dob);
            FormServlet.addError((HttpServletRequest)req, (String)"The email field is not properly formatted");
            resp.sendRedirect("EditAuthorForm");
        } else {
            BloggingService service = JNDIHelper.getBloggingService();
            if (service.getBlogAuthor(email) != null) {
                service.updateBlogAuthor(email, nickName, name, bio, dob);
            } else {
                service.createBlogAuthor(email, nickName, name, bio, dob);
            }
            RequestDispatcher dispatch = this.getServletContext().getRequestDispatcher("/ViewAuthor");
            dispatch.forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void storeParam(HttpServletRequest req, String param, String value) {
        FormServlet.storeParam((HttpServletRequest)req, (String)"author", (String)param, (String)value);
    }
}

