/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.aries.samples.blog.api.BlogComment;
import org.apache.aries.samples.blog.api.BlogEntry;
import org.apache.aries.samples.blog.api.BloggingService;
import org.apache.aries.samples.blog.web.util.HTMLOutput;
import org.apache.aries.samples.blog.web.util.JNDIHelper;

public class ViewBlog
extends HttpServlet {
    private static final long serialVersionUID = -1854915218416871420L;
    private static final int POSTS_PER_PAGE = 10;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter out = resp.getWriter();
        BloggingService service = JNDIHelper.getBloggingService();
        String blogTitle = service.getBlogTitle();
        HTMLOutput.writeHTMLHeaderPartOne((PrintWriter)out, (String)blogTitle);
        HTMLOutput.writeDojoUses((PrintWriter)out, (String[])new String[]{"dojo.parser"});
        HTMLOutput.writeHTMLHeaderPartTwo((PrintWriter)out);
        int maxPage = (service.getNoOfEntries() - 1) / 10;
        int pageNoInt = 0;
        String pageNo = req.getParameter("page");
        if (pageNo != null) {
            try {
                pageNoInt = Integer.parseInt(pageNo) - 1;
                if (pageNoInt > maxPage) {
                    pageNoInt = maxPage;
                } else if (pageNoInt < 0) {
                    pageNoInt = 0;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        Iterator posts = service.getBlogEntries(pageNoInt * 10, 10).iterator();
        out.println("<div class=\"links\"><a href=\"CreateBlogEntryForm\">Create New Post</a> <a href=\"EditAuthorForm\">Create Author</a></div>");
        Date currentDate = null;
        int i = 0;
        while (posts.hasNext()) {
            BlogEntry post = (BlogEntry)posts.next();
            if (this.doesNotMatch(post.getPublishDate(), currentDate)) {
                currentDate = post.getPublishDate();
                out.print("<div class=\"postDate\">");
                if (currentDate != null) {
                    out.print(DateFormat.getDateInstance(0).format(currentDate));
                }
                out.println("</div>");
            }
            out.print("\t\t<div class=\"post\" id=\"");
            out.print(i);
            out.println("\">");
            out.print("\t\t\t<div class=\"postTitle\">");
            out.print(post.getTitle());
            out.print("</div>");
            out.print("\t\t\t<div class=\"postBody\">");
            out.print(post.getBody());
            out.println("</div>");
            out.print("\t\t\t<div class=\"postAuthor\"><a href=\"ViewAuthor?email=");
            out.print(post.getAuthorEmail());
            out.print("\">");
            out.print(post.getAuthor().getFullName());
            out.println("</a></div>");
            if (service.isCommentingAvailable()) {
                out.print("<div class=\"links\"><a href=\"AddCommentForm?postId=");
                out.print(post.getId());
                out.print("\">Add Comment</a></div>");
                List comments = service.getCommentsForEntry(post);
                int size = comments.size();
                out.print("<div class=\"commentTitle\"");
                if (size > 0) {
                    out.print("onclick=\"expand(");
                    out.print(post.getId());
                    out.print(")\"");
                }
                out.print(" style=\"cursor: pointer;\">Comments (");
                out.print(size);
                out.println(")</div>");
                if (size > 0) {
                    out.print("<div id=\"comments");
                    out.print(post.getId());
                    out.println("\">");
                    for (BlogComment comment : comments) {
                        out.println("<div class=\"comment\">");
                        out.println(comment.getComment());
                        out.println("</div>");
                        out.print("\t\t\t<div class=\"commentAuthor\"><a href=\"ViewAuthor?email=");
                        out.print(comment.getAuthor().getEmailAddress());
                        out.print("\">");
                        out.print(comment.getAuthor().getName());
                        out.println("</a></div>");
                    }
                    out.println("</div>");
                }
            }
            out.println("\t\t</div>");
            ++i;
        }
        this.writePager(out, pageNoInt + 1, maxPage + 1);
        HTMLOutput.writeHTMLFooter((PrintWriter)out);
    }

    private void writePager(PrintWriter out, int currentPage, int maxPage) {
        if (maxPage > 1) {
            out.println("<div id=\"pagination\">");
            if (currentPage > 1) {
                out.println("<a href=\"ViewBlog?page=1\">&lt;&lt;</a>");
                out.println("<a href=\"ViewBlog?page=" + (currentPage - 1) + "\">&lt;</a>");
            } else {
                out.println("<span>&lt;&lt;</span>");
                out.println("<span>&lt;</span>");
            }
            out.println(currentPage + " of " + maxPage);
            if (currentPage < maxPage) {
                out.println("<a href=\"ViewBlog?page=" + (currentPage + 1) + "\">&gt;</a>");
                out.println("<a href=\"ViewBlog?page=" + maxPage + "\">&gt;&gt;</a>");
            } else {
                out.println("<span>&gt;&gt;</span>");
                out.println("<span>&gt;</span>");
            }
            out.println("</div>");
        }
    }

    private boolean doesNotMatch(Date publishDate, Date currentDate) {
        if (currentDate == null) {
            return true;
        }
        Calendar publish = Calendar.getInstance();
        Calendar current = Calendar.getInstance();
        publish.setTime(publishDate);
        current.setTime(currentDate);
        boolean differentYear = publish.get(1) != current.get(1);
        boolean differentMonth = publish.get(2) != current.get(2);
        boolean differentDayOfMonth = publish.get(5) != current.get(5);
        return differentYear || differentMonth || differentDayOfMonth;
    }
}

