/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blueprint.idverifier.client;

import java.util.HashSet;
import java.util.Set;
import org.apache.aries.samples.blueprint.idverifier.client.CreditRecord;
import org.apache.aries.samples.blueprint.idverifier.client.PersonCreditRecords;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditRecordStore {
    private Set<String> personidindex;
    private Set<PersonCreditRecords> personrecords;

    public CreditRecordStore(Set<CreditRecord> records) {
        this.init(records);
    }

    void init(Set<CreditRecord> records) {
        this.personidindex = new HashSet<String>();
        this.personrecords = new HashSet<PersonCreditRecords>();
        for (CreditRecord arecord : records) {
            this.personidindex.add(arecord.getPersonid());
        }
        for (String personid : this.personidindex) {
            this.personrecords.add(new PersonCreditRecords(personid));
        }
        for (CreditRecord arecord : records) {
            PersonCreditRecords target = this.getAPersonRecords(arecord.getPersonid());
            if (target == null) continue;
            target.add(arecord);
        }
    }

    public synchronized boolean add(CreditRecord arecord) {
        boolean b = false;
        PersonCreditRecords target = this.getAPersonRecords(arecord.getPersonid());
        if (target != null) {
            b = target.add(arecord);
        } else {
            PersonCreditRecords apersonrecords = new PersonCreditRecords(arecord.getPersonid());
            apersonrecords.add(arecord);
            this.personrecords.add(apersonrecords);
            this.personidindex.add(arecord.getPersonid());
            b = true;
        }
        return b;
    }

    public synchronized boolean remove(CreditRecord arecord) {
        boolean b = false;
        if (this.personidindex.contains(arecord.getPersonid())) {
            PersonCreditRecords target = this.getAPersonRecords(arecord.getPersonid());
            b = target.remove(arecord);
            if (target.isEmpty()) {
                this.personidindex.remove(arecord.getPersonid());
                this.personrecords.remove(target);
            }
        }
        return b;
    }

    public PersonCreditRecords getAPersonRecords(String personid) {
        PersonCreditRecords result = null;
        for (PersonCreditRecords arecord : this.personrecords) {
            if (!arecord.getPersonid().equals(personid)) continue;
            result = arecord;
            break;
        }
        return result;
    }

    public Set<String> getPersonidindex() {
        return this.personidindex;
    }

    public Set<PersonCreditRecords> getPersonrecords() {
        return this.personrecords;
    }
}

