/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blueprint.idverifier.client;

import org.apache.aries.samples.blueprint.idverifier.api.PersonIDVerifier;
import org.apache.aries.samples.blueprint.idverifier.client.PersonalInfo;
import org.apache.aries.samples.blueprint.idverifier.client.RandomIDChoice;
import org.osgi.service.blueprint.container.Converter;
import org.osgi.service.blueprint.container.ReifiedType;

public class IDConverter
implements Converter {
    private PersonIDVerifier verifier;
    private String personid;

    public boolean canConvert(Object sourceObject, ReifiedType targetType) {
        boolean canorcannot = false;
        String id = null;
        if (targetType.getRawClass() == PersonalInfo.class) {
            if (sourceObject instanceof RandomIDChoice) {
                id = ((RandomIDChoice)sourceObject).getRandomID();
                this.setPersonid(id);
            }
            if (this.getPersonid() == null || this.getPersonid().length() != 18) {
                return false;
            }
            this.verifier.setId(this.getPersonid());
            canorcannot = this.verifier.verify();
        }
        return canorcannot;
    }

    public Object convert(Object sourceObject, ReifiedType targetType) throws Exception {
        return new PersonalInfo(this.getPersonid(), this.verifier.getArea(), this.verifier.getBirthday(), this.verifier.getGender());
    }

    public PersonIDVerifier getVerifier() {
        return this.verifier;
    }

    public void setVerifier(PersonIDVerifier verifier) {
        this.verifier = verifier;
    }

    public String getPersonid() {
        return this.personid;
    }

    public void setPersonid(String personid) {
        this.personid = personid;
    }
}

