/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blueprint.idverifier.client;

import java.util.HashSet;
import java.util.Set;
import org.apache.aries.samples.blueprint.idverifier.client.CreditRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonCreditRecords {
    private String personid;
    private Set<String> recordNOs;
    private Set<CreditRecord> records;

    public PersonCreditRecords(String personid) {
        this.personid = personid;
        this.recordNOs = new HashSet<String>();
        this.records = new HashSet<CreditRecord>();
    }

    public boolean add(CreditRecord arecord) {
        boolean b = false;
        if (arecord.getPersonid().equals(this.personid) && !this.recordNOs.contains(arecord.getRecordNO())) {
            this.recordNOs.add(arecord.getRecordNO());
            b = this.records.add(arecord);
        }
        return b;
    }

    public boolean remove(CreditRecord arecord) {
        boolean b = false;
        if (arecord.getPersonid().equals(this.personid) && this.recordNOs.contains(arecord.getRecordNO())) {
            this.recordNOs.remove(arecord.getRecordNO());
            b = this.records.remove(this.getARecord(arecord.getRecordNO()));
        }
        return b;
    }

    private CreditRecord getARecord(String recordNO) {
        CreditRecord target = null;
        for (CreditRecord arecord : this.getRecords()) {
            if (!arecord.getRecordNO().equals(recordNO)) continue;
            target = arecord;
            break;
        }
        return target;
    }

    public boolean isEmpty() {
        boolean b = false;
        b = this.recordNOs.isEmpty() && this.records.isEmpty();
        return b;
    }

    public String getPersonid() {
        return this.personid;
    }

    public Set<String> getRecordNOs() {
        return this.recordNOs;
    }

    public Set<CreditRecord> getRecords() {
        return this.records;
    }
}

