/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blueprint.idverifier.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.aries.samples.blueprint.idverifier.api.PersonIDVerifier;
import org.apache.aries.samples.blueprint.idverifier.server.PersonIDVerifierSimpleImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonIDVerifierComplexImpl
extends PersonIDVerifierSimpleImpl
implements PersonIDVerifier {
    private String datepattern;
    private Map<String, String> definedAreacode;
    private int[] coefficient;

    @Override
    public boolean verify() {
        boolean b = false;
        b = super.isValidID() && super.isValidSuffix() && this.isValidBirth() && this.isValidArea() && this.isValidCheckCode();
        return b;
    }

    @Override
    boolean isValidBirth() {
        String birthdate = this.toDateFormat(this.getBirthcode(), "-");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date birthday = sdf.parse(birthdate);
            SimpleDateFormat sdf_usecustom = new SimpleDateFormat(this.datepattern);
            this.setBirth_str(sdf_usecustom.format(birthday));
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    boolean isValidArea() {
        boolean b = false;
        if (super.isValidArea() && this.definedAreacode.containsValue(this.getAreacode())) {
            b = true;
            Set<String> keys = this.definedAreacode.keySet();
            for (String key : keys) {
                String value = this.definedAreacode.get(key);
                if (!value.equals(this.getAreacode())) continue;
                super.setArea_str(key);
                break;
            }
        }
        return b;
    }

    public boolean isValidCheckCode() {
        boolean b = false;
        int[] codes = this.Char2Number(this.id.substring(0, 17));
        String[] validcheckcodes = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += codes[i] * this.coefficient[i];
        }
        int remain = sum % 11;
        String checkcode = this.id.substring(17);
        b = validcheckcodes[remain].equals(checkcode);
        return b;
    }

    private int[] Char2Number(String id) {
        int[] numbers = new int[17];
        for (int i = 0; i < 17; ++i) {
            numbers[i] = Integer.parseInt(new Character(id.charAt(i)).toString());
        }
        return numbers;
    }

    public String getDatepattern() {
        return this.datepattern;
    }

    public void setDatepattern(String datepattern) {
        this.datepattern = datepattern;
    }

    public Map<String, String> getDefinedAreacode() {
        return this.definedAreacode;
    }

    public void setDefinedAreacode(Map<String, String> definedAreacode) {
        this.definedAreacode = definedAreacode;
    }

    public int[] getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(int[] coefficient) {
        this.coefficient = coefficient;
    }
}

