/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blueprint.idverifier.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.samples.blueprint.idverifier.api.PersonIDVerifier;

public class PersonIDVerifierSimpleImpl
implements PersonIDVerifier {
    String areacode;
    String birthcode;
    String suffixcode;
    String id;
    String area_str;
    String birth_str;
    String gender_str;
    static final String GENDER_MAN = "man";
    static final String GENDER_WOMAN = "woman";

    public String getArea_str() {
        return this.area_str;
    }

    public void setArea_str(String areaStr) {
        this.area_str = areaStr;
    }

    public String getBirth_str() {
        return this.birth_str;
    }

    public void setBirth_str(String birthStr) {
        this.birth_str = birthStr;
    }

    public String getGender_str() {
        return this.gender_str;
    }

    public void setGender_str(String genderStr) {
        this.gender_str = genderStr;
    }

    public String getAreacode() {
        return this.areacode;
    }

    public void setAreacode(String areacode) {
        this.areacode = areacode;
    }

    public String getBirthcode() {
        return this.birthcode;
    }

    public void setBirthcode(String birthcode) {
        this.birthcode = birthcode;
    }

    public String getSuffixcode() {
        return this.suffixcode;
    }

    public void setSuffixcode(String suffixcode) {
        this.suffixcode = suffixcode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getArea() {
        return this.getArea_str();
    }

    public String getBirthday() {
        return this.getBirth_str();
    }

    public String getGender() {
        return this.getGender_str();
    }

    public boolean verify() {
        boolean b = false;
        b = this.isValidID() && this.isValidArea() && this.isValidBirth() && this.isValidSuffix();
        return b;
    }

    boolean isValidID() {
        boolean b = false;
        if (this.id.length() == 18) {
            b = true;
            this.setAreacode(this.id.substring(0, 6));
            this.setBirthcode(this.id.substring(6, 14));
            this.setSuffixcode(this.id.substring(14));
        }
        return b;
    }

    boolean isValidArea() {
        boolean b = false;
        Pattern p = Pattern.compile("\\d{6}");
        Matcher m = p.matcher(this.getAreacode());
        if (m.matches()) {
            this.setArea_str(this.getAreacode());
            b = true;
        }
        return b;
    }

    boolean isValidBirth() {
        String birthdate = this.toDateFormat(this.getBirthcode(), "-");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            this.setBirth_str(sdf.format(sdf.parse(birthdate)));
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean isValidSuffix() {
        boolean b = false;
        Pattern p = Pattern.compile("\\d{3}[\\dX]");
        Matcher m = p.matcher(this.getSuffixcode());
        if (m.matches()) {
            b = true;
            this.setGender(this.getSuffixcode());
        }
        return b;
    }

    String toDateFormat(String s, String delimiter) {
        StringBuffer sb = new StringBuffer();
        sb.append(s.substring(0, 4));
        sb.append(delimiter);
        sb.append(s.substring(4, 6));
        sb.append(delimiter);
        sb.append(s.substring(6));
        return sb.toString();
    }

    private void setGender(String s) {
        int gender = Integer.parseInt(new Character(s.charAt(2)).toString());
        int remain = gender % 2;
        if (remain == 0) {
            this.setGender_str(GENDER_WOMAN);
        } else {
            this.setGender_str(GENDER_MAN);
        }
    }
}

