/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Date;
import twitter4j.Configuration;
import twitter4j.Dispatcher;
import twitter4j.Paging;
import twitter4j.Query;
import twitter4j.Twitter;
import twitter4j.TwitterAdapter;
import twitter4j.TwitterException;
import twitter4j.TwitterListener;

public class AsyncTwitter
extends Twitter {
    private static final long serialVersionUID = -2008667933225051907L;
    private static transient Dispatcher dispatcher;
    private boolean shutdown = false;
    public static final int PUBLIC_TIMELINE = 0;
    public static final int FRIENDS_TIMELINE = 1;
    public static final int USER_TIMELINE = 2;
    public static final int SHOW = 3;
    public static final int SHOW_STATUS = 38;
    public static final int UPDATE = 4;
    public static final int UPDATE_STATUS = 39;
    public static final int REPLIES = 5;
    public static final int MENTIONS = 37;
    public static final int FRIENDS = 6;
    public static final int FOLLOWERS = 7;
    public static final int FEATURED = 8;
    public static final int USER_DETAIL = 9;
    public static final int DIRECT_MESSAGES = 10;
    public static final int DESTROY_DIRECT_MESSAGES = 40;
    public static final int SEND_DIRECT_MESSAGE = 11;
    public static final int CREATE = 12;
    public static final int CREATE_FRIENDSHIP = 32;
    public static final int DESTORY = 13;
    public static final int DESTROY = 13;
    public static final int DESTROY_FRIENDSHIP = 33;
    public static final int EXISTS = 28;
    public static final int EXISTS_FRIENDSHIP = 34;
    public static final int FOLLOW = 14;
    public static final int ENABLE_NOTIFICATION = 35;
    public static final int LEAVE = 15;
    public static final int DISABLE_NOTIFICATION = 36;
    public static final int FAVORITES = 17;
    public static final int FRIENDS_IDS = 29;
    public static final int FOLLOWERS_IDS = 30;
    public static final int CREATE_FAVORITE = 18;
    public static final int DESTROY_FAVORITE = 19;
    public static final int UPDATE_LOCATION = 20;
    public static final int UPDATE_PROFILE = 41;
    public static final int UPDATE_PROFILE_COLORS = 31;
    public static final int RATE_LIMIT_STATUS = 28;
    public static final int UPDATE_DELIVERLY_DEVICE = 21;
    public static final int BLOCK = 22;
    public static final int CREATED_BLOCK = 43;
    public static final int UNBLOCK = 23;
    public static final int DESTROYED_BLOCK = 42;
    private static final int EXISTS_BLOCK = 48;
    private static final int GET_BLOCKING_USERS = 49;
    private static final int GET_BLOCKING_USERS_IDS = 50;
    public static final int TEST = 24;
    public static final int GET_DOWNTIME_SCHEDULE = 25;
    public static final int DESTROY_STATUS = 26;
    public static final int SEARCH = 27;
    public static final int TRENDS = 44;
    public static final int CURRENT_TRENDS = 45;
    public static final int DAILY_TRENDS = 46;
    public static final int WEEKLY_TRENDS = 47;

    public AsyncTwitter(String id, String password) {
        super(id, password);
    }

    public AsyncTwitter(String id, String password, String baseURL) {
        super(id, password, baseURL);
    }

    public void searchAcync(Query query, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(27, listener, new Object[]{query}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.searched(AsyncTwitter.this.search((Query)args[0]));
            }
        });
    }

    public void getTrendsAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(44, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotTrends(AsyncTwitter.this.getTrends());
            }
        });
    }

    public void getCurrentTrendsAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(45, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotCurrentTrends(AsyncTwitter.this.getCurrentTrends());
            }
        });
    }

    public void getCurrentTrendsAsync(boolean excludeHashTags, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(45, listener, new Object[]{new Boolean(excludeHashTags)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotCurrentTrends(AsyncTwitter.this.getCurrentTrends((Boolean)args[0]));
            }
        });
    }

    public void getDailyTrendsAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(46, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDailyTrends(AsyncTwitter.this.getDailyTrends());
            }
        });
    }

    public void getDailyTrendsAsync(Date date, boolean excludeHashTags, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(46, listener, new Object[]{date, new Boolean(excludeHashTags)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDailyTrends(AsyncTwitter.this.getDailyTrends((Date)args[0], (Boolean)args[1]));
            }
        });
    }

    public void getWeeklyTrendsAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(47, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotWeeklyTrends(AsyncTwitter.this.getWeeklyTrends());
            }
        });
    }

    public void getWeeklyTrendsAsync(Date date, boolean excludeHashTags, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(47, listener, new Object[]{date, new Boolean(excludeHashTags)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotWeeklyTrends(AsyncTwitter.this.getWeeklyTrends((Date)args[0], (Boolean)args[1]));
            }
        });
    }

    public void getPublicTimelineAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(0, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotPublicTimeline(AsyncTwitter.this.getPublicTimeline());
            }
        });
    }

    public void getPublicTimelineAsync(int sinceID, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(0, listener, new Integer[]{new Integer(sinceID)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotPublicTimeline(AsyncTwitter.this.getPublicTimeline((Integer)args[0]));
            }
        });
    }

    public void getFriendsTimelineAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.getFriendsTimeline());
            }
        });
    }

    public void getFriendsTimelineAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.getFriendsTimeline((Paging)args[0]));
            }
        });
    }

    public void getFriendsTimelineByPageAsync(int page, TwitterListener listener) {
        this.getFriendsTimelineAsync(new Paging(page), listener);
    }

    public void getFriendsTimelineAsync(int page, TwitterListener listener) {
        this.getFriendsTimelineAsync(new Paging(page), listener);
    }

    public void getFriendsTimelineAsync(long sinceId, int page, TwitterListener listener) {
        this.getFriendsTimelineAsync(new Paging(page, sinceId), listener);
    }

    public void getFriendsTimelineAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.getFriendsTimeline((String)args[0]));
            }
        });
    }

    public void getFriendsTimelineAsync(String id, Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, listener, new Object[]{id, paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.getFriendsTimeline((String)args[0], (Paging)args[1]));
            }
        });
    }

    public void getFriendsTimelineByPageAsync(String id, int page, TwitterListener listener) {
        this.getFriendsTimelineAsync(id, new Paging(page), listener);
    }

    public void getFriendsTimelineAsync(String id, int page, TwitterListener listener) {
        this.getFriendsTimelineAsync(id, new Paging(page), listener);
    }

    public void getFriendsTimelineAsync(long sinceId, String id, int page, TwitterListener listener) {
        this.getFriendsTimelineAsync(id, new Paging(page, sinceId), listener);
    }

    public void getFriendsTimelineAsync(Date since, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, listener, new Object[]{since}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.getFriendsTimeline((Date)args[0]));
            }
        });
    }

    public void getFriendsTimelineAsync(long sinceId, TwitterListener listener) {
        this.getFriendsTimelineAsync(new Paging(sinceId), listener);
    }

    public void getFriendsTimelineAsync(String id, Date since, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(1, listener, new Object[]{id, since}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.getFriendsTimeline((String)args[0], (Date)args[1]));
            }
        });
    }

    public void getFriendsTimelineAsync(String id, long sinceId, TwitterListener listener) {
        this.getFriendsTimelineAsync(id, new Paging(sinceId), listener);
    }

    public void getUserTimelineAsync(String id, int count, Date since, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, listener, new Object[]{id, new Integer(count), since}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.getUserTimeline((String)args[0], (int)((Integer)args[1]), (Date)args[2]));
            }
        });
    }

    public void getUserTimelineAsync(String id, Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, listener, new Object[]{id, paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.getUserTimeline((String)args[0], (Paging)args[1]));
            }
        });
    }

    public void getUserTimelineAsync(String id, int page, long sinceId, TwitterListener listener) {
        this.getUserTimelineAsync(id, new Paging(page, sinceId), listener);
    }

    public void getUserTimelineAsync(String id, Date since, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, listener, new Object[]{id, since}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.getUserTimeline((String)args[0], (Date)args[1]));
            }
        });
    }

    public void getUserTimelineAsync(String id, int count, TwitterListener listener) {
        this.getUserTimelineAsync(id, new Paging().count(count), listener);
    }

    public void getUserTimelineAsync(int count, Date since, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, listener, new Object[]{new Integer(count), since}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.getUserTimeline((int)((Integer)args[0]), (Date)args[1]));
            }
        });
    }

    public void getUserTimelineAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.getUserTimeline((Paging)args[0]));
            }
        });
    }

    public void getUserTimelineAsync(int count, long sinceId, TwitterListener listener) {
        this.getUserTimelineAsync(new Paging(sinceId).count(count), listener);
    }

    public void getUserTimelineAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, listener, new Object[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.getUserTimeline((String)args[0]));
            }
        });
    }

    public void getUserTimelineAsync(String id, long sinceId, TwitterListener listener) {
        this.getUserTimelineAsync(id, new Paging(sinceId), listener);
    }

    public void getUserTimelineAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(2, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.getUserTimeline());
            }
        });
    }

    public void getUserTimelineAsync(long sinceId, TwitterListener listener) {
        this.getUserTimelineAsync(new Paging(sinceId), listener);
    }

    public void getRepliesAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(5, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotReplies(AsyncTwitter.this.getReplies());
            }
        });
    }

    public void getMentionsAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(37, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotMentions(AsyncTwitter.this.getMentions());
            }
        });
    }

    public void getMentionsAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(37, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotMentions(AsyncTwitter.this.getMentions((Paging)args[0]));
            }
        });
    }

    public void getRepliesAsync(long sinceId, TwitterListener listener) {
        this.getMentionsAsync(new Paging(sinceId), listener);
    }

    public void getRepliesByPageAsync(int page, TwitterListener listener) {
        this.getMentionsAsync(new Paging(page), listener);
    }

    public void getRepliesAsync(int page, TwitterListener listener) {
        this.getMentionsAsync(new Paging(page), listener);
    }

    public void getRepliesAsync(long sinceId, int page, TwitterListener listener) {
        this.getMentionsAsync(new Paging(page, sinceId), listener);
    }

    public void showAsync(int id, TwitterListener listener) {
        this.showAsync((long)id, listener);
    }

    public void showAsync(long id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(3, listener, new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotShow(AsyncTwitter.this.show((Long)args[0]));
            }
        });
    }

    public void showStatusAsync(long id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(38, listener, new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotShowStatus(AsyncTwitter.this.showStatus((Long)args[0]));
            }
        });
    }

    public void updateAsync(String status, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(4, listener, new String[]{status}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updated(AsyncTwitter.this.update((String)args[0]));
            }
        });
    }

    public void updateAsync(String status) {
        this.getDispatcher().invokeLater(new AsyncTask(4, new TwitterAdapter(), new String[]{status}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updated(AsyncTwitter.this.update((String)args[0]));
            }
        });
    }

    public void updateStatusAsync(String status, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(39, listener, new String[]{status}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.updateStatus((String)args[0]));
            }
        });
    }

    public void updateStatusAsync(String status) {
        this.getDispatcher().invokeLater(new AsyncTask(39, new TwitterAdapter(), new String[]{status}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.updateStatus((String)args[0]));
            }
        });
    }

    public void updateAsync(String status, long inReplyToStatusId, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(4, listener, new Object[]{status, new Long(inReplyToStatusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updated(AsyncTwitter.this.update((String)args[0], (Long)args[1]));
            }
        });
    }

    public void updateAsync(String status, long inReplyToStatusId) {
        this.getDispatcher().invokeLater(new AsyncTask(4, new TwitterAdapter(), new Object[]{status, new Long(inReplyToStatusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updated(AsyncTwitter.this.update((String)args[0], (Long)args[1]));
            }
        });
    }

    public void updateStatusAsync(String status, long inReplyToStatusId, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(39, listener, new Object[]{status, new Long(inReplyToStatusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.updateStatus((String)args[0], (Long)args[1]));
            }
        });
    }

    public void updateStatusAsync(String status, long inReplyToStatusId) {
        this.getDispatcher().invokeLater(new AsyncTask(39, new TwitterAdapter(), new Object[]{status, new Long(inReplyToStatusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.updateStatus((String)args[0], (Long)args[1]));
            }
        });
    }

    public void destoryStatusAsync(int statusId) {
        this.destroyStatusAsync((long)statusId);
    }

    public void destroyStatusAsync(int statusId) {
        this.destroyStatusAsync((long)statusId);
    }

    public void destroyStatusAsync(long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(26, new TwitterAdapter(), new Long[]{new Long(statusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedStatus(AsyncTwitter.this.destroyStatus((Long)args[0]));
            }
        });
    }

    public void destoryStatusAsync(int statusId, TwitterListener listener) {
        this.destroyStatusAsync((long)statusId, listener);
    }

    public void destroyStatusAsync(int statusId, TwitterListener listener) {
        this.destroyStatusAsync((long)statusId, listener);
    }

    public void destroyStatusAsync(long statusId, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(26, listener, new Long[]{new Long(statusId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedStatus(AsyncTwitter.this.destroyStatus((Long)args[0]));
            }
        });
    }

    public void getUserDetailAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(9, listener, new Object[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotUserDetail(AsyncTwitter.this.getUserDetail((String)args[0]));
            }
        });
    }

    public void getFriendsAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(6, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriends(AsyncTwitter.this.getFriends());
            }
        });
    }

    public void getFriendsAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(6, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriends(AsyncTwitter.this.getFriends((Paging)args[0]));
            }
        });
    }

    public void getFriendsAsync(int page, TwitterListener listener) {
        this.getFriendsTimelineAsync(new Paging(page), listener);
    }

    public void getFriendsAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(6, listener, new Object[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriends(AsyncTwitter.this.getFriends((String)args[0]));
            }
        });
    }

    public void getFriendsAsync(String id, Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(6, listener, new Object[]{id, paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriends(AsyncTwitter.this.getFriends((String)args[0], (Paging)args[1]));
            }
        });
    }

    public void getFriendsAsync(String id, int page, TwitterListener listener) {
        this.getFriendsAsync(id, new Paging(page), listener);
    }

    public void getFollowersAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(7, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowers(AsyncTwitter.this.getFollowers());
            }
        });
    }

    public void getFollowersAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(7, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowers(AsyncTwitter.this.getFollowers((Paging)args[0]));
            }
        });
    }

    public void getFollowersAsync(int page, TwitterListener listener) {
        this.getFollowersAsync(new Paging(page), listener);
    }

    public void getFollowersAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(7, listener, new Object[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowers(AsyncTwitter.this.getFollowers((String)args[0]));
            }
        });
    }

    public void getFollowersAsync(String id, Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(7, listener, new Object[]{id, paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowers(AsyncTwitter.this.getFollowers((String)args[0], (Paging)args[1]));
            }
        });
    }

    public void getFollowersAsync(String id, int page, TwitterListener listener) {
        this.getFollowersAsync(id, new Paging(page), listener);
    }

    public void getFeaturedAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(8, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFeatured(AsyncTwitter.this.getFeatured());
            }
        });
    }

    public void getDirectMessagesAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDirectMessages(AsyncTwitter.this.getDirectMessages());
            }
        });
    }

    public void getDirectMessagesAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDirectMessages(AsyncTwitter.this.getDirectMessages((Paging)args[0]));
            }
        });
    }

    public void getDirectMessagesByPageAsync(int page, TwitterListener listener) {
        this.getDirectMessagesAsync(new Paging(page), listener);
    }

    public void getDirectMessagesByPageAsync(int page, int sinceId, TwitterListener listener) {
        this.getDirectMessagesAsync(new Paging(page, (long)sinceId), listener);
    }

    public void getDirectMessagesAsync(int sinceId, TwitterListener listener) {
        this.getDirectMessagesAsync(new Paging((long)sinceId), listener);
    }

    public void getDirectMessagesAsync(Date since, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, listener, new Object[]{since}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotDirectMessages(AsyncTwitter.this.getDirectMessages((Date)args[0]));
            }
        });
    }

    public void getSentDirectMessagesAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotSentDirectMessages(AsyncTwitter.this.getSentDirectMessages());
            }
        });
    }

    public void getSentDirectMessagesAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotSentDirectMessages(AsyncTwitter.this.getSentDirectMessages((Paging)args[0]));
            }
        });
    }

    public void getSentDirectMessagesAsync(Date since, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(10, listener, new Object[]{since}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotSentDirectMessages(AsyncTwitter.this.getSentDirectMessages((Date)args[0]));
            }
        });
    }

    public void getSentDirectMessagesAsync(int sinceId, TwitterListener listener) {
        this.getSentDirectMessagesAsync(new Paging((long)sinceId), listener);
    }

    public void getSentDirectMessagesAsync(int page, int sinceId, TwitterListener listener) {
        this.getSentDirectMessagesAsync(new Paging(page, (long)sinceId), listener);
    }

    public void sendDirectMessageAsync(String id, String text, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(11, listener, new String[]{id, text}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.sentDirectMessage(AsyncTwitter.this.sendDirectMessage((String)args[0], (String)args[1]));
            }
        });
    }

    public void sendDirectMessageAsync(String id, String text) {
        this.getDispatcher().invokeLater(new AsyncTask(11, new TwitterAdapter(), new String[]{id, text}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.sentDirectMessage(AsyncTwitter.this.sendDirectMessage((String)args[0], (String)args[1]));
            }
        });
    }

    public void deleteDirectMessageAsync(int id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(40, listener, new Object[]{new Integer(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.deletedDirectMessage(AsyncTwitter.this.deleteDirectMessage((Integer)args[0]));
            }
        });
    }

    public void destroyDirectMessageAsync(int id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(40, listener, new Object[]{new Integer(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedDirectMessage(AsyncTwitter.this.destroyDirectMessage((Integer)args[0]));
            }
        });
    }

    public void destroyDirectMessageAsync(int id) {
        this.getDispatcher().invokeLater(new AsyncTask(40, new TwitterAdapter(), new Object[]{new Integer(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedDirectMessage(AsyncTwitter.this.destroyDirectMessage((Integer)args[0]));
            }
        });
    }

    public void createAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(12, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.created(AsyncTwitter.this.create((String)args[0]));
            }
        });
    }

    public void createFriendshipAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(32, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.createFriendship((String)args[0]));
            }
        });
    }

    public void createFriendshipAsync(String id, boolean follow, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(32, listener, new Object[]{id, new Boolean(follow)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.createFriendship((String)args[0], (Boolean)args[1]));
            }
        });
    }

    public void createAsync(String id) {
        this.getDispatcher().invokeLater(new AsyncTask(12, new TwitterAdapter(), new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.created(AsyncTwitter.this.create((String)args[0]));
            }
        });
    }

    public void createFriendshipAsync(String id) {
        this.createFriendshipAsync(id, new TwitterAdapter());
    }

    public void destroyAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(13, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyed(AsyncTwitter.this.destroy((String)args[0]));
            }
        });
    }

    public void destroyAsync(String id) {
        this.getDispatcher().invokeLater(new AsyncTask(13, new TwitterAdapter(), new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyed(AsyncTwitter.this.destroy((String)args[0]));
            }
        });
    }

    public void destroyFriendshipAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(33, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedFriendship(AsyncTwitter.this.destroyFriendship((String)args[0]));
            }
        });
    }

    public void destroyFriendshipAsync(String id) {
        this.destroyFriendshipAsync(id, new TwitterAdapter());
    }

    public void existsAsync(String userA, String userB, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(28, listener, new String[]{userA, userB}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotExists(AsyncTwitter.this.exists((String)args[0], (String)args[1]));
            }
        });
    }

    public void existsFriendshipAsync(String userA, String userB, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(34, listener, new String[]{userA, userB}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotExistsFriendship(AsyncTwitter.this.existsFriendship((String)args[0], (String)args[1]));
            }
        });
    }

    public void getFriendsIDsAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.getFriendsIDs());
            }
        });
    }

    public void getFriendsIDsAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.getFriendsIDs((Paging)args[0]));
            }
        });
    }

    public void getFriendsIDsAsync(int userId, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.getFriendsIDs((Integer)args[0]));
            }
        });
    }

    public void getFriendsIDsAsync(int userId, Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, listener, new Object[]{new Integer(userId), paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.getFriendsIDs((Integer)args[0], (Paging)args[1]));
            }
        });
    }

    public void getFriendsIDsAsync(String screenName, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.getFriendsIDs((String)args[0]));
            }
        });
    }

    public void getFriendsIDsAsync(String screenName, Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(29, listener, new Object[]{screenName, paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.getFriendsIDs((String)args[0], (Paging)args[1]));
            }
        });
    }

    public void getFollowersIDsAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.getFollowersIDs());
            }
        });
    }

    public void getFollowersIDsAsync(Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, listener, new Object[]{paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.getFollowersIDs((Paging)args[0]));
            }
        });
    }

    public void getFollowersIDsAsync(int userId, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, listener, new Integer[]{new Integer(userId)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.getFollowersIDs((Integer)args[0]));
            }
        });
    }

    public void getFollowersIDsAsync(int userId, Paging paging, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(30, listener, new Object[]{new Integer(userId), paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.getFollowersIDs((Integer)args[0], (Paging)args[1]));
            }
        });
    }

    public void getFollowersIDsAsync(String screenName, TwitterListener listener) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(30, listener, new String[]{screenName}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.getFollowersIDs((String)args[0]));
            }
        });
    }

    public void getFollowersIDsAsync(String screenName, Paging paging, TwitterListener listener) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(30, listener, new Object[]{screenName, paging}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.getFollowersIDs((String)args[0], (Paging)args[1]));
            }
        });
    }

    public void updateLocationAsync(String location, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(20, listener, new Object[]{location}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedLocation(AsyncTwitter.this.updateLocation((String)args[0]));
            }
        });
    }

    public void updateProfileAsync(String name, String email, String url, String location, String description, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(41, listener, new String[]{name, email, url, location, description}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedProfile(AsyncTwitter.this.updateProfile((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String)args[4]));
            }
        });
    }

    public void updateProfileAsync(String name, String email, String url, String location, String description) {
        this.updateProfileAsync(name, email, url, location, description, new TwitterAdapter());
    }

    public void rateLimitStatusAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(28, listener, new Object[0]){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotRateLimitStatus(AsyncTwitter.this.rateLimitStatus());
            }
        });
    }

    public void updateDeliverlyDeviceAsync(Twitter.Device device, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(20, listener, new Object[]{device}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedDeliverlyDevice(AsyncTwitter.this.updateDeliverlyDevice((Twitter.Device)args[0]));
            }
        });
    }

    public void updateProfileColorsAsync(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(31, listener, new Object[]{profileBackgroundColor, profileTextColor, profileLinkColor, profileSidebarFillColor, profileSidebarBorderColor}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.updatedProfileColors(AsyncTwitter.this.updateProfileColors((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String)args[4]));
            }
        });
    }

    public void updateProfileColorsAsync(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) {
        this.updateProfileColorsAsync(profileBackgroundColor, profileTextColor, profileLinkColor, profileSidebarFillColor, profileSidebarBorderColor, new TwitterAdapter());
    }

    public void favoritesAsync(TwitterListener listener) {
        this.getFavoritesAsync(listener);
    }

    public void getFavoritesAsync(TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.getFavorites());
            }
        });
    }

    public void favoritesAsync(int page, TwitterListener listener) {
        this.getFavoritesAsync(page, listener);
    }

    public void getFavoritesAsync(int page, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, listener, new Object[]{new Integer(page)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.getFavorites((Integer)args[0]));
            }
        });
    }

    public void favoritesAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, listener, new Object[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.favorites((String)args[0]));
            }
        });
    }

    public void getFavoritesAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, listener, new Object[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.getFavorites((String)args[0]));
            }
        });
    }

    public void favoritesAsync(String id, int page, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, listener, new Object[]{id, new Integer(page)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.favorites((String)args[0], (Integer)args[1]));
            }
        });
    }

    public void getFavoritesAsync(String id, int page, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, listener, new Object[]{id, new Integer(page)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.getFavorites((String)args[0], (Integer)args[1]));
            }
        });
    }

    public void createFavoriteAsync(int id, TwitterListener listener) {
        this.createFavoriteAsync((long)id, listener);
    }

    public void createFavoriteAsync(long id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, listener, new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFavorite(AsyncTwitter.this.createFavorite((Long)args[0]));
            }
        });
    }

    public void createFavoriteAsync(int id) {
        this.createFavoriteAsync((long)id);
    }

    public void createFavoriteAsync(long id) {
        this.getDispatcher().invokeLater(new AsyncTask(17, new TwitterAdapter(), new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdFavorite(AsyncTwitter.this.createFavorite((Long)args[0]));
            }
        });
    }

    public void destroyFavoriteAsync(int id, TwitterListener listener) {
        this.destroyFavoriteAsync((long)id, listener);
    }

    public void destroyFavoriteAsync(long id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(17, listener, new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedFavorite(AsyncTwitter.this.destroyFavorite((Long)args[0]));
            }
        });
    }

    public void destroyFavoriteAsync(int id) {
        this.destroyFavoriteAsync((long)id);
    }

    public void destroyFavoriteAsync(long id) {
        this.getDispatcher().invokeLater(new AsyncTask(17, new TwitterAdapter(), new Object[]{new Long(id)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedFavorite(AsyncTwitter.this.destroyFavorite((Long)args[0]));
            }
        });
    }

    public void followAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(14, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.followed(AsyncTwitter.this.follow((String)args[0]));
            }
        });
    }

    public void enableNotificationAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(35, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.enabledNotification(AsyncTwitter.this.enableNotification((String)args[0]));
            }
        });
    }

    public void followAsync(String id) {
        this.getDispatcher().invokeLater(new AsyncTask(14, new TwitterAdapter(), new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.followed(AsyncTwitter.this.follow((String)args[0]));
            }
        });
    }

    public void enableNotificationAsync(String id) {
        this.enableNotificationAsync(id, new TwitterAdapter());
    }

    public void leaveAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(15, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.left(AsyncTwitter.this.leave((String)args[0]));
            }
        });
    }

    public void disableNotificationAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(36, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.disabledNotification(AsyncTwitter.this.disableNotification((String)args[0]));
            }
        });
    }

    public void leaveAsync(String id) {
        this.getDispatcher().invokeLater(new AsyncTask(15, new TwitterAdapter(), new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.left(AsyncTwitter.this.leave((String)args[0]));
            }
        });
    }

    public void disableNotificationAsync(String id) {
        this.disableNotificationAsync(id, new TwitterAdapter());
    }

    public void blockAsync(String id) {
        this.getDispatcher().invokeLater(new AsyncTask(22, new TwitterAdapter(), new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.blocked(AsyncTwitter.this.block((String)args[0]));
            }
        });
    }

    public void createBlockAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(43, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.createdBlock(AsyncTwitter.this.createBlock((String)args[0]));
            }
        });
    }

    public void createBlockAsync(String id) {
        this.createBlockAsync(id, new TwitterAdapter());
    }

    public void unblockAsync(String id) {
        this.getDispatcher().invokeLater(new AsyncTask(23, new TwitterAdapter(), new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.unblocked(AsyncTwitter.this.unblock((String)args[0]));
            }
        });
    }

    public void destroyBlockAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(42, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.destroyedBlock(AsyncTwitter.this.destroyBlock((String)args[0]));
            }
        });
    }

    public void destroyBlockAsync(String id) {
        this.destroyBlockAsync(id, new TwitterAdapter());
    }

    public void existsBlockAsync(String id, TwitterListener listener) {
        this.getDispatcher().invokeLater(new AsyncTask(48, listener, new String[]{id}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotExistsBlock(AsyncTwitter.this.existsBlock((String)args[0]));
            }
        });
    }

    public void getBlockingUsersAsync(TwitterListener listener) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(49, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotBlockingUsers(AsyncTwitter.this.getBlockingUsers());
            }
        });
    }

    public void getBlockingUsersAsync(int page, TwitterListener listener) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(49, listener, new Integer[]{new Integer(page)}){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotBlockingUsers(AsyncTwitter.this.getBlockingUsers((Integer)args[0]));
            }
        });
    }

    public void getBlockingUsersIDsAsync(TwitterListener listener) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(50, listener, null){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.gotBlockingUsersIDs(AsyncTwitter.this.getBlockingUsersIDs());
            }
        });
    }

    public void testAsync() {
        this.getDispatcher().invokeLater(new AsyncTask(24, new TwitterAdapter(), new Object[0]){

            public void invoke(TwitterListener listener, Object[] args) throws TwitterException {
                listener.tested(AsyncTwitter.this.test());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class clazz = AsyncTwitter.class;
        synchronized (clazz) {
            this.shutdown = true;
            if (true) {
                throw new IllegalStateException("Already shut down");
            }
            this.getDispatcher().shutdown();
            dispatcher = null;
            this.shutdown = true;
        }
    }

    private Dispatcher getDispatcher() {
        if (this.shutdown) {
            throw new IllegalStateException("Already shut down");
        }
        if (null == dispatcher) {
            dispatcher = new Dispatcher("Twitter4J Async Dispatcher", Configuration.getNumberOfAsyncThreads());
        }
        return dispatcher;
    }

    public void getDowntimeScheduleAsync() {
        throw new RuntimeException("this method is not supported by the Twitter API anymore", new NoSuchMethodException("this method is not supported by the Twitter API anymore"));
    }

    public void getAuthenticatedUserAsync(TwitterListener listener) {
        if (null == this.getUserId()) {
            throw new IllegalStateException("User Id not specified.");
        }
        this.getUserDetailAsync(this.getUserId(), listener);
    }

    abstract class AsyncTask
    implements Runnable {
        TwitterListener listener;
        Object[] args;
        int method;

        AsyncTask(int method, TwitterListener listener, Object[] args) {
            this.method = method;
            this.listener = listener;
            this.args = args;
        }

        abstract void invoke(TwitterListener var1, Object[] var2) throws TwitterException;

        public void run() {
            block2: {
                try {
                    this.invoke(this.listener, this.args);
                }
                catch (TwitterException te) {
                    if (null == this.listener) break block2;
                    this.listener.onException(te, this.method);
                }
            }
        }
    }
}

