/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Properties;
import twitter4j.Version;

public class Configuration {
    private static Properties defaultProperty = new Properties();

    public static String getCilentVersion() {
        return Configuration.getProperty("twitter4j.clientVersion");
    }

    public static String getCilentVersion(String clientVersion) {
        return Configuration.getProperty("twitter4j.clientVersion", clientVersion);
    }

    public static String getSource() {
        return Configuration.getProperty("twitter4j.source");
    }

    public static String getSource(String source) {
        return Configuration.getProperty("twitter4j.source", source);
    }

    public static String getProxyHost() {
        return Configuration.getProperty("twitter4j.http.proxyHost");
    }

    public static String getProxyHost(String proxyHost) {
        return Configuration.getProperty("twitter4j.http.proxyHost", proxyHost);
    }

    public static String getProxyUser() {
        return Configuration.getProperty("twitter4j.http.proxyUser");
    }

    public static String getProxyUser(String user) {
        return Configuration.getProperty("twitter4j.http.proxyUser", user);
    }

    public static String getClientURL() {
        return Configuration.getProperty("twitter4j.clientURL");
    }

    public static String getClientURL(String clientURL) {
        return Configuration.getProperty("twitter4j.clientURL", clientURL);
    }

    public static String getProxyPassword() {
        return Configuration.getProperty("twitter4j.http.proxyPassword");
    }

    public static String getProxyPassword(String password) {
        return Configuration.getProperty("twitter4j.http.proxyPassword", password);
    }

    public static int getProxyPort() {
        return Configuration.getIntProperty("twitter4j.http.proxyPort");
    }

    public static int getProxyPort(int port) {
        return Configuration.getIntProperty("twitter4j.http.proxyPort", port);
    }

    public static int getConnectionTimeout() {
        return Configuration.getIntProperty("twitter4j.http.connectionTimeout");
    }

    public static int getConnectionTimeout(int connectionTimeout) {
        return Configuration.getIntProperty("twitter4j.http.connectionTimeout", connectionTimeout);
    }

    public static int getReadTimeout() {
        return Configuration.getIntProperty("twitter4j.http.readTimeout");
    }

    public static int getReadTimeout(int readTimeout) {
        return Configuration.getIntProperty("twitter4j.http.readTimeout", readTimeout);
    }

    public static int getRetryCount() {
        return Configuration.getIntProperty("twitter4j.http.retryCount");
    }

    public static int getRetryCount(int retryCount) {
        return Configuration.getIntProperty("twitter4j.http.retryCount", retryCount);
    }

    public static int getRetryIntervalSecs() {
        return Configuration.getIntProperty("twitter4j.http.retryIntervalSecs");
    }

    public static int getRetryIntervalSecs(int retryIntervalSecs) {
        return Configuration.getIntProperty("twitter4j.http.retryIntervalSecs", retryIntervalSecs);
    }

    public static String getUser() {
        return Configuration.getProperty("twitter4j.user");
    }

    public static String getUser(String userId) {
        return Configuration.getProperty("twitter4j.user", userId);
    }

    public static String getPassword() {
        return Configuration.getProperty("twitter4j.password");
    }

    public static String getPassword(String password) {
        return Configuration.getProperty("twitter4j.password", password);
    }

    public static String getUserAgent() {
        return Configuration.getProperty("twitter4j.http.userAgent");
    }

    public static String getUserAgent(String userAgent) {
        return Configuration.getProperty("twitter4j.http.userAgent", userAgent);
    }

    public static String getOAuthConsumerKey() {
        return Configuration.getProperty("twitter4j.oauth.consumerKey");
    }

    public static String getOAuthConsumerKey(String consumerKey) {
        return Configuration.getProperty("twitter4j.oauth.consumerKey", consumerKey);
    }

    public static String getOAuthConsumerSecret() {
        return Configuration.getProperty("twitter4j.oauth.consumerSecret");
    }

    public static String getOAuthConsumerSecret(String consumerSecret) {
        return Configuration.getProperty("twitter4j.oauth.consumerSecret", consumerSecret);
    }

    public static boolean getBoolean(String name) {
        String value = Configuration.getProperty(name);
        return Boolean.valueOf(value);
    }

    public static int getIntProperty(String name) {
        String value = Configuration.getProperty(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static int getIntProperty(String name, int fallbackValue) {
        String value = Configuration.getProperty(name, String.valueOf(fallbackValue));
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static long getLongProperty(String name) {
        String value = Configuration.getProperty(name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static String getProperty(String name) {
        return Configuration.getProperty(name, null);
    }

    public static String getProperty(String name, String fallbackValue) {
        String fallback;
        String value = System.getProperty(name, fallbackValue);
        if (null == value) {
            value = defaultProperty.getProperty(name);
        }
        if (null == value && null != (fallback = defaultProperty.getProperty(name + ".fallback"))) {
            value = System.getProperty(fallback);
        }
        return Configuration.replace(value);
    }

    private static String replace(String value) {
        String name;
        int closeBrace;
        if (null == value) {
            return value;
        }
        String newValue = value;
        int openBrace = 0;
        if (-1 != (openBrace = value.indexOf("{", openBrace)) && (closeBrace = value.indexOf("}", openBrace)) > openBrace + 1 && (name = value.substring(openBrace + 1, closeBrace)).length() > 0) {
            newValue = value.substring(0, openBrace) + Configuration.getProperty(name) + value.substring(closeBrace + 1);
        }
        if (newValue.equals(value)) {
            return value;
        }
        return Configuration.replace(newValue);
    }

    public static int getNumberOfAsyncThreads() {
        return Configuration.getIntProperty("twitter4j.async.numThreads");
    }

    public static boolean getDebug() {
        return Configuration.getBoolean("twitter4j.debug");
    }

    static {
        String defaultPropertiesPath = "/META-INF/twitter4j.properties";
        try {
            defaultProperty.load(Configuration.class.getResourceAsStream(defaultPropertiesPath));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Error while reading " + defaultPropertiesPath + ".");
        }
        defaultProperty.setProperty("twitter4j.clientVersion", Version.getVersion());
    }
}

