/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Arrays;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.http.Response;

public class IDs
extends TwitterResponse {
    private int[] ids;
    private static final long serialVersionUID = -6585026560164704953L;

    IDs(Response res) throws TwitterException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        IDs.ensureRootNodeNameIs("ids", elem);
        NodeList idlist = elem.getElementsByTagName("id");
        this.ids = new int[idlist.getLength()];
        for (int i = 0; i < idlist.getLength(); ++i) {
            try {
                this.ids[i] = Integer.parseInt(idlist.item(i).getFirstChild().getNodeValue());
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new TwitterException("Twitter API returned malformed response: " + elem, nfe);
            }
        }
    }

    public int[] getIDs() {
        return this.ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)o;
        return Arrays.equals(this.ids, iDs.ids);
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDs{ids=" + (this.ids == null ? null : Arrays.asList(new int[][]{this.ids})) + '}';
    }
}

