/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.manifest;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;

public class ManifestProcessor {
    public static Map<String, String> readManifestIntoMap(Manifest mf) {
        Set<Map.Entry<Object, Object>> attributeSet;
        HashMap<String, String> props = new HashMap<String, String>();
        Attributes mainAttrs = mf.getMainAttributes();
        if (mainAttrs != null && (attributeSet = mainAttrs.entrySet()) != null) {
            for (Map.Entry<Object, Object> entry : attributeSet) {
                props.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        return props;
    }

    public static Manifest mapToManifest(Map<String, String> attributes) {
        Manifest man = new Manifest();
        Attributes att = man.getMainAttributes();
        att.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            att.putValue(entry.getKey(), entry.getValue());
        }
        return man;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest parseManifest(InputStream in) throws IOException {
        Manifest man = new Manifest();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            StringBuilder attribute = null;
            String namedAttribute = null;
            do {
                if ((line = reader.readLine()) != null && line.trim().length() == 0) continue;
                if (line != null && line.charAt(0) == ' ' && attribute != null) {
                    attribute.append(line.trim());
                    continue;
                }
                if (attribute == null) {
                    attribute = new StringBuilder(line.trim());
                    continue;
                }
                if (attribute == null) continue;
                int index = attribute.indexOf(":");
                String attributeName = attribute.substring(0, index).trim();
                String attributeValue = attribute.substring(index + 1).trim();
                if ("Name".equals(attributeName)) {
                    man.getEntries().put(attributeValue, new Attributes());
                    namedAttribute = attributeValue;
                } else {
                    Attributes.Name nameToAdd = new Attributes.Name(attributeName);
                    if (namedAttribute == null || !man.getMainAttributes().containsKey(nameToAdd)) {
                        man.getMainAttributes().put(nameToAdd, attributeValue);
                    } else {
                        man.getAttributes(namedAttribute).put(nameToAdd, attributeValue);
                    }
                }
                if (line == null) continue;
                attribute = new StringBuilder(line.trim());
            } while (line != null);
        }
        finally {
            IOUtils.close((Closeable)in);
        }
        return man;
    }

    public static Manifest obtainManifestFromAppDir(IDirectory appDir, String manifestName) throws IOException {
        IFile manifestFile = appDir.getFile(manifestName);
        Manifest man = null;
        if (manifestFile != null) {
            man = ManifestProcessor.parseManifest(manifestFile.open());
        }
        return man;
    }

    public static List<String> split(String value, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            String[] packages = value.split(delimiter);
            int i = 0;
            while (i < packages.length) {
                String tmp = packages[i++].trim();
                while (ManifestProcessor.count(tmp, "\"") % 2 == 1) {
                    tmp = tmp + delimiter + packages[i++].trim();
                }
                result.add(tmp);
            }
        }
        return result;
    }

    private static int count(String parent, String subString) {
        int count = 0;
        int i = parent.indexOf(subString);
        while (i > -1) {
            if (parent.length() >= i + 1) {
                parent = parent.substring(i + 1);
            }
            ++count;
            i = parent.indexOf(subString);
        }
        return count;
    }
}

