/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import org.apache.aries.subsystem.core.archive.AriesSubsystemParentsHeader;
import org.apache.aries.subsystem.core.archive.BundleSymbolicNameHeader;
import org.apache.aries.subsystem.core.archive.BundleVersionHeader;
import org.apache.aries.subsystem.core.archive.DeployedContentHeader;
import org.apache.aries.subsystem.core.archive.ExportPackageHeader;
import org.apache.aries.subsystem.core.archive.GenericHeader;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.ImportPackageHeader;
import org.apache.aries.subsystem.core.archive.PreferredProviderHeader;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityHeader;
import org.apache.aries.subsystem.core.archive.ProvisionResourceHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleHeader;
import org.apache.aries.subsystem.core.archive.RequireCapabilityHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemManifestVersionHeader;
import org.apache.aries.subsystem.core.archive.SubsystemSymbolicNameHeader;
import org.apache.aries.subsystem.core.archive.SubsystemTypeHeader;
import org.apache.aries.subsystem.core.archive.SubsystemVersionHeader;

public class HeaderFactory {
    public static Header<?> createHeader(String name, String value) {
        if (name.equals("Subsystem-SymbolicName")) {
            return new SubsystemSymbolicNameHeader(value);
        }
        if (name.equals("Subsystem-Version")) {
            return new SubsystemVersionHeader(value);
        }
        if (name.equals("Subsystem-Content")) {
            return new SubsystemContentHeader(value);
        }
        if (name.equals("Subsystem-Type")) {
            return new SubsystemTypeHeader(value);
        }
        if ("Export-Package".equals(name)) {
            return new ExportPackageHeader(value);
        }
        if ("Import-Package".equals(name)) {
            return new ImportPackageHeader(value);
        }
        if ("Deployed-Content".equals(name)) {
            return new DeployedContentHeader(value);
        }
        if ("Provision-Resource".equals(name)) {
            return new ProvisionResourceHeader(value);
        }
        if ("Subsystem-ManifestVersion".equals(name)) {
            return new SubsystemManifestVersionHeader(value);
        }
        if ("Require-Capability".equals(name)) {
            return new RequireCapabilityHeader(value);
        }
        if ("Subsystem-ImportService".equals(name)) {
            return new SubsystemImportServiceHeader(value);
        }
        if ("Require-Bundle".equals(name)) {
            return new RequireBundleHeader(value);
        }
        if ("Provide-Capability".equals(name)) {
            return new ProvideCapabilityHeader(value);
        }
        if ("Subsystem-ExportService".equals(name)) {
            return new SubsystemExportServiceHeader(value);
        }
        if ("Bundle-SymbolicName".equals(name)) {
            return new BundleSymbolicNameHeader(value);
        }
        if ("Bundle-Version".equals(name)) {
            return new BundleVersionHeader(value);
        }
        if ("Preferred-Provider".equals(name)) {
            return new PreferredProviderHeader(value);
        }
        if ("AriesSubsystem-Parents".equals(name)) {
            return new AriesSubsystemParentsHeader(value);
        }
        return new GenericHeader(name, value);
    }
}

