/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import org.apache.aries.subsystem.core.archive.AbstractDirective;

public class ResolutionDirective
extends AbstractDirective {
    public static final String NAME = "resolution";
    public static final String VALUE_MANDATORY = "mandatory";
    public static final String VALUE_OPTIONAL = "optional";
    public static final ResolutionDirective MANDATORY = new ResolutionDirective("mandatory");
    public static final ResolutionDirective OPTIONAL = new ResolutionDirective("optional");

    public ResolutionDirective() {
        this(VALUE_MANDATORY);
    }

    public static ResolutionDirective getInstance(String value) {
        if (VALUE_MANDATORY.equals(value)) {
            return MANDATORY;
        }
        if (VALUE_OPTIONAL.equals(value)) {
            return OPTIONAL;
        }
        throw new IllegalArgumentException("Invalid resolution directive: " + value);
    }

    private ResolutionDirective(String value) {
        super(NAME, value);
    }

    public boolean isMandatory() {
        return MANDATORY == this || VALUE_MANDATORY.equals(this.getValue());
    }

    public boolean isOptional() {
        return OPTIONAL == this || VALUE_OPTIONAL.equals(this.getValue());
    }
}

