/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.unittest.mocks;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodCall {
    private static Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private String _className;
    private Class<?>[] _interfaces = new Class[0];
    private String _methodName;
    private Object[] _arguments = EMPTY_OBJECT_ARRAY;
    private Object _invokedObject;
    private static Map<Class<?>, Comparator<?>> equalsHelpers = new HashMap();

    public MethodCall(Class<?> clazz, String methodName, Object ... arguments) {
        this._className = clazz.getName();
        this._methodName = methodName;
        this._arguments = arguments;
    }

    MethodCall(Object invokedObject, String methodName, Object ... arguments) {
        this._className = invokedObject.getClass().getName();
        this._interfaces = invokedObject.getClass().getInterfaces();
        this._methodName = methodName;
        this._arguments = arguments == null ? EMPTY_OBJECT_ARRAY : arguments;
        this._invokedObject = invokedObject;
    }

    public Object[] getArguments() {
        return this._arguments;
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    private boolean checkClassName(MethodCall one, MethodCall two) {
        int i;
        if (one._className.equals("java.lang.Object")) {
            return true;
        }
        if (two._className.equals("java.lang.Object")) {
            return true;
        }
        if (one._className.equals(two._className)) {
            return true;
        }
        boolean result = false;
        for (i = 0; i < two._interfaces.length; ++i) {
            if (!two._interfaces[i].getName().equals(one._className)) continue;
            result = true;
            break;
        }
        if (!result) {
            for (i = 0; i < one._interfaces.length; ++i) {
                if (!one._interfaces[i].getName().equals(two._className)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodCall) {
            MethodCall other = (MethodCall)obj;
            if (!this.checkClassName(this, other)) {
                return false;
            }
            if (!other._methodName.equals(this._methodName)) {
                return false;
            }
            if (other._arguments.length != this._arguments.length) {
                return false;
            }
            for (int i = 0; i < this._arguments.length; ++i) {
                boolean thisArgNull = this._arguments[i] == null;
                boolean otherArgClazz = other._arguments[i] instanceof Class;
                boolean otherArgNull = other._arguments[i] == null;
                boolean thisArgClazz = this._arguments[i] instanceof Class;
                if (thisArgNull) {
                    if (otherArgNull || otherArgClazz) continue;
                    return false;
                }
                if (otherArgNull) {
                    if (thisArgClazz) continue;
                    return false;
                }
                if (otherArgClazz) {
                    if (thisArgClazz) {
                        Class otherArgClass = (Class)other._arguments[i];
                        Class thisArgClass = (Class)this._arguments[i];
                        if (otherArgClass.equals(Class.class) || thisArgClass.equals(Class.class) || otherArgClass.isAssignableFrom(thisArgClass) || thisArgClass.isAssignableFrom(otherArgClass)) continue;
                        return false;
                    }
                    Class clazz = (Class)other._arguments[i];
                    if (clazz.isPrimitive()) {
                        if (clazz.equals(Byte.TYPE)) {
                            return this._arguments[i].getClass().equals(Byte.class);
                        }
                        if (clazz.equals(Boolean.TYPE)) {
                            return this._arguments[i].getClass().equals(Boolean.class);
                        }
                        if (clazz.equals(Short.TYPE)) {
                            return this._arguments[i].getClass().equals(Short.class);
                        }
                        if (clazz.equals(Character.TYPE)) {
                            return this._arguments[i].getClass().equals(Character.class);
                        }
                        if (clazz.equals(Integer.TYPE)) {
                            return this._arguments[i].getClass().equals(Integer.class);
                        }
                        if (clazz.equals(Long.TYPE)) {
                            return this._arguments[i].getClass().equals(Long.class);
                        }
                        if (clazz.equals(Float.TYPE)) {
                            return this._arguments[i].getClass().equals(Float.class);
                        }
                        if (!clazz.equals(Double.TYPE)) continue;
                        return this._arguments[i].getClass().equals(Double.class);
                    }
                    if (clazz.isInstance(this._arguments[i])) continue;
                    return false;
                }
                if (thisArgClazz) {
                    Class clazz = (Class)this._arguments[i];
                    if (clazz.isPrimitive()) {
                        if (clazz.equals(Byte.TYPE)) {
                            return other._arguments[i].getClass().equals(Byte.class);
                        }
                        if (clazz.equals(Boolean.TYPE)) {
                            return other._arguments[i].getClass().equals(Boolean.class);
                        }
                        if (clazz.equals(Short.TYPE)) {
                            return other._arguments[i].getClass().equals(Short.class);
                        }
                        if (clazz.equals(Character.TYPE)) {
                            return other._arguments[i].getClass().equals(Character.class);
                        }
                        if (clazz.equals(Integer.TYPE)) {
                            return other._arguments[i].getClass().equals(Integer.class);
                        }
                        if (clazz.equals(Long.TYPE)) {
                            return other._arguments[i].getClass().equals(Long.class);
                        }
                        if (clazz.equals(Float.TYPE)) {
                            return other._arguments[i].getClass().equals(Float.class);
                        }
                        if (!clazz.equals(Double.TYPE)) continue;
                        return other._arguments[i].getClass().equals(Double.class);
                    }
                    if (clazz.isInstance(other._arguments[i])) continue;
                    return false;
                }
                if (this._arguments[i] instanceof Object[] && other._arguments[i] instanceof Object[]) {
                    return this.equals((Object[])this._arguments[i], (Object[])other._arguments[i]);
                }
                int result = this.compareUsingComparators(this._arguments[i], other._arguments[i]);
                if (result == 0) continue;
                if (result == 1) {
                    return false;
                }
                if (this._arguments[i].equals(other._arguments[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean equals(Object[] arr1, Object[] arr2) {
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int k = 0; k < arr1.length; ++k) {
            if (arr1[k] == arr2[k]) continue;
            if (arr1[k] == null && arr2[k] != null) {
                return false;
            }
            if (arr1[k] != null && arr2[k] == null) {
                return false;
            }
            int result = this.compareUsingComparators(arr1[k], arr2[k]);
            if (result == 0) continue;
            if (result == 1) {
                return false;
            }
            if (arr1[k] instanceof AtomicInteger && arr2[k] instanceof AtomicInteger && ((AtomicInteger)arr1[k]).intValue() == ((AtomicInteger)arr2[k]).intValue() || arr1[k].equals(arr2[k])) continue;
            return false;
        }
        return true;
    }

    private int compareUsingComparators(Object o1, Object o2) {
        Comparator<?> compare;
        if (o1.getClass() == o2.getClass() && (compare = equalsHelpers.get(o1.getClass())) != null) {
            if (compare.compare(o1, o2) == 0) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        return this._methodName.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._className);
        buffer.append('.');
        buffer.append(this._methodName);
        buffer.append("(");
        for (int i = 0; i < this._arguments.length; ++i) {
            if (this._arguments[i] != null) {
                if (this._arguments[i] instanceof Class) {
                    buffer.append(((Class)this._arguments[i]).getName());
                } else if (Proxy.isProxyClass(this._arguments[i].getClass())) {
                    buffer.append(this._arguments[i].getClass().getName());
                } else if (this._arguments[i] instanceof Object[]) {
                    buffer.append(Arrays.toString((Object[])this._arguments[i]));
                } else {
                    buffer.append(String.valueOf(this._arguments[i]));
                }
            } else {
                buffer.append("null");
            }
            if (i + 1 >= this._arguments.length) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        String string = buffer.toString();
        return string;
    }

    public Class<?>[] getInterfaces() {
        return this._interfaces;
    }

    public Object getInvokedObject() {
        return this._invokedObject;
    }

    public static <T> void registerEqualsHelper(Class<T> type, Comparator<T> comparator) {
        equalsHelpers.put(type, comparator);
    }

    public static void removeEqualsHelper(Class<?> type) {
        equalsHelpers.remove(type);
    }
}

