/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.web.converter.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CachedOutputStream
extends OutputStream {
    private static final int DEFAULT_THRESHOLD = 65536;
    private OutputStream currentStream;
    private long threshold;
    private int totalLength;
    private boolean inmem;
    private List<InputStream> streams;
    private File tempFile;
    private File outputDir;

    public CachedOutputStream() {
        this(65536L, null);
    }

    public CachedOutputStream(long threshold, File outputDir) {
        this.threshold = threshold;
        this.outputDir = outputDir;
        this.currentStream = new ByteArrayOutputStream(2048);
        this.inmem = true;
        this.streams = new ArrayList<InputStream>(1);
    }

    public void flush() throws IOException {
        this.currentStream.flush();
    }

    public void close() throws IOException {
        this.currentStream.flush();
        this.currentStream.close();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.totalLength += len;
        if (this.inmem && (long)this.totalLength > this.threshold) {
            this.createFileOutputStream();
        }
        this.currentStream.write(b, off, len);
    }

    public void write(int b) throws IOException {
        ++this.totalLength;
        if (this.inmem && (long)this.totalLength > this.threshold) {
            this.createFileOutputStream();
        }
        this.currentStream.write(b);
    }

    private void createFileOutputStream() throws IOException {
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        this.tempFile = this.outputDir == null ? File.createTempFile("cos", "tmp") : File.createTempFile("cos", "tmp", this.outputDir);
        this.currentStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        bout.writeTo(this.currentStream);
        this.inmem = false;
    }

    public void destroy() {
        this.streams.clear();
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    public int size() {
        return this.totalLength;
    }

    public InputStream getInputStream() throws IOException {
        this.close();
        if (this.inmem) {
            return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.tempFile){

                public void close() throws IOException {
                    super.close();
                    CachedOutputStream.this.maybeDeleteTempFile(this);
                }
            };
            this.streams.add(fileInputStream);
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file was deleted, " + e.toString());
        }
    }

    private void maybeDeleteTempFile(Object stream) {
        this.streams.remove(stream);
        if (this.tempFile != null && this.streams.isEmpty()) {
            this.tempFile.delete();
            this.tempFile = null;
        }
    }
}

