/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.web.converter.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap
extends HashMap<String, String> {
    private static final Map<String, String> DEFAULT_KEY_MAP = new HashMap<String, String>();
    private Map<String, String> keyMap = new HashMap<String, String>(DEFAULT_KEY_MAP);

    private static void addKeyMapping(Map<String, String> mappings, String name) {
        mappings.put(name.toLowerCase(), name);
    }

    public CaseInsensitiveMap() {
    }

    public CaseInsensitiveMap(Map<String, String> source) {
        this();
        this.putAll(source);
    }

    public CaseInsensitiveMap(Properties source) {
        this();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            this.put(key, value);
        }
    }

    @Override
    public String put(String name, String value) {
        return super.put(this.getMappedName(name), value);
    }

    @Override
    public String get(Object name) {
        if (!(name instanceof String)) {
            return null;
        }
        return (String)super.get(this.getMappedName((String)name));
    }

    @Override
    public boolean containsKey(Object name) {
        if (!(name instanceof String)) {
            return false;
        }
        return super.containsKey(this.getMappedName((String)name));
    }

    private String getMappedName(String name) {
        String mappedName = this.keyMap.get(name.toLowerCase());
        if (mappedName == null) {
            mappedName = name;
        }
        return mappedName;
    }

    static {
        CaseInsensitiveMap.addKeyMapping(DEFAULT_KEY_MAP, "Bundle-SymbolicName");
        CaseInsensitiveMap.addKeyMapping(DEFAULT_KEY_MAP, "Bundle-Version");
        CaseInsensitiveMap.addKeyMapping(DEFAULT_KEY_MAP, "Bundle-ManifestVersion");
        CaseInsensitiveMap.addKeyMapping(DEFAULT_KEY_MAP, "Import-Package");
        CaseInsensitiveMap.addKeyMapping(DEFAULT_KEY_MAP, "Bundle-ClassPath");
        CaseInsensitiveMap.addKeyMapping(DEFAULT_KEY_MAP, "Web-ContextPath");
    }
}

