/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.web.converter.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathBuilder {
    private Map<String, Manifest> manifests;

    public ClassPathBuilder(Map<String, Manifest> manifests) {
        this.manifests = manifests;
    }

    public ArrayList<String> updatePath(String jarFile, ArrayList<String> classPath) throws IOException {
        Manifest manifest = this.manifests.get(jarFile);
        if (manifest == null) {
            return classPath;
        }
        String dependencies = manifest.getMainAttributes().getValue("Class-Path");
        if (dependencies == null) {
            dependencies = manifest.getMainAttributes().getValue("Class-path");
        }
        if (dependencies != null) {
            StringTokenizer tok = new StringTokenizer(dependencies, ";");
            while (tok.hasMoreTokens()) {
                String path = jarFile.substring(0, jarFile.lastIndexOf(47));
                String entry = tok.nextToken();
                path = new File("/" + path + "/" + entry).getCanonicalPath().replace('\\', '/');
                path = path.substring(path.indexOf(47) + 1);
                if (!entry.endsWith(".jar") || !this.manifests.keySet().contains(path) || classPath.contains(path) || path.startsWith("WEB-INF/lib/")) continue;
                classPath.add(path);
                classPath = this.updatePath(path, classPath);
            }
        }
        return classPath;
    }
}

