/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.web.converter.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPImportParser {
    private static final Pattern lineWithJSPimport = Pattern.compile("<%@\\s*page\\s*import.*%>");
    private static final Pattern stanzaEnd = Pattern.compile("%>");
    private static final Pattern imports = Pattern.compile("import\\s*=\\s*\"(.*?)\"");

    public static Collection<String> getImports(InputStream is) throws IOException {
        LinkedList<String> importedPackages = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        do {
            Matcher hasJSPimport;
            if ((line = reader.readLine()) == null || !(hasJSPimport = lineWithJSPimport.matcher(line)).find()) continue;
            LinkedList<String> foundImports = JSPImportParser.searchMatchedGroupForImports(hasJSPimport.group());
            for (String found : foundImports) {
                if (importedPackages.contains(found)) continue;
                importedPackages.add(found);
            }
        } while (line != null);
        return importedPackages;
    }

    private static LinkedList<String> searchMatchedGroupForImports(String groupExtent) {
        String[] importStanzas;
        LinkedList<String> packagesFound = new LinkedList<String>();
        for (String s : importStanzas = stanzaEnd.split(groupExtent)) {
            String[] imports;
            Matcher oneImport = JSPImportParser.imports.matcher(s);
            if (!oneImport.find()) continue;
            String thisStanzasImports = oneImport.group();
            String allPackages = thisStanzasImports.substring(thisStanzasImports.indexOf("\"") + 1, thisStanzasImports.lastIndexOf("\""));
            for (String p : imports = allPackages.split(",")) {
                String thisPackage = p.substring(0, p.lastIndexOf(46)).trim();
                if (thisPackage.startsWith("java.")) continue;
                packagesFound.add(thisPackage);
            }
        }
        return packagesFound;
    }
}

