/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.web.converter.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFinder
extends ClassVisitor {
    private static int asmVersion = 262144;
    private PackageFinderSignatureVisitor pfsv;
    private PackageFinderAnnotationVisitor pfav;
    private PackageFinderFieldVisitor pffv;
    private PackageFinderMethodVisitor pfmv;
    private Set<String> packages = new HashSet<String>();
    private Set<String> exemptPackages = new HashSet<String>();
    private String signatureOuterClass = null;

    public PackageFinder() {
        super(asmVersion);
        this.pfsv = new PackageFinderSignatureVisitor();
        this.pfav = new PackageFinderAnnotationVisitor();
        this.pffv = new PackageFinderFieldVisitor();
        this.pfmv = new PackageFinderMethodVisitor();
    }

    public Set<String> getImportPackages() {
        Iterator<String> i = this.packages.iterator();
        while (i.hasNext()) {
            if (!i.next().startsWith("java.")) continue;
            i.remove();
        }
        return this.packages;
    }

    public Set<String> getExemptPackages() {
        return this.exemptPackages;
    }

    private String getPackageName(String name) {
        int index;
        String packageName = null;
        if (name != null && (index = name.lastIndexOf(47)) > 0) {
            packageName = name.substring(0, index);
        }
        return packageName;
    }

    private String canonizePackage(String rawPackage) {
        String result = rawPackage.replace('/', '.');
        return result.replaceFirst("^\\[+L", "");
    }

    private void addPackage(String packageName) {
        if (packageName != null) {
            this.packages.add(this.canonizePackage(packageName));
        }
    }

    private void addExemptPackage(String packageName) {
        if (packageName != null) {
            this.exemptPackages.add(this.canonizePackage(packageName));
        }
    }

    private void addPackages(String[] packageNames) {
        if (packageNames != null) {
            for (String s : packageNames) {
                if (s == null) continue;
                this.packages.add(this.canonizePackage(s));
            }
        }
    }

    private String getResolvedPackageName(String name) {
        String resolvedName = null;
        if (name != null) {
            resolvedName = this.getPackageName(name);
        }
        return resolvedName;
    }

    private String[] getResolvedPackageNames(String[] names) {
        String[] resolvedNames = null;
        if (names != null) {
            resolvedNames = new String[names.length];
            int i = 0;
            for (String s : names) {
                resolvedNames[i++] = this.getResolvedPackageName(s);
            }
        }
        return resolvedNames;
    }

    private String getDescriptorInfo(String descriptor) {
        String type = null;
        if (descriptor != null) {
            type = this.getType(Type.getType((String)descriptor));
        }
        return type;
    }

    private String[] getMethodDescriptorInfo(String descriptor) {
        String[] descriptors = null;
        if (descriptor != null) {
            Type[] types = Type.getArgumentTypes((String)descriptor);
            descriptors = new String[types.length + 1];
            descriptors[0] = this.getType(Type.getReturnType((String)descriptor));
            int i = 1;
            for (Type t : types) {
                descriptors[i++] = this.getType(t);
            }
        }
        return descriptors;
    }

    private String getType(Type t) {
        String type = null;
        switch (t.getSort()) {
            case 9: {
                type = this.getType(t.getElementType());
                break;
            }
            case 10: {
                type = this.getPackageName(t.getInternalName());
            }
        }
        return type;
    }

    private void addSignaturePackages(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)this.pfsv);
        }
    }

    private void addResolvedSignaturePackages(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)this.pfsv);
        }
    }

    public void visit(int arg0, int arg1, String name, String signature, String parent, String[] interfaces) {
        this.addExemptPackage(this.getPackageName(name));
        if (signature == null) {
            this.addPackage(this.getResolvedPackageName(parent));
            this.addPackages(this.getResolvedPackageNames(interfaces));
        } else {
            this.addSignaturePackages(signature);
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.addPackage(this.getDescriptorInfo(descriptor));
        return this.pfav;
    }

    public void visitAttribute(Attribute arg0) {
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (signature == null) {
            this.addPackage(this.getDescriptorInfo(descriptor));
        } else {
            this.addResolvedSignaturePackages(signature);
        }
        if (value instanceof Type) {
            this.addPackage(this.getType((Type)value));
        }
        return this.pffv;
    }

    public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (signature == null) {
            this.addPackages(this.getMethodDescriptorInfo(descriptor));
        } else {
            this.addSignaturePackages(signature);
        }
        this.addPackages(this.getResolvedPackageNames(exceptions));
        return this.pfmv;
    }

    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    public void visitSource(String arg0, String arg1) {
    }

    public void visitEnd() {
    }

    public class PackageFinderMethodVisitor
    extends MethodVisitor {
        public PackageFinderMethodVisitor() {
            super(asmVersion);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return PackageFinder.this.pfav;
        }

        public void visitCode() {
        }

        public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
        }

        public void visitIincInsn(int arg0, int arg1) {
        }

        public void visitInsn(int arg0) {
        }

        public void visitIntInsn(int arg0, int arg1) {
        }

        public void visitJumpInsn(int arg0, Label arg1) {
        }

        public void visitLabel(Label arg0) {
        }

        public void visitLdcInsn(Object type) {
            if (type instanceof Type) {
                PackageFinder.this.addPackage(PackageFinder.this.getType((Type)type));
            }
        }

        public void visitLineNumber(int arg0, Label arg1) {
        }

        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            PackageFinder.this.addResolvedSignaturePackages(signature);
        }

        public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
        }

        public void visitMaxs(int arg0, int arg1) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
            PackageFinder.this.addPackage(PackageFinder.this.getResolvedPackageName(owner));
            PackageFinder.this.addPackages(PackageFinder.this.getMethodDescriptorInfo(descriptor));
        }

        public void visitMultiANewArrayInsn(String descriptor, int arg1) {
            PackageFinder.this.addPackage(PackageFinder.this.getDescriptorInfo(descriptor));
        }

        public AnnotationVisitor visitParameterAnnotation(int arg0, String descriptor, boolean arg2) {
            PackageFinder.this.addPackage(PackageFinder.this.getDescriptorInfo(descriptor));
            return PackageFinder.this.pfav;
        }

        public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label[] arg3) {
        }

        public void visitTryCatchBlock(Label arg0, Label arg1, Label arg2, String type) {
            PackageFinder.this.addPackage(PackageFinder.this.getResolvedPackageName(type));
        }

        public void visitTypeInsn(int arg0, String type) {
            PackageFinder.this.addPackage(PackageFinder.this.getResolvedPackageName(type));
        }

        public void visitVarInsn(int arg0, int arg1) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            PackageFinder.this.addPackage(PackageFinder.this.getResolvedPackageName(owner));
            PackageFinder.this.addPackage(PackageFinder.this.getDescriptorInfo(descriptor));
        }
    }

    public class PackageFinderFieldVisitor
    extends FieldVisitor {
        public PackageFinderFieldVisitor() {
            super(asmVersion);
        }
    }

    public class PackageFinderAnnotationVisitor
    extends AnnotationVisitor {
        public PackageFinderAnnotationVisitor() {
            super(asmVersion);
        }

        public void visit(String arg0, Object value) {
            if (value instanceof Type) {
                PackageFinder.this.addPackage(PackageFinder.this.getType((Type)value));
            }
        }

        public AnnotationVisitor visitAnnotation(String arg0, String descriptor) {
            PackageFinder.this.addPackage(PackageFinder.this.getDescriptorInfo(descriptor));
            return PackageFinder.this.pfav;
        }

        public AnnotationVisitor visitArray(String arg0) {
            return PackageFinder.this.pfav;
        }

        public void visitEnum(String name, String desc, String value) {
            PackageFinder.this.addPackage(PackageFinder.this.getDescriptorInfo(desc));
        }
    }

    public class PackageFinderSignatureVisitor
    extends SignatureVisitor {
        public PackageFinderSignatureVisitor() {
            super(asmVersion);
        }

        public SignatureVisitor visitArrayType() {
            return PackageFinder.this.pfsv;
        }

        public void visitBaseType(char arg0) {
        }

        public SignatureVisitor visitClassBound() {
            return PackageFinder.this.pfsv;
        }

        public void visitClassType(String name) {
            PackageFinder.this.signatureOuterClass = name;
            PackageFinder.this.addPackage(PackageFinder.this.getResolvedPackageName(name));
        }

        public void visitInnerClassType(String name) {
            PackageFinder.this.addPackage(PackageFinder.this.getResolvedPackageName(PackageFinder.this.signatureOuterClass + "$" + name));
        }

        public SignatureVisitor visitExceptionType() {
            return PackageFinder.this.pfsv;
        }

        public void visitFormalTypeParameter(String arg0) {
        }

        public SignatureVisitor visitInterface() {
            return PackageFinder.this.pfsv;
        }

        public SignatureVisitor visitParameterType() {
            return PackageFinder.this.pfsv;
        }

        public SignatureVisitor visitReturnType() {
            return PackageFinder.this.pfsv;
        }

        public SignatureVisitor visitSuperclass() {
            return PackageFinder.this.pfsv;
        }

        public void visitTypeArgument() {
        }

        public SignatureVisitor visitTypeArgument(char arg0) {
            return PackageFinder.this.pfsv;
        }

        public void visitTypeVariable(String arg0) {
        }

        public SignatureVisitor visitInterfaceBound() {
            return PackageFinder.this.pfsv;
        }
    }
}

