/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.web.converter.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.aries.web.converter.WabConversion;
import org.apache.aries.web.converter.WarToWabConverter;
import org.apache.aries.web.converter.impl.CachedOutputStream;
import org.apache.aries.web.converter.impl.CaseInsensitiveMap;
import org.apache.aries.web.converter.impl.ClassPathBuilder;
import org.apache.aries.web.converter.impl.JSPImportParser;
import org.apache.aries.web.converter.impl.PackageFinder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarToWabConverterImpl
implements WabConversion {
    private static final String DEFAULT_BUNDLE_VERSION = "1.0";
    private static final String DEFAULT_BUNDLE_MANIFESTVERSION = "2";
    private static final String INITIAL_CLASSPATH_ENTRY = "WEB-INF/classes";
    private static final String CLASSPATH_LIB_PREFIX = "WEB-INF/lib/";
    private static final String SERVLET_IMPORTS = "javax.servlet;version=2.5,javax.servlet.http;version=2.5";
    private static final String JSP_IMPORTS = "javax.servlet.jsp;version=2.1,javax.servlet.jsp.el;version=2.1,javax.servlet.jsp.tagext;version=2.1,javax.servlet.jsp.resources;version=2.1";
    private static final String DEFAULT_IMPORT_PACKAGE_LIST = "javax.servlet;version=2.5,javax.servlet.http;version=2.5,javax.servlet.jsp;version=2.1,javax.servlet.jsp.el;version=2.1,javax.servlet.jsp.tagext;version=2.1,javax.servlet.jsp.resources;version=2.1";
    private CaseInsensitiveMap properties;
    private CachedOutputStream wab;
    private Manifest wabManifest;
    private String warName;
    private WarToWabConverter.InputStreamProvider input;
    private Set<String> importPackages;
    private Set<String> exemptPackages;
    private Map<String, Manifest> manifests;
    private ArrayList<String> classPath;
    private boolean signed;

    public WarToWabConverterImpl(WarToWabConverter.InputStreamProvider warFile, String name, Properties properties) throws IOException {
        this(warFile, name, new CaseInsensitiveMap(properties));
    }

    public WarToWabConverterImpl(WarToWabConverter.InputStreamProvider warFile, String name, CaseInsensitiveMap properties) throws IOException {
        this.properties = properties;
        this.classPath = new ArrayList();
        this.importPackages = new TreeSet<String>();
        this.exemptPackages = new TreeSet<String>();
        this.input = warFile;
        this.warName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateManifest() throws IOException {
        if (this.wabManifest != null) {
            return;
        }
        JarInputStream jarInput = null;
        try {
            jarInput = new JarInputStream(this.input.getInputStream());
            Manifest manifest = jarInput.getManifest();
            if (this.isBundle(manifest)) {
                this.wabManifest = this.updateBundleManifest(manifest);
            } else {
                this.scanForDependencies(jarInput);
                this.wabManifest = this.updateManifest(manifest);
            }
        }
        finally {
            try {
                if (jarInput != null) {
                    jarInput.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convert() throws IOException {
        if (this.wab != null) {
            return;
        }
        this.generateManifest();
        CachedOutputStream output = new CachedOutputStream();
        ZipOutputStream jarOutput = null;
        ZipInputStream jarInput = null;
        ZipEntry entry = null;
        try {
            jarOutput = new JarOutputStream((OutputStream)output, this.wabManifest);
            jarInput = new JarInputStream(this.input.getInputStream());
            byte[] buffer = new byte[2048];
            while ((entry = ((JarInputStream)jarInput).getNextEntry()) != null) {
                int val;
                if (this.signed && WarToWabConverterImpl.isSignatureFile(entry.getName())) continue;
                ((JarOutputStream)jarOutput).putNextEntry(entry);
                while ((val = jarInput.read(buffer)) > 0) {
                    jarOutput.write(buffer, 0, val);
                }
            }
        }
        finally {
            if (jarOutput != null) {
                jarOutput.close();
            }
            if (jarInput != null) {
                jarInput.close();
            }
        }
        this.wab = output;
    }

    private boolean isBundle(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue("Bundle-SymbolicName") != null || attributes.getValue("Bundle-Version") != null || attributes.getValue("Bundle-ManifestVersion") != null || attributes.getValue("Import-Package") != null || attributes.getValue("Web-ContextPath") != null;
    }

    private void scanRecursive(final JarInputStream jarInput, boolean topLevel) throws IOException {
        ZipEntry entry;
        while ((entry = jarInput.getNextEntry()) != null) {
            if (entry.getName().endsWith(".class")) {
                PackageFinder pkgFinder = new PackageFinder();
                new ClassReader((InputStream)jarInput).accept((ClassVisitor)pkgFinder, 2);
                this.importPackages.addAll(pkgFinder.getImportPackages());
                this.exemptPackages.addAll(pkgFinder.getExemptPackages());
                continue;
            }
            if (entry.getName().endsWith(".jsp")) {
                Collection<String> thisJSPsImports = JSPImportParser.getImports(jarInput);
                this.importPackages.addAll(thisJSPsImports);
                continue;
            }
            if (!entry.getName().endsWith(".jar")) continue;
            JarInputStream newJar = new JarInputStream(new InputStream(){

                public int read() throws IOException {
                    return jarInput.read();
                }
            });
            this.scanRecursive(newJar, false);
            if (!topLevel) continue;
            this.manifests.put(entry.getName(), newJar.getManifest());
        }
    }

    private void scanForDependencies(JarInputStream jarInput) throws IOException {
        this.manifests = new HashMap<String, Manifest>();
        this.scanRecursive(jarInput, true);
        ClassPathBuilder classPathBuilder = new ClassPathBuilder(this.manifests);
        for (String fileName : this.manifests.keySet()) {
            if (!fileName.startsWith(CLASSPATH_LIB_PREFIX)) continue;
            this.classPath.add(fileName);
            this.classPath = classPathBuilder.updatePath(fileName, this.classPath);
        }
        for (String s : this.exemptPackages) {
            if (!this.importPackages.contains(s)) continue;
            this.importPackages.remove(s);
        }
    }

    protected Manifest updateBundleManifest(Manifest manifest) throws IOException {
        String webCPath = this.properties.get("Web-ContextPath");
        if (webCPath == null) {
            webCPath = manifest.getMainAttributes().getValue("Web-ContextPath");
        }
        if (webCPath == null) {
            throw new IOException("Must specify Web-ContextPath parameter. The Web-ContextPath header is not defined in the source bundle.");
        }
        webCPath = WarToWabConverterImpl.addSlash(webCPath);
        manifest.getMainAttributes().put(new Attributes.Name("Web-ContextPath"), webCPath);
        this.checkParameter("Bundle-Version");
        this.checkParameter("Bundle-ManifestVersion");
        this.checkParameter("Bundle-SymbolicName");
        this.checkParameter("Import-Package");
        this.checkParameter("Bundle-ClassPath");
        return manifest;
    }

    private void checkParameter(String parameter) throws IOException {
        if (this.properties.containsKey(parameter)) {
            throw new IOException("Cannot override " + parameter + " header when converting a bundle");
        }
    }

    protected Manifest updateManifest(Manifest manifest) throws IOException {
        String manifestVersion;
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1");
        } else {
            this.signed = WarToWabConverterImpl.removeDigestAttributes(manifest);
        }
        String webCPath = this.properties.get("Web-ContextPath");
        if (webCPath == null) {
            throw new IOException("Web-ContextPath parameter is missing.");
        }
        this.properties.put("Web-ContextPath", WarToWabConverterImpl.addSlash(webCPath));
        if (manifest.getMainAttributes().getValue("Bundle-Version") == null && !this.properties.containsKey("Bundle-Version")) {
            this.properties.put("Bundle-Version", DEFAULT_BUNDLE_VERSION);
        }
        if ((manifestVersion = this.properties.get("Bundle-ManifestVersion")) == null) {
            manifestVersion = manifest.getMainAttributes().getValue("Bundle-ManifestVersion");
            if (manifestVersion == null) {
                manifestVersion = DEFAULT_BUNDLE_MANIFESTVERSION;
            }
        } else if (!manifestVersion.equals(DEFAULT_BUNDLE_MANIFESTVERSION)) {
            throw new IOException("Unsupported bundle manifest version " + manifestVersion);
        }
        this.properties.put("Bundle-ManifestVersion", manifestVersion);
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(INITIAL_CLASSPATH_ENTRY);
        classpath.addAll(this.classPath);
        WarToWabConverterImpl.mergePathList(this.properties.get("Bundle-ClassPath"), classpath, ",");
        WarToWabConverterImpl.mergePathList(manifest.getMainAttributes().getValue("Bundle-ClassPath"), classpath, ",");
        StringBuffer classPathValue = new StringBuffer();
        for (String entry : classpath) {
            classPathValue.append(",");
            classPathValue.append(entry);
        }
        if (!classpath.isEmpty()) {
            this.properties.put("Bundle-ClassPath", classPathValue.toString().substring(1));
        }
        ArrayList<String> packages = new ArrayList<String>(){

            @Override
            public boolean contains(Object elem) {
                if (super.contains(elem)) {
                    return true;
                }
                if (!(elem instanceof String)) {
                    return false;
                }
                String expPackageStmt = (String)elem;
                String expPackage = expPackageStmt.split("\\s*;\\s*")[0];
                Pattern p = Pattern.compile("^\\s*" + Pattern.quote(expPackage) + "((;|\\s).*)?\\s*$");
                for (String s : this) {
                    Matcher m = p.matcher(s);
                    if (!m.matches()) continue;
                    return true;
                }
                return false;
            }
        };
        packages.clear();
        WarToWabConverterImpl.mergePathList(this.properties.get("Import-Package"), packages, ",");
        WarToWabConverterImpl.mergePathList(manifest.getMainAttributes().getValue("Import-Package"), packages, ",");
        WarToWabConverterImpl.mergePathList(DEFAULT_IMPORT_PACKAGE_LIST, packages, ",");
        if (!this.importPackages.isEmpty()) {
            StringBuffer generatedImports = new StringBuffer();
            for (String string : this.importPackages) {
                generatedImports.append(',');
                generatedImports.append(string);
                generatedImports.append(";resolution:=optional");
            }
            WarToWabConverterImpl.mergePathList(generatedImports.substring(1), packages, ",");
        }
        StringBuffer importValues = new StringBuffer();
        for (String string : packages) {
            importValues.append(",");
            importValues.append(string);
        }
        if (!packages.isEmpty()) {
            this.properties.put("Import-Package", importValues.toString().substring(1));
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            manifest.getMainAttributes().putValue(key, value);
        }
        if (manifest.getMainAttributes().getValue("Bundle-SymbolicName") == null) {
            manifest.getMainAttributes().putValue("Bundle-SymbolicName", this.warName + "_" + manifest.hashCode());
        }
        return manifest;
    }

    private static String addSlash(String contextPath) {
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        return contextPath;
    }

    private static void mergePathList(String pathlist, ArrayList<String> paths, String delim) {
        if (pathlist != null) {
            List<String> tokens = WarToWabConverterImpl.parseDelimitedString(pathlist, delim, true);
            for (String token : tokens) {
                if (paths.contains(token)) continue;
                paths.add(token);
            }
        }
    }

    private static List<String> parseDelimitedString(String value, String delim, boolean includeQuotes) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                if (includeQuotes) {
                    sb.append(c);
                }
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                if (includeQuotes) {
                    sb.append(c);
                }
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list;
    }

    private static boolean removeDigestAttributes(Manifest manifest) {
        boolean foundDigestAttribute = false;
        for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
            Attributes attributes = entry.getValue();
            for (Object attributeName : attributes.keySet()) {
                String name = ((Attributes.Name)attributeName).toString();
                if (!(name = name.toLowerCase()).endsWith("-digest") && !name.contains("-digest-")) continue;
                attributes.remove(attributeName);
                foundDigestAttribute = true;
            }
        }
        return foundDigestAttribute;
    }

    private static boolean isSignatureFile(String entryName) {
        String[] parts = entryName.split("/");
        if (parts.length == 2) {
            String name = parts[1].toLowerCase();
            return parts[0].equals("META-INF") && (name.endsWith(".sf") || name.endsWith(".dsa") || name.endsWith(".rsa") || name.startsWith("sig-"));
        }
        return false;
    }

    @Override
    public InputStream getWAB() throws IOException {
        this.convert();
        return this.wab.getInputStream();
    }

    @Override
    public Manifest getWABManifest() throws IOException {
        this.generateManifest();
        return this.wabManifest;
    }

    public int getWabLength() throws IOException {
        this.convert();
        return this.wab.size();
    }
}

