/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.web.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.aries.web.converter.WarToWabConverter;
import org.apache.aries.web.converter.impl.CaseInsensitiveMap;
import org.apache.aries.web.converter.impl.WarToWabConverterImpl;

public class WARConnection
extends URLConnection {
    private WarToWabConverterImpl converter = null;
    private CaseInsensitiveMap properties;

    protected WARConnection(URL url, CaseInsensitiveMap properties) throws MalformedURLException {
        super(url);
        this.properties = properties;
    }

    public void connect() throws IOException {
        int fileNameIndex = this.url.getFile().lastIndexOf("/") + 1;
        String warName = fileNameIndex != 0 ? this.url.getFile().substring(fileNameIndex) : this.url.getFile();
        this.converter = new WarToWabConverterImpl(new WarToWabConverter.InputStreamProvider(){

            public InputStream getInputStream() throws IOException {
                return WARConnection.this.url.openStream();
            }
        }, warName, this.properties);
    }

    public InputStream getInputStream() throws IOException {
        if (this.converter == null) {
            this.connect();
        }
        return this.converter.getWAB();
    }

    public int getContentLength() {
        try {
            if (this.converter == null) {
                this.connect();
            }
            return this.converter.getWabLength();
        }
        catch (IOException e) {
            return -1;
        }
    }
}

