/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.web.url;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.aries.web.converter.impl.CaseInsensitiveMap;
import org.apache.aries.web.url.WARConnection;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class WAR_URLServiceHandler
extends AbstractURLStreamHandlerService
implements BundleActivator {
    private static final String urlScheme = "webbundle";

    public URLConnection openConnection(URL url) throws IOException {
        CaseInsensitiveMap properties = new CaseInsensitiveMap();
        if (url.getQuery() != null) {
            String propString = url.getQuery();
            StringTokenizer tok = new StringTokenizer(propString);
            boolean firstProperty = true;
            while (tok.hasMoreElements()) {
                String name = tok.nextToken("=");
                if (!firstProperty) {
                    name = name.substring(1);
                }
                String value = tok.nextToken("&").substring(1);
                properties.put(name, value);
                firstProperty = false;
            }
        }
        return new WARConnection(new URL(url.getPath()), properties);
    }

    public void parseURL(URL u, String spec, int start, int limit) {
        int propertyStart = spec.lastIndexOf(63) + 1;
        String propertyString = null;
        if (propertyStart > 0) {
            propertyString = spec.substring(propertyStart, spec.length());
            --propertyStart;
        } else {
            propertyStart = spec.length();
        }
        String warURL = spec.substring(start, propertyStart);
        this.setURL(u, urlScheme, null, 0, null, null, warURL, propertyString, null);
    }

    public void start(BundleContext context) throws Exception {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        ((Dictionary)properties).put("url.handler.protocol", new String[]{urlScheme});
        context.registerService(URLStreamHandlerService.class.getName(), (Object)this, properties);
    }

    public void stop(BundleContext arg0) throws Exception {
    }
}

