/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package demoapp.dom.types.javamath.bigdecimals.samples;

import java.math.BigDecimal;
import java.util.stream.Stream;

import org.springframework.stereotype.Service;

import demoapp.dom.types.Samples;

@Service
public class JavaMathBigDecimalSamples implements Samples<BigDecimal> {

    @Override
    public Stream<BigDecimal> stream() {
        return Stream.of(BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.valueOf(123_456_789_012L), BigDecimal.valueOf(1234567.8890f), BigDecimal.valueOf(123_456_789_012L, 3));
    }

}
