/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.client.kroviz.snapshots.knife

import org.apache.causeway.client.kroviz.snapshots.Response

object OBJECT_LAYOUT: Response(){
    override val url = "http://localhost:8080/restful/objects/demo.Text/AR-LCAAAAAAAAACFkLEOgkAMhneeorlJB0Xj4nBASIybi9EHOKExF3s9wx0Kby8ERKIkdvrTv_36pzKpDMEDC6ctR2K9XAlAzmyu-RqJ82m_2ApwXnGuyDJGokYnkjiQOzQ2DqAp6XzRTMcKOgGzjHR2A4NzGfbeePBQktekGeMUzFv3u4G7K-ZWbKBtu-UE7QMYY4-ocstUNzmKXg6BLqUHRWSfDjxWHhwSZn4ADquTMQc3_QZPpf1z6pcayLD75QsMtJyWiwEAAA==/object-layout"
    override val str = """
{
  "row": [
    {
      "cols": [
        {
          "col": {
            "sizeSpan": [],
            "domainObject": {
              "named": null,
              "describedAs": null,
              "plural": null,
              "metadataError": null,
              "link": {
                "rel": "urn:org.restfulobjects:rels/element",
                "method": "GET",
                "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=",
                "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object\""
              },
              "bookmarking": "AS_ROOT",
              "cssClass": null,
              "cssClassFa": null,
              "cssClassFaPosition": null
            },
            "action": [],
            "row": [],
            "tabGroup": [],
            "fieldSet": [],
            "collection": [],
            "metadataError": null,
            "cssClass": null,
            "size": null,
            "id": null,
            "span": 12,
            "unreferencedActions": true,
            "unreferencedCollections": null
          }
        }
      ],
      "metadataError": null,
      "cssClass": null,
      "id": null
    },
    {
      "cols": [
        {
          "col": {
            "sizeSpan": [],
            "domainObject": null,
            "action": [],
            "row": [
              {
                "cols": [
                  {
                    "col": {
                      "sizeSpan": [],
                      "domainObject": null,
                      "action": [],
                      "row": [],
                      "tabGroup": [
                        {
                          "tab": [
                            {
                              "name": "Identity",
                              "row": [
                                {
                                  "cols": [
                                    {
                                      "col": {
                                        "sizeSpan": [],
                                        "domainObject": null,
                                        "action": [],
                                        "row": [],
                                        "tabGroup": [],
                                        "fieldSet": [
                                          {
                                            "name": "Identity",
                                            "action": [],
                                            "property": [],
                                            "metadataError": null,
                                            "id": "identity",
                                            "unreferencedActions": null,
                                            "unreferencedProperties": null
                                          }
                                        ],
                                        "collection": [],
                                        "metadataError": null,
                                        "cssClass": null,
                                        "size": null,
                                        "id": null,
                                        "span": 12,
                                        "unreferencedActions": null,
                                        "unreferencedCollections": null
                                      }
                                    }
                                  ],
                                  "metadataError": null,
                                  "cssClass": null,
                                  "id": null
                                }
                              ],
                              "cssClass": null
                            },
                            {
                              "name": "Other",
                              "row": [
                                {
                                  "cols": [
                                    {
                                      "col": {
                                        "sizeSpan": [],
                                        "domainObject": null,
                                        "action": [],
                                        "row": [],
                                        "tabGroup": [],
                                        "fieldSet": [
                                          {
                                            "name": "Other",
                                            "action": [],
                                            "property": [
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "action": [],
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/property",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/properties/actionArguments",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\""
                                                },
                                                "id": "actionArguments",
                                                "cssClass": null,
                                                "hidden": null,
                                                "labelPosition": "NOT_SPECIFIED",
                                                "multiLine": null,
                                                "promptStyle": null,
                                                "dateRenderAdjustDays": 0,
                                                "typicalLength": 25,
                                                "repainting": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "action": [],
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/property",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/properties/actionId",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\""
                                                },
                                                "id": "actionId",
                                                "cssClass": null,
                                                "hidden": null,
                                                "labelPosition": "NOT_SPECIFIED",
                                                "multiLine": null,
                                                "promptStyle": null,
                                                "dateRenderAdjustDays": 0,
                                                "typicalLength": 25,
                                                "repainting": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "action": [],
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/property",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/properties/actionOwningFqcn",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\""
                                                },
                                                "id": "actionOwningFqcn",
                                                "cssClass": null,
                                                "hidden": null,
                                                "labelPosition": "NOT_SPECIFIED",
                                                "multiLine": null,
                                                "promptStyle": null,
                                                "dateRenderAdjustDays": 0,
                                                "typicalLength": 25,
                                                "repainting": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "action": [],
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/property",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/properties/elementTypeFqcn",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\""
                                                },
                                                "id": "elementTypeFqcn",
                                                "cssClass": null,
                                                "hidden": null,
                                                "labelPosition": "NOT_SPECIFIED",
                                                "multiLine": null,
                                                "promptStyle": null,
                                                "dateRenderAdjustDays": 0,
                                                "typicalLength": 25,
                                                "repainting": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "action": [],
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/property",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/properties/title",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\""
                                                },
                                                "id": "title",
                                                "cssClass": null,
                                                "hidden": null,
                                                "labelPosition": "NOT_SPECIFIED",
                                                "multiLine": null,
                                                "promptStyle": null,
                                                "dateRenderAdjustDays": 0,
                                                "typicalLength": 25,
                                                "repainting": null
                                              }
                                            ],
                                            "metadataError": null,
                                            "id": "other",
                                            "unreferencedActions": null,
                                            "unreferencedProperties": true
                                          }
                                        ],
                                        "collection": [],
                                        "metadataError": null,
                                        "cssClass": null,
                                        "size": null,
                                        "id": null,
                                        "span": 12,
                                        "unreferencedActions": null,
                                        "unreferencedCollections": null
                                      }
                                    }
                                  ],
                                  "metadataError": null,
                                  "cssClass": null,
                                  "id": null
                                }
                              ],
                              "cssClass": null
                            },
                            {
                              "name": "Metadata",
                              "row": [
                                {
                                  "cols": [
                                    {
                                      "col": {
                                        "sizeSpan": [],
                                        "domainObject": null,
                                        "action": [],
                                        "row": [],
                                        "tabGroup": [],
                                        "fieldSet": [
                                          {
                                            "name": "Metadata",
                                            "action": [
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/action",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/actions/clearHints",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\""
                                                },
                                                "id": "clearHints",
                                                "bookmarking": null,
                                                "cssClass": null,
                                                "cssClassFa": null,
                                                "cssClassFaPosition": null,
                                                "hidden": null,
                                                "position": "PANEL_DROPDOWN",
                                                "promptStyle": null,
                                                "redirect": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/action",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/actions/downloadLayoutXml",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\""
                                                },
                                                "id": "downloadLayoutXml",
                                                "bookmarking": null,
                                                "cssClass": null,
                                                "cssClassFa": null,
                                                "cssClassFaPosition": null,
                                                "hidden": null,
                                                "position": "PANEL_DROPDOWN",
                                                "promptStyle": null,
                                                "redirect": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/action",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/actions/downloadMetamodelXml",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\""
                                                },
                                                "id": "downloadMetamodelXml",
                                                "bookmarking": null,
                                                "cssClass": null,
                                                "cssClassFa": null,
                                                "cssClassFaPosition": null,
                                                "hidden": null,
                                                "position": "PANEL_DROPDOWN",
                                                "promptStyle": null,
                                                "redirect": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/action",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/actions/inspectMetamodel",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\""
                                                },
                                                "id": "inspectMetamodel",
                                                "bookmarking": null,
                                                "cssClass": null,
                                                "cssClassFa": null,
                                                "cssClassFaPosition": null,
                                                "hidden": null,
                                                "position": "PANEL_DROPDOWN",
                                                "promptStyle": null,
                                                "redirect": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/action",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/actions/openRestApi",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\""
                                                },
                                                "id": "openRestApi",
                                                "bookmarking": null,
                                                "cssClass": null,
                                                "cssClassFa": null,
                                                "cssClassFaPosition": null,
                                                "hidden": null,
                                                "position": "PANEL_DROPDOWN",
                                                "promptStyle": null,
                                                "redirect": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/action",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/actions/rebuildMetamodel",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\""
                                                },
                                                "id": "rebuildMetamodel",
                                                "bookmarking": null,
                                                "cssClass": null,
                                                "cssClassFa": null,
                                                "cssClassFaPosition": null,
                                                "hidden": null,
                                                "position": "PANEL_DROPDOWN",
                                                "promptStyle": null,
                                                "redirect": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/action",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/actions/impersonate",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\""
                                                },
                                                "id": "impersonate",
                                                "bookmarking": null,
                                                "cssClass": null,
                                                "cssClassFa": null,
                                                "cssClassFaPosition": null,
                                                "hidden": null,
                                                "position": "PANEL_DROPDOWN",
                                                "promptStyle": null,
                                                "redirect": null
                                              },
                                              {
                                                "named": null,
                                                "describedAs": null,
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/action",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/actions/impersonateWithRoles",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-action\""
                                                },
                                                "id": "impersonateWithRoles",
                                                "bookmarking": null,
                                                "cssClass": null,
                                                "cssClassFa": null,
                                                "cssClassFaPosition": null,
                                                "hidden": null,
                                                "position": "PANEL_DROPDOWN",
                                                "promptStyle": null,
                                                "redirect": null
                                              }
                                            ],
                                            "property": [
                                              {
                                                "named": "Logical Type Name",
                                                "describedAs": null,
                                                "action": [],
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/property",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/properties/logicalTypeName",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\""
                                                },
                                                "id": "logicalTypeName",
                                                "cssClass": null,
                                                "hidden": "ALL_TABLES",
                                                "labelPosition": null,
                                                "multiLine": null,
                                                "promptStyle": null,
                                                "dateRenderAdjustDays": 0,
                                                "typicalLength": 25,
                                                "repainting": null
                                              },
                                              {
                                                "named": "Object Identifier",
                                                "describedAs": null,
                                                "action": [],
                                                "metadataError": null,
                                                "link": {
                                                  "rel": "urn:org.restfulobjects:rels/property",
                                                  "method": "GET",
                                                  "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/properties/objectIdentifier",
                                                  "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-property\""
                                                },
                                                "id": "objectIdentifier",
                                                "cssClass": null,
                                                "hidden": "ALL_TABLES",
                                                "labelPosition": null,
                                                "multiLine": null,
                                                "promptStyle": null,
                                                "dateRenderAdjustDays": 0,
                                                "typicalLength": 25,
                                                "repainting": null
                                              }
                                            ],
                                            "metadataError": null,
                                            "id": "metadata",
                                            "unreferencedActions": null,
                                            "unreferencedProperties": null
                                          }
                                        ],
                                        "collection": [],
                                        "metadataError": null,
                                        "cssClass": null,
                                        "size": null,
                                        "id": null,
                                        "span": 12,
                                        "unreferencedActions": null,
                                        "unreferencedCollections": null
                                      }
                                    }
                                  ],
                                  "metadataError": null,
                                  "cssClass": null,
                                  "id": null
                                }
                              ],
                              "cssClass": null
                            }
                          ],
                          "metadataError": null,
                          "cssClass": null,
                          "unreferencedCollections": null,
                          "collapseIfOne": null
                        }
                      ],
                      "fieldSet": [],
                      "collection": [],
                      "metadataError": null,
                      "cssClass": null,
                      "size": null,
                      "id": null,
                      "span": 12,
                      "unreferencedActions": null,
                      "unreferencedCollections": null
                    }
                  }
                ],
                "metadataError": null,
                "cssClass": null,
                "id": null
              },
              {
                "cols": [
                  {
                    "col": {
                      "sizeSpan": [],
                      "domainObject": null,
                      "action": [],
                      "row": [],
                      "tabGroup": [],
                      "fieldSet": [
                        {
                          "name": "Details",
                          "action": [],
                          "property": [],
                          "metadataError": null,
                          "id": "details",
                          "unreferencedActions": null,
                          "unreferencedProperties": null
                        }
                      ],
                      "collection": [],
                      "metadataError": null,
                      "cssClass": null,
                      "size": null,
                      "id": null,
                      "span": 12,
                      "unreferencedActions": null,
                      "unreferencedCollections": null
                    }
                  }
                ],
                "metadataError": null,
                "cssClass": null,
                "id": null
              }
            ],
            "tabGroup": [],
            "fieldSet": [],
            "collection": [],
            "metadataError": null,
            "cssClass": null,
            "size": null,
            "id": null,
            "span": 4,
            "unreferencedActions": null,
            "unreferencedCollections": null
          }
        },
        {
          "col": {
            "sizeSpan": [],
            "domainObject": null,
            "action": [],
            "row": [],
            "tabGroup": [
              {
                "tab": [
                  {
                    "name": "Objects",
                    "row": [
                      {
                        "cols": [
                          {
                            "col": {
                              "sizeSpan": [],
                              "domainObject": null,
                              "action": [],
                              "row": [],
                              "tabGroup": [],
                              "fieldSet": [],
                              "collection": [
                                {
                                  "named": null,
                                  "describedAs": null,
                                  "sortedBy": null,
                                  "action": [],
                                  "metadataError": null,
                                  "link": {
                                    "rel": "urn:org.restfulobjects:rels/collection",
                                    "method": "GET",
                                    "href": "http://localhost:8080/restful/objects/causeway.applib.DomainObjectList/AR-LCAAAAAAAAACVlctugzAURPf5Csv7Ymh4mMgQZdFIXXWTfgAFh7gBm8buI39fU0QaNVKlYQWXOdd3NGCL9VffkQ95ssrogkZBSInUtWmUbgv6vNvecUqsq3RTdUbLgp6lpetyITplHfGstqva9AU9ODesGFNW2aAaqvogA3NqmfU3fcW8pDealgviL-GU62S5TMiDbgajtLOCTbXpfVU7P83Tp_ZDbN9qXXo8OOpA7WVQ79vgCruRXnd4bMpxzE3XzUJfuRZsTu17L32jchb8Viad7OT4uDsP8r9JBPsrnHDz8irrudlPxTdYGdUQ54UFPeqx09yFEtUUdJlQhgEcBSJ4iQheI0XXyOIUJjKUSCKYuIcJ2HmC-0DzyFLYR7qECdhHCvvI4KmyGCZgHxnsg8N5cPi74vAfxXOUyEOYgPPI4TxyNA8eojsDD9EEeYgmyEM0QQ7v7TyGnceXNQS7HHGCjYdtufgGnDSqh1MIAAA=/collections/objects",
                                    "type": "application/json;profile=\"urn:org.restfulobjects:repr-types/object-collection\""
                                  },
                                  "id": "objects",
                                  "cssClass": null,
                                  "defaultView": "table",
                                  "hidden": null,
                                  "paged": 12
                                }
                              ],
                              "metadataError": null,
                              "cssClass": null,
                              "size": "MD",
                              "id": null,
                              "span": 12,
                              "unreferencedActions": null,
                              "unreferencedCollections": null
                            }
                          }
                        ],
                        "metadataError": null,
                        "cssClass": null,
                        "id": null
                      }
                    ],
                    "cssClass": null
                  }
                ],
                "metadataError": null,
                "cssClass": null,
                "unreferencedCollections": true,
                "collapseIfOne": null
              }
            ],
            "fieldSet": [],
            "collection": [],
            "metadataError": null,
            "cssClass": null,
            "size": null,
            "id": null,
            "span": 8,
            "unreferencedActions": null,
            "unreferencedCollections": null
          }
        }
      ],
      "metadataError": null,
      "cssClass": null,
      "id": null
    }
  ],
  "metadataError": [],
  "cssClass": null
}
    """
}
