/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.testdomain.model.bad;

import javax.inject.Named;

import org.joda.time.LocalDateTime;

import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.NatureOfService;

@Named("testdomain.InvalidServiceWithAlias")
@DomainService(nature = NatureOfService.VIEW,
        aliased = {
            "testdomain.v0.InvalidServiceWithAlias",
            "testdomain.v0.InvalidObjectWithAlias", // <-- expected collision (validation error)
        })
public class InvalidServiceWithAlias {

    @Action public LocalDateTime now() {
        return LocalDateTime.now();
    }

}
