/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.tooling.projectmodel.test;

import java.io.IOException;
import java.time.LocalDate;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertNotNull;

import org.apache.causeway.tooling.projectmodel.gradle.GradleDependencies;
import org.apache.causeway.tooling.projectmodel.gradle.GradleDependenciesFactory;
import org.apache.causeway.tooling.projectmodel.gradle.GradleDependenciesWriter;

class GradleDependenciesTest extends ProjectModelTestAbstract {

    @Test //@Disabled("activate only if you want to see the dependencies.gradle written to stdout")
    void writeGradleDependenciesToStdout() throws IOException {
        GradleDependencies gradleDependencies = GradleDependenciesFactory.generateFromMaven(projRootFolder, "causeway");
        assertNotNull(gradleDependencies);
        
        System.out.println();
        System.out.println();
        System.out.println(String.format("// generated by %s", this.getClass().getName()));
        System.out.println(String.format("// date %s", LocalDate.now().toString()));
        System.out.println();
        System.out.println(GradleDependenciesWriter.toString(gradleDependencies));
    }
    
}
