/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.modeler.dialog.ResolveDbRelationshipDialog;
import org.apache.cayenne.modeler.undo.CayenneCompoundEdit;
import org.apache.cayenne.modeler.util.ProjectUtil;

public class RelationshipUndoableEdit
extends CayenneCompoundEdit {
    private DbRelationship relationship;

    public void redo() throws CannotRedoException {
        super.redo();
        ResolveDbRelationshipDialog dialog = new ResolveDbRelationshipDialog(this.relationship, false);
        dialog.setVisible(true);
    }

    public void undo() throws CannotUndoException {
        super.undo();
        ResolveDbRelationshipDialog dialog = new ResolveDbRelationshipDialog(this.relationship, false);
        dialog.setVisible(true);
    }

    public String getRedoPresentationName() {
        return "Redo Edit relationship";
    }

    public String getUndoPresentationName() {
        return "Undo Edit relationship";
    }

    public boolean canUndo() {
        return this.hasEdits();
    }

    public RelationshipUndoableEdit(DbRelationship relationship) {
        this.relationship = relationship;
    }

    public void addDbJoinAddUndo(final DbJoin join) {
        this.addEdit(new AbstractUndoableEdit(){

            public void redo() throws CannotRedoException {
                RelationshipUndoableEdit.this.relationship.addJoin(join);
            }

            public void undo() throws CannotUndoException {
                RelationshipUndoableEdit.this.relationship.removeJoin(join);
            }
        });
    }

    public void addDbJoinRemoveUndo(final DbJoin join) {
        this.addEdit(new AbstractUndoableEdit(){

            public void redo() throws CannotRedoException {
                RelationshipUndoableEdit.this.relationship.removeJoin(join);
            }

            public void undo() throws CannotUndoException {
                RelationshipUndoableEdit.this.relationship.addJoin(join);
            }
        });
    }

    public void addNameUndo(final DbRelationship relationship, final String oldName, final String newName) {
        this.addEdit(new AbstractUndoableEdit(){

            public void redo() throws CannotRedoException {
                ProjectUtil.setRelationshipName(relationship.getSourceEntity(), relationship, newName);
            }

            public void undo() throws CannotUndoException {
                ProjectUtil.setRelationshipName(relationship.getSourceEntity(), relationship, oldName);
            }
        });
    }
}

