/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.ProjectTreeView;
import org.apache.cayenne.modeler.editor.DataDomainView;
import org.apache.cayenne.modeler.editor.DataMapTabbedView;
import org.apache.cayenne.modeler.editor.EjbqlTabbedView;
import org.apache.cayenne.modeler.editor.EmbeddableTabbedView;
import org.apache.cayenne.modeler.editor.ObjEntityTabbedView;
import org.apache.cayenne.modeler.editor.ProcedureQueryView;
import org.apache.cayenne.modeler.editor.ProcedureTabbedView;
import org.apache.cayenne.modeler.editor.SQLTemplateTabbedView;
import org.apache.cayenne.modeler.editor.SelectQueryTabbedView;
import org.apache.cayenne.modeler.editor.datanode.DataNodeEditor;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityTabbedView;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.commons.logging.LogFactory;

public class EditorView
extends JPanel
implements ObjEntityDisplayListener,
DbEntityDisplayListener,
DomainDisplayListener,
DataMapDisplayListener,
DataNodeDisplayListener,
ProcedureDisplayListener,
QueryDisplayListener,
MultipleObjectsDisplayListener,
EmbeddableDisplayListener {
    private static final String EMPTY_VIEW = "Empty";
    private static final String DOMAIN_VIEW = "Domain";
    private static final String NODE_VIEW = "Node";
    private static final String DATA_MAP_VIEW = "DataMap";
    private static final String OBJ_VIEW = "ObjView";
    private static final String DB_VIEW = "DbView";
    private static final String EMBEDDABLE_VIEW = "EmbeddableView";
    private static final String PROCEDURE_VIEW = "ProcedureView";
    private static final String SELECT_QUERY_VIEW = "SelectQueryView";
    private static final String SQL_TEMPLATE_VIEW = "SQLTemplateView";
    private static final String PROCEDURE_QUERY_VIEW = "ProcedureQueryView";
    private static final String EJBQL_QUERY_VIEW = "EjbqlQueryView";
    protected ProjectController eventController;
    protected JSplitPane splitPane;
    protected Container detailPanel;
    protected CardLayout detailLayout;
    private ProjectTreeView treePanel;
    private DbEntityTabbedView dbDetailView;
    private ObjEntityTabbedView objDetailView;
    private EmbeddableTabbedView embeddableView;

    public ProjectTreeView getProjectTreeView() {
        return this.treePanel;
    }

    public EmbeddableTabbedView getEmbeddableView() {
        return this.embeddableView;
    }

    public DbEntityTabbedView getDbDetailView() {
        return this.dbDetailView;
    }

    public ObjEntityTabbedView getObjDetailView() {
        return this.objDetailView;
    }

    public EditorView(ProjectController eventController) {
        this.eventController = eventController;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.treePanel = new ProjectTreeView(this.eventController);
        this.treePanel.setMinimumSize(new Dimension(50, 200));
        this.detailPanel = new JPanel();
        this.splitPane = new JSplitPane(1, true);
        this.detailLayout = new CardLayout();
        this.detailPanel.setLayout(this.detailLayout);
        this.detailPanel.add((Component)new JPanel(), EMPTY_VIEW);
        DataDomainView domainView = new DataDomainView(this.eventController);
        this.detailPanel.add((Component)new JScrollPane(domainView), DOMAIN_VIEW);
        DataNodeEditor nodeController = new DataNodeEditor(this.eventController);
        this.detailPanel.add(nodeController.getView(), NODE_VIEW);
        DataMapTabbedView dataMapView = new DataMapTabbedView(this.eventController);
        this.detailPanel.add((Component)dataMapView, DATA_MAP_VIEW);
        ProcedureTabbedView procedureView = new ProcedureTabbedView(this.eventController);
        this.detailPanel.add((Component)procedureView, PROCEDURE_VIEW);
        SelectQueryTabbedView selectQueryView = new SelectQueryTabbedView(this.eventController);
        this.detailPanel.add((Component)selectQueryView, SELECT_QUERY_VIEW);
        SQLTemplateTabbedView sqlTemplateView = new SQLTemplateTabbedView(this.eventController);
        this.detailPanel.add((Component)sqlTemplateView, SQL_TEMPLATE_VIEW);
        ProcedureQueryView procedureQueryView = new ProcedureQueryView(this.eventController);
        this.detailPanel.add((Component)new JScrollPane(procedureQueryView), PROCEDURE_QUERY_VIEW);
        EjbqlTabbedView ejbqlQueryView = new EjbqlTabbedView(this.eventController);
        this.detailPanel.add((Component)ejbqlQueryView, EJBQL_QUERY_VIEW);
        this.embeddableView = new EmbeddableTabbedView(this.eventController);
        this.detailPanel.add((Component)new JScrollPane(this.embeddableView), EMBEDDABLE_VIEW);
        this.objDetailView = new ObjEntityTabbedView(this.eventController);
        this.detailPanel.add((Component)this.objDetailView, OBJ_VIEW);
        this.dbDetailView = new DbEntityTabbedView(this.eventController);
        this.detailPanel.add((Component)this.dbDetailView, DB_VIEW);
        this.splitPane.setLeftComponent(new JScrollPane(this.treePanel));
        this.splitPane.setRightComponent(this.detailPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
    }

    private void initController() {
        this.eventController.addDomainDisplayListener(this);
        this.eventController.addDataNodeDisplayListener(this);
        this.eventController.addDataMapDisplayListener(this);
        this.eventController.addObjEntityDisplayListener(this);
        this.eventController.addDbEntityDisplayListener(this);
        this.eventController.addProcedureDisplayListener(this);
        this.eventController.addQueryDisplayListener(this);
        this.eventController.addMultipleObjectsDisplayListener(this);
        this.eventController.addEmbeddableDisplayListener(this);
        try {
            Domain domain = this.eventController.getApplicationPreferenceDomain().getSubdomain(this.getClass());
            ComponentGeometry geometry = (ComponentGeometry)domain.getDetail("splitPane.divider", ComponentGeometry.class, true);
            geometry.bindIntProperty(this.splitPane, "dividerLocation", 150);
        }
        catch (Exception ex) {
            LogFactory.getLog(this.getClass()).error((Object)"Cannot bind divider property", (Throwable)ex);
        }
    }

    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        if (e.getProcedure() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, PROCEDURE_VIEW);
        }
    }

    public void currentDomainChanged(DomainDisplayEvent e) {
        if (e.getDomain() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, DOMAIN_VIEW);
        }
    }

    public void currentDataNodeChanged(DataNodeDisplayEvent e) {
        if (e.getDataNode() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, NODE_VIEW);
        }
    }

    public void currentDataMapChanged(DataMapDisplayEvent e) {
        if (e.getDataMap() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, DATA_MAP_VIEW);
        }
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getEntity() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, OBJ_VIEW);
        }
    }

    public void currentDbEntityChanged(EntityDisplayEvent e) {
        if (e.getEntity() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, DB_VIEW);
        }
    }

    public void currentQueryChanged(QueryDisplayEvent e) {
        Query query = e.getQuery();
        if (query instanceof SelectQuery) {
            this.detailLayout.show(this.detailPanel, SELECT_QUERY_VIEW);
        } else if (query instanceof SQLTemplate) {
            this.detailLayout.show(this.detailPanel, SQL_TEMPLATE_VIEW);
        } else if (query instanceof ProcedureQuery) {
            this.detailLayout.show(this.detailPanel, PROCEDURE_QUERY_VIEW);
        } else if (query instanceof EJBQLQuery) {
            this.detailLayout.show(this.detailPanel, EJBQL_QUERY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        }
    }

    public void currentObjectsChanged(MultipleObjectsDisplayEvent e) {
        this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
    }

    public void currentEmbeddableChanged(EmbeddableDisplayEvent e) {
        if (e.getEmbeddable() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, EMBEDDABLE_VIEW);
        }
    }
}

