/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeListener;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EmbeddableListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CopyAttributeAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CutAttributeAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.editor.EmbeddableAttributeTableModel;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class EmbeddableAttributeTab
extends JPanel
implements EmbeddableAttributeListener,
EmbeddableDisplayListener,
EmbeddableListener,
ExistingSelectionProcessor {
    protected ProjectController mediator;
    protected CayenneTable table;
    JButton resolve;

    public EmbeddableAttributeTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(CreateAttributeAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(app.getAction(RemoveAttributeAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(app.getAction(CutAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CopyAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(PasteAction.getActionName()).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        JPopupMenu popup = new JPopupMenu();
        popup.add(app.getAction(RemoveAttributeAction.getActionName()).buildMenu());
        popup.addSeparator();
        popup.add(app.getAction(CutAttributeAction.getActionName()).buildMenu());
        popup.add(app.getAction(CopyAttributeAction.getActionName()).buildMenu());
        popup.add(app.getAction(PasteAction.getActionName()).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addEmbeddableAttributeListener(this);
        this.mediator.addEmbeddableDisplayListener(this);
        this.mediator.addEmbeddableListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EmbeddableAttributeTab.this.processExistingSelection(e);
            }
        });
        this.mediator.getApplication().getActionManager().setupCCP(this.table, CutAttributeAction.getActionName(), CopyAttributeAction.getActionName());
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        EmbeddableAttribute[] attrs = new EmbeddableAttribute[]{};
        if (this.table.getSelectedRow() >= 0) {
            EmbeddableAttributeTableModel model = (EmbeddableAttributeTableModel)this.table.getModel();
            int[] sel = this.table.getSelectedRows();
            attrs = new EmbeddableAttribute[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                attrs[i] = model.getEmbeddableAttribute(sel[i]);
            }
            if (sel.length == 1) {
                UIUtil.scrollToSelectedRow(this.table);
            }
        }
        EmbeddableAttributeDisplayEvent ev = new EmbeddableAttributeDisplayEvent((Object)this, this.mediator.getCurrentEmbeddable(), attrs, this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireEmbeddableAttributeDisplayEvent(ev);
    }

    private void rebuildTable(Embeddable emb) {
        EmbeddableAttributeTableModel model = new EmbeddableAttributeTableModel(emb, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.setUpTableStructure(model);
    }

    private void setUpTableStructure(EmbeddableAttributeTableModel model) {
        TableColumn nameColumn = this.table.getColumnModel().getColumn(0);
        nameColumn.setMinWidth(150);
        TableColumn typeColumn = this.table.getColumnModel().getColumn(1);
        typeColumn.setMinWidth(150);
        JComboBox javaTypesCombo = CayenneWidgetFactory.createComboBox(ModelerUtil.getRegisteredTypeNames(), false);
        AutoCompletion.enable(javaTypesCombo, false, true);
        typeColumn.setCellEditor(CayenneWidgetFactory.createCellEditor(javaTypesCombo));
        TableColumn dbAttrColumn = this.table.getColumnModel().getColumn(2);
        dbAttrColumn.setMinWidth(150);
    }

    public void selectAttributes(EmbeddableAttribute[] embAttrs) {
        ModelerUtil.updateActions(embAttrs.length, RemoveAttributeAction.getActionName(), CopyAttributeAction.getActionName(), CutAttributeAction.getActionName());
        EmbeddableAttributeTableModel model = (EmbeddableAttributeTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[embAttrs.length];
        for (int i = 0; i < embAttrs.length; ++i) {
            newSel[i] = listAttrs.indexOf(embAttrs[i]);
        }
        this.table.select(newSel);
    }

    public void embeddableAttributeAdded(EmbeddableAttributeEvent e) {
        this.rebuildTable(e.getEmbeddable());
        this.table.select(e.getEmbeddableAttribute());
    }

    public void embeddableAttributeChanged(EmbeddableAttributeEvent e) {
        this.table.select(e.getEmbeddableAttribute());
    }

    public void embeddableAttributeRemoved(EmbeddableAttributeEvent e) {
        EmbeddableAttributeTableModel model = (EmbeddableAttributeTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getEmbeddableAttribute());
        model.removeRow(e.getEmbeddableAttribute());
        this.table.select(ind);
    }

    public void currentEmbeddableChanged(EmbeddableDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        Embeddable embeddable = e.getEmbeddable();
        if (embeddable != null) {
            this.rebuildTable(embeddable);
        }
    }

    public void embeddableAdded(EmbeddableEvent e, DataMap map) {
    }

    public void embeddableChanged(EmbeddableEvent e, DataMap map) {
    }

    public void embeddableRemoved(EmbeddableEvent e, DataMap map) {
    }
}

