/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;

public class JTextFieldUndoListener
implements UndoableEditListener {
    private UndoManager undoManager;
    private CompoundEdit compoundEdit;
    private JTextComponent textComponent;
    private UndoDocumentListener undoDocumentListener;
    private Object currentObj;
    private TreePath[] paths;
    private int lastOffset;
    private int lastLength;
    private JTextFieldUndoListener self = this;
    private boolean inProgress = false;

    public JTextFieldUndoListener(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.undoManager = Application.getInstance().getUndoManager();
        this.undoDocumentListener = new UndoDocumentListener();
        this.textComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (JTextFieldUndoListener.this.self.currentObj == null) {
                    JTextFieldUndoListener.this.self.currentObj = JTextFieldUndoListener.this.getProjectController().getCurrentObject();
                    JTextFieldUndoListener.access$502(JTextFieldUndoListener.this.self, ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView().getProjectTreeView().getSelectionPaths());
                }
            }

            public void focusLost(FocusEvent e) {
                JTextFieldUndoListener.this.self.currentObj = null;
                if (JTextFieldUndoListener.this.compoundEdit != null) {
                    JTextFieldUndoListener.this.compoundEdit.end();
                    JTextFieldUndoListener.this.compoundEdit = null;
                }
            }
        });
        this.textComponent.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                JTextFieldUndoListener.this.inProgress = true;
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.inProgress) {
            if (this.compoundEdit == null) {
                this.compoundEdit = this.startCompoundEdit(e.getEdit());
            } else {
                int lengthChange;
                AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
                if (event.getType().equals(DocumentEvent.EventType.CHANGE)) {
                    this.compoundEdit.addEdit(e.getEdit());
                    return;
                }
                int offsetChange = this.textComponent.getCaretPosition() - this.lastOffset;
                if (offsetChange == (lengthChange = this.textComponent.getDocument().getLength() - this.lastLength) && Math.abs(offsetChange) == 1) {
                    this.compoundEdit.addEdit(e.getEdit());
                    this.lastOffset = this.textComponent.getCaretPosition();
                    this.lastLength = this.textComponent.getDocument().getLength();
                    return;
                }
                this.compoundEdit.end();
                this.compoundEdit = this.startCompoundEdit(e.getEdit());
            }
            this.inProgress = !this.inProgress;
        }
    }

    private CompoundEdit startCompoundEdit(UndoableEdit e) {
        this.lastOffset = this.textComponent.getCaretPosition();
        this.lastLength = this.textComponent.getDocument().getLength();
        TextCompoundEdit compoundEdit = new TextCompoundEdit();
        compoundEdit.addEdit(e);
        this.undoManager.addEdit(compoundEdit);
        return compoundEdit;
    }

    private ProjectController getProjectController() {
        return Application.getInstance().getFrameController().getProjectController();
    }

    static /* synthetic */ TreePath[] access$502(JTextFieldUndoListener x0, TreePath[] x1) {
        x0.paths = x1;
        return x1;
    }

    private class TextCompoundEdit
    extends CompoundEdit {
        private TextCompoundEdit() {
        }

        public boolean isInProgress() {
            return false;
        }

        public String getRedoPresentationName() {
            return "Redo Text Change";
        }

        public String getUndoPresentationName() {
            return "Undo Text Change";
        }

        public boolean canRedo() {
            return true;
        }

        public void undo() throws CannotUndoException {
            JTextFieldUndoListener.this.textComponent.getDocument().addDocumentListener(JTextFieldUndoListener.this.undoDocumentListener);
            if (JTextFieldUndoListener.this.compoundEdit != null) {
                JTextFieldUndoListener.this.compoundEdit.end();
            }
            this.restoreSelections();
            super.undo();
            JTextFieldUndoListener.this.compoundEdit = null;
            JTextFieldUndoListener.this.textComponent.getDocument().removeDocumentListener(JTextFieldUndoListener.this.undoDocumentListener);
            JTextFieldUndoListener.this.textComponent.requestFocusInWindow();
            JTextFieldUndoListener.this.textComponent.selectAll();
        }

        public void redo() throws CannotRedoException {
            JTextFieldUndoListener.this.textComponent.getDocument().addDocumentListener(JTextFieldUndoListener.this.undoDocumentListener);
            super.redo();
            JTextFieldUndoListener.this.textComponent.getDocument().removeDocumentListener(JTextFieldUndoListener.this.undoDocumentListener);
            JTextFieldUndoListener.this.textComponent.requestFocusInWindow();
        }

        private void restoreSelections() {
            ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView().getProjectTreeView().setSelectionPaths(JTextFieldUndoListener.this.self.paths);
            if (JTextFieldUndoListener.this.self.currentObj instanceof DataMap) {
                JTextFieldUndoListener.this.getProjectController().fireDataMapDisplayEvent(new DataMapDisplayEvent(this, (DataMap)JTextFieldUndoListener.this.self.currentObj, JTextFieldUndoListener.this.getProjectController().getCurrentDataDomain(), JTextFieldUndoListener.this.getProjectController().getCurrentDataNode()));
            } else if (JTextFieldUndoListener.this.self.currentObj instanceof ObjEntity) {
                JTextFieldUndoListener.this.getProjectController().fireObjEntityDisplayEvent(new EntityDisplayEvent(this, (Entity)((ObjEntity)JTextFieldUndoListener.this.self.currentObj), JTextFieldUndoListener.this.getProjectController().getCurrentDataMap(), JTextFieldUndoListener.this.getProjectController().getCurrentDataNode(), JTextFieldUndoListener.this.getProjectController().getCurrentDataDomain()));
            } else if (JTextFieldUndoListener.this.self.currentObj instanceof DbEntity) {
                JTextFieldUndoListener.this.getProjectController().fireDbEntityDisplayEvent(new EntityDisplayEvent(this, (Entity)((DbEntity)JTextFieldUndoListener.this.self.currentObj), JTextFieldUndoListener.this.getProjectController().getCurrentDataMap(), JTextFieldUndoListener.this.getProjectController().getCurrentDataNode(), JTextFieldUndoListener.this.getProjectController().getCurrentDataDomain()));
            }
        }
    }

    private class UndoDocumentListener
    implements DocumentListener {
        private UndoDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(final DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int offset = e.getOffset() + e.getLength();
                    offset = Math.min(offset, JTextFieldUndoListener.this.textComponent.getDocument().getLength());
                    JTextFieldUndoListener.this.textComponent.setCaretPosition(offset);
                }
            });
        }

        public void removeUpdate(DocumentEvent e) {
            JTextFieldUndoListener.this.textComponent.setCaretPosition(e.getOffset());
        }
    }
}

