/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.trans.DataObjectMatchTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.QueryAssemblerHelper;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.QualifiedQuery;
import org.apache.cayenne.query.Query;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.Transformer;

public class QualifierTranslator
extends QueryAssemblerHelper
implements TraversalHandler {
    protected DataObjectMatchTranslator objectMatchTranslator;
    protected boolean matchingObject;

    public QualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    protected void doAppendPart() throws IOException {
        this.doAppendPart(this.extractQualifier());
    }

    protected void doAppendPart(Expression rootNode) throws IOException {
        if (rootNode == null) {
            return;
        }
        rootNode.traverse(this);
    }

    protected Expression extractQualifier() {
        Expression dbQualifier;
        Query q = this.queryAssembler.getQuery();
        Expression qualifier = ((QualifiedQuery)q).getQualifier();
        ObjEntity entity = this.getObjEntity();
        if (entity != null) {
            Expression entityQualifier;
            EntityInheritanceTree tree = this.queryAssembler.getEntityResolver().lookupInheritanceTree(entity);
            Expression expression = entityQualifier = tree != null ? tree.qualifierForEntityAndSubclasses() : entity.getDeclaredQualifier();
            if (entityQualifier != null) {
                Expression expression2 = qualifier = qualifier != null ? qualifier.andExp(entityQualifier) : entityQualifier;
            }
        }
        if (this.getDbEntity() != null && (dbQualifier = this.getDbEntity().getQualifier()) != null) {
            dbQualifier = dbQualifier.transform(new DbEntityQualifierTransformer());
            qualifier = qualifier == null ? dbQualifier : qualifier.andExp(dbQualifier);
        }
        return qualifier;
    }

    protected void detectObjectMatch(Expression exp) {
        this.matchingObject = false;
        if (exp.getOperandCount() != 2) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            Object op = exp.getOperand(i);
            if (!(op instanceof Persistent) && !(op instanceof ObjectId)) continue;
            this.matchingObject = true;
            if (this.objectMatchTranslator == null) {
                this.objectMatchTranslator = new DataObjectMatchTranslator();
                break;
            }
            this.objectMatchTranslator.reset();
            break;
        }
    }

    protected void appendObjectMatch() throws IOException {
        if (!this.matchingObject || this.objectMatchTranslator == null) {
            throw new IllegalStateException("An invalid attempt to append object match.");
        }
        this.matchingObject = false;
        boolean first = true;
        DbRelationship relationship = this.objectMatchTranslator.getRelationship();
        if (!relationship.isToMany() && !relationship.isToPK()) {
            this.queryAssembler.dbRelationshipAdded(relationship, JoinType.INNER, this.objectMatchTranslator.getJoinSplitAlias());
        }
        Iterator<String> it = this.objectMatchTranslator.keys();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.out.append(" AND ");
            }
            String key = it.next();
            DbAttribute attr = this.objectMatchTranslator.getAttribute(key);
            Object val = this.objectMatchTranslator.getValue(key);
            this.processColumn(attr);
            this.out.append(this.objectMatchTranslator.getOperation());
            this.appendLiteral(val, attr, this.objectMatchTranslator.getExpression());
        }
        this.objectMatchTranslator.reset();
    }

    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (!hasMoreChildren) {
            return;
        }
        Appendable out = this.matchingObject ? new StringBuilder() : this.out;
        try {
            switch (node.getType()) {
                case 0: {
                    out.append(" AND ");
                    break;
                }
                case 1: {
                    out.append(" OR ");
                    break;
                }
                case 3: {
                    if (childIndex == 0 && node.getOperandCount() == 2 && node.getOperand(1) == null) {
                        out.append(" IS ");
                        break;
                    }
                    out.append(" = ");
                    break;
                }
                case 4: {
                    if (childIndex == 0 && node.getOperandCount() == 2 && node.getOperand(1) == null) {
                        out.append(" IS NOT ");
                        break;
                    }
                    out.append(" <> ");
                    break;
                }
                case 5: {
                    out.append(" < ");
                    break;
                }
                case 6: {
                    out.append(" > ");
                    break;
                }
                case 7: {
                    out.append(" <= ");
                    break;
                }
                case 8: {
                    out.append(" >= ");
                    break;
                }
                case 10: {
                    out.append(" IN ");
                    break;
                }
                case 36: {
                    out.append(" NOT IN ");
                    break;
                }
                case 11: {
                    out.append(" LIKE ");
                    break;
                }
                case 37: {
                    out.append(" NOT LIKE ");
                    break;
                }
                case 12: {
                    out.append(") LIKE UPPER(");
                    break;
                }
                case 38: {
                    out.append(") NOT LIKE UPPER(");
                    break;
                }
                case 16: {
                    out.append(" + ");
                    break;
                }
                case 17: {
                    out.append(" - ");
                    break;
                }
                case 18: {
                    out.append(" * ");
                    break;
                }
                case 19: {
                    out.append(" / ");
                    break;
                }
                case 9: {
                    if (childIndex == 0) {
                        out.append(" BETWEEN ");
                        break;
                    }
                    if (childIndex != 1) break;
                    out.append(" AND ");
                    break;
                }
                case 35: {
                    if (childIndex == 0) {
                        out.append(" NOT BETWEEN ");
                        break;
                    }
                    if (childIndex != 1) break;
                    out.append(" AND ");
                }
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", ioex);
        }
        if (this.matchingObject) {
            this.objectMatchTranslator.setOperation(out.toString());
            this.objectMatchTranslator.setExpression(node);
        }
    }

    public void startNode(Expression node, Expression parentNode) {
        int count = node.getOperandCount();
        if (count == 2) {
            this.detectObjectMatch(node);
        }
        try {
            if (this.parenthesisNeeded(node, parentNode)) {
                this.out.append('(');
            }
            if (count == 0) {
                if (node.getType() == 21) {
                    this.out.append("1 = 1");
                }
                if (node.getType() == 22) {
                    this.out.append("1 = 0");
                }
            }
            if (count == 1) {
                if (node.getType() == 20) {
                    this.out.append('-');
                } else if (node.getType() == 2) {
                    this.out.append("NOT ");
                }
            } else if (node.getType() == 12 || node.getType() == 38) {
                this.out.append("UPPER(");
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", ioex);
        }
    }

    public void endNode(Expression node, Expression parentNode) {
        try {
            if (node.getOperandCount() == 2 && this.matchingObject) {
                this.appendObjectMatch();
            }
            if (this.parenthesisNeeded(node, parentNode)) {
                this.out.append(')');
            }
            if (node.getType() == 12 || node.getType() == 38) {
                this.out.append(')');
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", ioex);
        }
    }

    public void objectNode(Object leaf, Expression parentNode) {
        try {
            if (parentNode.getType() == 26) {
                this.appendObjPath(parentNode);
            } else if (parentNode.getType() == 27) {
                this.appendDbPath(parentNode);
            } else if (parentNode.getType() == 28) {
                this.appendList(parentNode, this.paramsDbType(parentNode));
            } else {
                this.appendLiteral(leaf, this.paramsDbType(parentNode), parentNode);
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", ioex);
        }
    }

    protected boolean parenthesisNeeded(Expression node, Expression parentNode) {
        if (parentNode == null) {
            return false;
        }
        if (node.getOperandCount() > 1) {
            return true;
        }
        if (node.getType() == 26) {
            return false;
        }
        return node.getType() != 27;
    }

    private final void appendList(Expression listExpr, DbAttribute paramDesc) throws IOException {
        ResettableIterator it = null;
        Object list = listExpr.getOperand(0);
        if (list instanceof List) {
            it = ((List)list).iterator();
        } else if (list instanceof Object[]) {
            it = IteratorUtils.arrayIterator((Object[])list);
        } else {
            String className = list != null ? list.getClass().getName() : "<null>";
            throw new IllegalArgumentException("Unsupported type for the list expressions: " + className);
        }
        if (it.hasNext()) {
            this.appendLiteral(it.next(), paramDesc, listExpr);
        } else {
            return;
        }
        while (it.hasNext()) {
            this.out.append(", ");
            this.appendLiteral(it.next(), paramDesc, listExpr);
        }
    }

    protected void appendLiteral(Object val, DbAttribute attr, Expression parentExpression) throws IOException {
        if (!this.matchingObject) {
            super.appendLiteral(val, attr, parentExpression);
        } else if (val == null || val instanceof Persistent) {
            this.objectMatchTranslator.setDataObject((Persistent)val);
        } else if (val instanceof ObjectId) {
            this.objectMatchTranslator.setObjectId((ObjectId)val);
        } else {
            throw new IllegalArgumentException("Attempt to use literal other than DataObject during object match.");
        }
    }

    protected void processRelTermination(DbRelationship rel, JoinType joinType, String joinSplitAlias) throws IOException {
        if (!this.matchingObject) {
            super.processRelTermination(rel, joinType, joinSplitAlias);
        } else {
            if (rel.isToMany()) {
                this.queryAssembler.dbRelationshipAdded(rel, joinType, joinSplitAlias);
            }
            this.objectMatchTranslator.setRelationship(rel, joinSplitAlias);
        }
    }

    class DbEntityQualifierTransformer
    implements Transformer {
        DbEntityQualifierTransformer() {
        }

        public Object transform(Object input) {
            if (input instanceof ASTObjPath) {
                return new ASTDbPath(((SimpleNode)input).getOperand(0));
            }
            return input;
        }
    }
}

