/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.ProjectTraversal;
import org.apache.cayenne.project.ProjectTraversalHandler;

public class ProjectTreeModel
extends DefaultTreeModel {
    public static DefaultMutableTreeNode wrapProject(Project project) {
        return ProjectTreeModel.wrapProjectNode(project);
    }

    public static DefaultMutableTreeNode wrapProjectNode(Object node) {
        TraversalHelper helper = new TraversalHelper();
        new ProjectTraversal(helper, true).traverse(node);
        return helper.getStartNode();
    }

    public static DefaultMutableTreeNode wrapProjectNode(Object node, DefaultMutableTreeNode parentPath) {
        TraversalHelper helper = new TraversalHelper();
        ProjectPath path = new ProjectPath();
        if (parentPath != null) {
            path = helper.registerNodes(parentPath.getPath());
        }
        new ProjectTraversal(helper).traverse(node, path);
        return helper.getStartNode();
    }

    public ProjectTreeModel(Project project) {
        super(ProjectTreeModel.wrapProject(project));
    }

    public void positionNode(MutableTreeNode parent, DefaultMutableTreeNode treeNode, Comparator comparator) {
        if (treeNode == null) {
            return;
        }
        if (parent == null && treeNode != this.getRoot() && (parent = (MutableTreeNode)treeNode.getParent()) == null) {
            parent = this.getRootNode();
        }
        Object object = treeNode.getUserObject();
        int len = parent.getChildCount();
        int ins = -1;
        int rm = -1;
        for (int i = 0; i < len; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (node == treeNode) {
                rm = i;
                continue;
            }
            if (ins >= 0 || comparator.compare(object, node.getUserObject()) > 0) continue;
            ins = i;
        }
        if (ins < 0) {
            ins = len;
        }
        if (rm == ins) {
            return;
        }
        if (rm >= 0) {
            this.removeNodeFromParent(treeNode);
            if (rm < ins) {
                --ins;
            }
        }
        this.insertNodeInto(treeNode, parent, ins);
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)super.getRoot();
    }

    public DefaultMutableTreeNode getNodeForObjectPath(Object[] path) {
        if (path == null || path.length == 0) {
            return null;
        }
        DefaultMutableTreeNode currentNode = this.getRootNode();
        int start = 0;
        if (currentNode.getUserObject() == path[0]) {
            start = 1;
        }
        for (int i = start; i < path.length; ++i) {
            DefaultMutableTreeNode foundNode = null;
            Enumeration<TreeNode> children = currentNode.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                if (child.getUserObject() != path[i]) continue;
                foundNode = child;
                break;
            }
            if (foundNode == null) {
                return null;
            }
            currentNode = foundNode;
        }
        return currentNode;
    }

    class CopyTraversalHelper
    extends TraversalHelper {
        CopyTraversalHelper() {
        }

        public void projectNode(ProjectPath nodePath) {
            DefaultMutableTreeNode node;
            if (this.startNode == null) {
                node = this.startNode = new DefaultMutableTreeNode(nodePath.getObject());
            } else {
                DefaultMutableTreeNode original = ProjectTreeModel.this.getNodeForObjectPath(nodePath.getPath());
                DefaultMutableTreeNode nodeParent = (DefaultMutableTreeNode)this.nodesMap.get(nodePath.getObjectParent());
                node = new DefaultMutableTreeNode(original.getUserObject());
                nodeParent.add(node);
            }
            this.registerNode(node);
        }
    }

    static class TraversalHelper
    implements ProjectTraversalHandler {
        protected DefaultMutableTreeNode startNode;
        protected Map nodesMap = new HashMap();

        public DefaultMutableTreeNode getStartNode() {
            return this.startNode;
        }

        public ProjectPath registerNodes(TreeNode[] nodes) {
            ProjectPath path = new ProjectPath();
            for (TreeNode node : nodes) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                path = path.appendToPath(treeNode.getUserObject());
                this.registerNode(treeNode);
            }
            return path;
        }

        public void registerNode(DefaultMutableTreeNode node) {
            this.nodesMap.put(node.getUserObject(), node);
        }

        public void projectNode(ProjectPath nodePath) {
            Object parent = nodePath.getObjectParent();
            Object nodeObj = nodePath.getObject();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeObj);
            if (this.startNode == null) {
                this.startNode = node;
            } else {
                DefaultMutableTreeNode nodeParent = (DefaultMutableTreeNode)this.nodesMap.get(parent);
                nodeParent.add(node);
            }
            this.registerNode(node);
        }

        public boolean shouldReadChildren(Object node, ProjectPath parentPath) {
            if (node instanceof DataMap && parentPath != null && parentPath.getObject() instanceof DataNode) {
                return false;
            }
            return node instanceof Project || node instanceof DataDomain || node instanceof DataMap || node instanceof DataNode;
        }
    }
}

