/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.RedoAction;
import org.apache.cayenne.modeler.action.UndoAction;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CayenneUndoManager
extends UndoManager {
    private Application application;

    public CayenneUndoManager(Application application) {
        this.application = application;
        this.setLimit(100);
    }

    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.updateUI();
    }

    public synchronized boolean addEdit(UndoableEdit anEdit) {
        boolean result = super.addEdit(anEdit);
        this.updateUI();
        return result;
    }

    public synchronized void redo() throws CannotRedoException {
        super.redo();
        this.updateUI();
    }

    public synchronized void undo() throws CannotUndoException {
        super.undo();
        this.updateUI();
    }

    private void updateUI() {
        CayenneAction undoAction = this.application.getActionManager().getAction(UndoAction.getActionName());
        CayenneAction redoAction = this.application.getActionManager().getAction(RedoAction.getActionName());
        undoAction.setEnabled(this.canUndo());
        redoAction.setEnabled(this.canRedo());
        undoAction.setName(this.getUndoPresentationName());
        redoAction.setName(this.getRedoPresentationName());
    }
}

