/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateAttributeUndoableEdit
extends CayenneUndoableEdit {
    private ObjEntity objEntity;
    private ObjAttribute objAttr;
    private DataDomain domain;
    private DataMap dataMap;
    private DbEntity dbEntity;
    private DbAttribute dbAttr;

    public boolean canRedo() {
        return true;
    }

    public String getPresentationName() {
        return "Create Attribute";
    }

    public void redo() throws CannotRedoException {
        this.restoreSelections();
        CreateAttributeAction action = (CreateAttributeAction)this.actionManager.getAction(CreateAttributeAction.getActionName());
        if (this.objEntity != null) {
            action.createObjAttribute(this.domain, this.dataMap, this.objEntity, this.objAttr);
        }
        if (this.dbEntity != null) {
            action.createDbAttribute(this.domain, this.dataMap, this.dbEntity, this.dbAttr);
        }
    }

    public void undo() throws CannotUndoException {
        this.restoreSelections();
        RemoveAttributeAction action = (RemoveAttributeAction)this.actionManager.getAction(RemoveAttributeAction.getActionName());
        if (this.objEntity != null) {
            action.removeObjAttributes(this.objEntity, new ObjAttribute[]{this.objAttr});
            this.controller.fireObjEntityDisplayEvent(new EntityDisplayEvent((Object)this, (Entity)this.objEntity, this.dataMap, this.domain));
        }
        if (this.dbEntity != null) {
            action.removeDbAttributes(this.dataMap, this.dbEntity, new DbAttribute[]{this.dbAttr});
            this.controller.fireDbEntityDisplayEvent(new EntityDisplayEvent((Object)this, (Entity)this.dbEntity, this.dataMap, this.domain));
        }
    }

    public CreateAttributeUndoableEdit(DataDomain domain, DataMap map, ObjEntity objEntity, ObjAttribute attr) {
        this.domain = domain;
        this.dataMap = map;
        this.objEntity = objEntity;
        this.objAttr = attr;
    }

    public CreateAttributeUndoableEdit(DataDomain domain, DataMap map, DbEntity dbEntity, DbAttribute attr) {
        this.domain = domain;
        this.dataMap = map;
        this.dbEntity = dbEntity;
        this.dbAttr = attr;
    }
}

