/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class RemoveRelationshipUndoableEdit
extends CayenneUndoableEdit {
    private ObjEntity objEntity;
    private ObjRelationship[] rels;
    private DbEntity dbEntity;
    private DbRelationship[] dbRels;

    public RemoveRelationshipUndoableEdit(ObjEntity objEntity, ObjRelationship[] rels) {
        this.objEntity = objEntity;
        this.rels = rels;
    }

    public RemoveRelationshipUndoableEdit(DbEntity dbEntity, DbRelationship[] dbRels) {
        this.dbEntity = dbEntity;
        this.dbRels = dbRels;
    }

    public String getPresentationName() {
        if (this.objEntity != null) {
            return "Remove Obj Relationship";
        }
        return "Remove Db Relationship";
    }

    public void redo() throws CannotRedoException {
        this.restoreSelections();
        RemoveRelationshipAction action = (RemoveRelationshipAction)this.actionManager.getAction(RemoveRelationshipAction.getActionName());
        if (this.objEntity != null) {
            action.removeObjRelationships(this.objEntity, this.rels);
        } else {
            action.removeDbRelationships(this.dbEntity, this.dbRels);
        }
    }

    public void undo() throws CannotUndoException {
        this.restoreSelections();
        CreateRelationshipAction action = (CreateRelationshipAction)this.actionManager.getAction(CreateRelationshipAction.getActionName());
        if (this.objEntity != null) {
            for (ObjRelationship r : this.rels) {
                action.createObjRelationship(this.objEntity, r);
            }
        } else {
            for (DbRelationship dr : this.dbRels) {
                action.createDbRelationship(this.dbEntity, dr);
            }
        }
    }
}

